/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.database.DatabaseManager;
import world.landfall.landfallessentials.regions.market.MarketConfig;

public class MarketDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(MarketDAO.class);

    public static Map<String, MarketConfig> loadAllMarkets() throws SQLException {
        HashMap<String, MarketConfig> markets = new HashMap<String, MarketConfig>();
        String sql = "SELECT name, floor_price, ceiling_price, price_exponent, description\nFROM markets\n";
        try (Connection conn = DatabaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                String name = rs.getString("name");
                int floorPrice = rs.getInt("floor_price");
                int ceilingPrice = rs.getInt("ceiling_price");
                double priceExponent = rs.getDouble("price_exponent");
                String description = rs.getString("description");
                MarketConfig market = new MarketConfig(name, floorPrice, ceilingPrice, priceExponent, description);
                markets.put(name, market);
            }
        }
        LOGGER.debug("Loaded {} markets from database", (Object)markets.size());
        return markets;
    }

    public static void saveMarket(MarketConfig market) throws SQLException {
        String sql = "INSERT INTO markets (name, floor_price, ceiling_price, price_exponent, description)\nVALUES (?, ?, ?, ?, ?)\nON CONFLICT(name) DO UPDATE SET\n    floor_price = excluded.floor_price,\n    ceiling_price = excluded.ceiling_price,\n    price_exponent = excluded.price_exponent,\n    description = excluded.description\n";
        try (Connection conn = DatabaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, market.getName());
            stmt.setInt(2, market.getFloorPrice());
            stmt.setInt(3, market.getCeilingPrice());
            stmt.setDouble(4, market.getPriceExponent());
            stmt.setString(5, market.getDescription());
            stmt.executeUpdate();
            LOGGER.debug("Saved market: {}", (Object)market.getName());
        }
    }

    public static void deleteMarket(String marketName) throws SQLException {
        String sql = "DELETE FROM markets WHERE name = ?";
        try (Connection conn = DatabaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, marketName);
            int deleted = stmt.executeUpdate();
            if (deleted > 0) {
                LOGGER.info("Deleted market: {}", (Object)marketName);
            }
        }
    }

    public static Map<String, String> loadRegionMarketMappings() throws SQLException {
        HashMap<String, String> mappings = new HashMap<String, String>();
        String sql = "SELECT region_name, market_name\nFROM market_regions\n";
        try (Connection conn = DatabaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                String regionName = rs.getString("region_name");
                String marketName = rs.getString("market_name");
                mappings.put(regionName, marketName);
            }
        }
        LOGGER.debug("Loaded {} region-market mappings from database", (Object)mappings.size());
        return mappings;
    }

    public static Set<String> getRegionsInMarket(String marketName) throws SQLException {
        HashSet<String> regions = new HashSet<String>();
        String sql = "SELECT region_name\nFROM market_regions\nWHERE market_name = ?\n";
        try (Connection conn = DatabaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, marketName);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    regions.add(rs.getString("region_name"));
                }
            }
        }
        return regions;
    }

    public static void addRegionToMarket(String marketName, String regionName) throws SQLException {
        String sql = "INSERT OR IGNORE INTO market_regions (market_name, region_name)\nVALUES (?, ?)\n";
        try (Connection conn = DatabaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, marketName);
            stmt.setString(2, regionName);
            stmt.executeUpdate();
            LOGGER.debug("Added region '{}' to market '{}'", (Object)regionName, (Object)marketName);
        }
    }

    public static void removeRegionFromMarket(String marketName, String regionName) throws SQLException {
        String sql = "DELETE FROM market_regions\nWHERE market_name = ? AND region_name = ?\n";
        try (Connection conn = DatabaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, marketName);
            stmt.setString(2, regionName);
            int deleted = stmt.executeUpdate();
            if (deleted > 0) {
                LOGGER.debug("Removed region '{}' from market '{}'", (Object)regionName, (Object)marketName);
            }
        }
    }

    public static void removeRegionFromMarket(String regionName) throws SQLException {
        String sql = "DELETE FROM market_regions WHERE region_name = ?";
        try (Connection conn = DatabaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, regionName);
            int deleted = stmt.executeUpdate();
            if (deleted > 0) {
                LOGGER.debug("Removed region '{}' from its market", (Object)regionName);
            }
        }
    }

    public static void clearMarketRegions(String marketName) throws SQLException {
        String sql = "DELETE FROM market_regions WHERE market_name = ?";
        try (Connection conn = DatabaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, marketName);
            int deleted = stmt.executeUpdate();
            LOGGER.debug("Cleared {} regions from market '{}'", (Object)deleted, (Object)marketName);
        }
    }
}

