/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.death;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.death.DeathLocation;

public class DeathData
extends SavedData {
    private static final String DATA_NAME = "landfallessentials_deathdata";
    private final Map<UUID, DeathLocation> deathLocations = new HashMap<UUID, DeathLocation>();

    public DeathData() {
    }

    public DeathData(CompoundTag tag, HolderLookup.Provider provider) {
        CompoundTag locationsTag = tag.getCompound("deathLocations");
        for (String key : locationsTag.getAllKeys()) {
            try {
                if (key == null || key.length() != 36) {
                    LoggerFactory.getLogger(DeathData.class).warn("Invalid UUID format in death data, skipping: {}", (Object)key);
                    continue;
                }
                if (!key.matches("[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}")) {
                    LoggerFactory.getLogger(DeathData.class).warn("UUID does not match expected format, skipping: {}", (Object)key);
                    continue;
                }
                UUID playerUUID = UUID.fromString(key);
                DeathLocation location = DeathLocation.deserializeNBT(locationsTag.getCompound(key));
                if (location != null) {
                    this.deathLocations.put(playerUUID, location);
                    continue;
                }
                LoggerFactory.getLogger(DeathData.class).warn("Failed to deserialize death location for UUID: {}", (Object)key);
            }
            catch (IllegalArgumentException e) {
                LoggerFactory.getLogger(DeathData.class).error("Failed to load death location for UUID {}: {}", (Object)key, (Object)e.getMessage());
            }
            catch (Exception e) {
                LoggerFactory.getLogger(DeathData.class).error("Unexpected error loading death location for key {}: {}", (Object)key, (Object)e.getMessage());
            }
        }
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        CompoundTag locationsTag = new CompoundTag();
        this.deathLocations.forEach((uuid, location) -> locationsTag.put(uuid.toString(), (Tag)location.serializeNBT()));
        tag.put("deathLocations", (Tag)locationsTag);
        return tag;
    }

    public static DeathData get(ServerLevel level) {
        DimensionDataStorage storage = level.getDataStorage();
        return (DeathData)storage.computeIfAbsent(new SavedData.Factory(DeathData::new, DeathData::new, null), DATA_NAME);
    }

    public void setDeathLocation(UUID playerUUID, DeathLocation location) {
        this.deathLocations.put(playerUUID, location);
        this.setDirty();
    }

    @Nullable
    public DeathLocation getDeathLocation(UUID playerUUID) {
        return this.deathLocations.get(playerUUID);
    }

    public void clearDeathLocation(UUID playerUUID) {
        this.deathLocations.remove(playerUUID);
        this.setDirty();
    }
}

