/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.death;

import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public record DeathLocation(ResourceKey<Level> dimension, double x, double y, double z) {
    private static final String DIMENSION_KEY = "dimension";
    private static final String X_KEY = "x";
    private static final String Y_KEY = "y";
    private static final String Z_KEY = "z";

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putString(DIMENSION_KEY, this.dimension.location().toString());
        tag.putDouble(X_KEY, this.x);
        tag.putDouble(Y_KEY, this.y);
        tag.putDouble(Z_KEY, this.z);
        return tag;
    }

    public static DeathLocation deserializeNBT(CompoundTag tag) {
        ResourceLocation dimensionLocation = ResourceLocation.tryParse((String)tag.getString(DIMENSION_KEY));
        if (dimensionLocation == null) {
            throw new IllegalArgumentException("Invalid dimension resource location in NBT: " + tag.getString(DIMENSION_KEY));
        }
        ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimensionLocation);
        double x = tag.getDouble(X_KEY);
        double y = tag.getDouble(Y_KEY);
        double z = tag.getDouble(Z_KEY);
        return new DeathLocation((ResourceKey<Level>)dimension, x, y, z);
    }
}

