/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.entity;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import world.landfall.landfallessentials.registry.ModEntityTypes;
import world.landfall.landfallessentials.registry.ModItems;

public class ThrownSnowbreakerEntity
extends ThrowableProjectile {
    private static final EntityDataAccessor<Boolean> DATA_RETURNING = SynchedEntityData.defineId(ThrownSnowbreakerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private ItemStack hammerStack = new ItemStack((ItemLike)ModItems.SNOWBREAKER.get());
    private int ticksFlying = 0;
    private static final int MAX_FLIGHT_TIME = 100;

    public ThrownSnowbreakerEntity(EntityType<? extends ThrownSnowbreakerEntity> type, Level level) {
        super(type, level);
    }

    public ThrownSnowbreakerEntity(Level level, Player thrower) {
        super(ModEntityTypes.THROWN_SNOWBREAKER.get(), (LivingEntity)thrower, level);
        this.hammerStack = thrower.getMainHandItem().copy();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_RETURNING, (Object)false);
    }

    public boolean isReturning() {
        return (Boolean)this.entityData.get(DATA_RETURNING);
    }

    public void setReturning(boolean returning) {
        this.entityData.set(DATA_RETURNING, (Object)returning);
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    public void tick() {
        Vec3 velocity;
        double speed2;
        super.tick();
        ++this.ticksFlying;
        if (this.ticksFlying > 100) {
            Entity entity;
            if (!this.level().isClientSide && (entity = this.getOwner()) instanceof Player) {
                Player player = (Player)entity;
                if (!player.getInventory().add(this.hammerStack)) {
                    player.drop(this.hammerStack, false);
                }
                this.level().playSound(null, player.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            this.discard();
            return;
        }
        if (this.level().isClientSide && (speed2 = (velocity = this.getDeltaMovement()).length()) > 0.1) {
            Vec3 velocityNorm = velocity.normalize();
            Vec3 particleOffset = velocityNorm.scale(-0.3);
            double angle = Math.toRadians((float)this.ticksFlying * 20.0f);
            for (int i = 0; i < 3; ++i) {
                double perpSpread = (this.random.nextDouble() - 0.5) * 0.6;
                double parallelSpread = (this.random.nextDouble() - 0.5) * 0.2;
                double offsetRadius = this.random.nextDouble() * 0.5;
                double offsetAngle = angle + this.random.nextDouble() * Math.PI * 2.0;
                double offsetX = particleOffset.x + velocityNorm.x * parallelSpread;
                double offsetY = particleOffset.y + velocityNorm.y * parallelSpread + Math.sin(offsetAngle) * offsetRadius;
                double offsetZ = particleOffset.z + velocityNorm.z * parallelSpread + Math.cos(offsetAngle) * offsetRadius;
                this.level().addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, this.getX() + offsetX, this.getY() + 0.3 + offsetY, this.getZ() + offsetZ, (this.random.nextDouble() - 0.5) * 0.05, -0.02, (this.random.nextDouble() - 0.5) * 0.05);
            }
        }
        if (!this.level().isClientSide) {
            Entity speed2;
            double distance;
            if (this.getOwner() == null || !this.getOwner().isAlive()) {
                this.spawnAtLocation(this.hammerStack);
                this.discard();
                return;
            }
            if (this.getOwner() != null && !this.isReturning() && ((distance = (double)this.distanceTo(this.getOwner())) > 50.0 || this.ticksFlying > 50)) {
                this.setReturning(true);
            }
            if (this.isReturning() && (speed2 = this.getOwner()) instanceof Player) {
                Player player = (Player)speed2;
                Vec3 targetPos = player.position().add(0.0, (double)(player.getEyeHeight() / 2.0f), 0.0);
                Vec3 direction = targetPos.subtract(this.position());
                double actualDistance = direction.length();
                if (actualDistance < 2.0) {
                    if (!player.getInventory().add(this.hammerStack)) {
                        player.drop(this.hammerStack, false);
                    }
                    this.level().playSound(null, player.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.5f, 1.0f);
                    this.discard();
                } else if (actualDistance > 0.1) {
                    direction = direction.normalize();
                    double speed3 = Math.max(0.8, Math.min(2.0, actualDistance * 0.4));
                    this.setDeltaMovement(direction.scale(speed3));
                }
            }
        }
        float rotation = (float)this.ticksFlying * 20.0f;
        this.setYRot(rotation);
        this.setXRot(rotation);
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity owner;
        if (this.level().isClientSide) {
            return;
        }
        Entity target = result.getEntity();
        if (target != (owner = this.getOwner()) && target instanceof LivingEntity) {
            DamageSource damageSource;
            if (owner instanceof Player) {
                Player player = (Player)owner;
                damageSource = this.damageSources().playerAttack(player);
            } else {
                damageSource = this.damageSources().thrown((Entity)this, owner);
            }
            DamageSource damageSource2 = damageSource;
            target.hurt(damageSource2, 10.0f);
            Vec3 velocity = this.getDeltaMovement().normalize().scale(0.3);
            target.setDeltaMovement(target.getDeltaMovement().add(velocity.x, 0.1, velocity.z));
            this.level().playSound(null, target.blockPosition(), SoundEvents.PLAYER_ATTACK_STRONG, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.hammerStack.hurtAndBreak(1, (ServerLevel)this.level(), (ServerPlayer)owner, item -> {});
            this.setReturning(true);
        }
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide && result.getType() == HitResult.Type.BLOCK) {
            this.setDeltaMovement(Vec3.ZERO);
            this.setReturning(true);
            this.level().playSound(null, this.blockPosition(), SoundEvents.ANVIL_LAND, SoundSource.BLOCKS, 0.5f, 1.5f);
        }
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean canCollideWith(Entity other) {
        return !other.equals((Object)this.getOwner()) && super.canCollideWith(other);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("HammerStack", this.hammerStack.save((HolderLookup.Provider)this.level().registryAccess()));
        tag.putBoolean("Returning", this.isReturning());
        tag.putInt("TicksFlying", this.ticksFlying);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("HammerStack")) {
            this.hammerStack = ItemStack.parse((HolderLookup.Provider)this.level().registryAccess(), (Tag)tag.getCompound("HammerStack")).orElse(new ItemStack((ItemLike)ModItems.SNOWBREAKER.get()));
        }
        this.setReturning(tag.getBoolean("Returning"));
        this.ticksFlying = tag.getInt("TicksFlying");
    }

    public ItemStack getHammerStack() {
        return this.hammerStack;
    }
}

