/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.item.custom;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class BlockItemWithLore
extends BlockItem {
    private final List<Component> lore;

    public BlockItemWithLore(Block block, Item.Properties properties, List<String> loreLines) {
        super(block, properties);
        this.lore = loreLines.stream().map(Component::literal).collect(Collectors.toList());
    }

    public BlockItemWithLore(Block block, Item.Properties properties, String ... loreLines) {
        this(block, properties, Arrays.asList(loreLines));
    }

    public void appendHoverText(ItemStack pStack, @Nullable Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pIsAdvanced);
        if (this.lore != null && !this.lore.isEmpty()) {
            pTooltipComponents.addAll(this.lore);
        }
    }
}

