/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.item.custom;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import world.landfall.landfallessentials.item.custom.ConduitType;
import world.landfall.landfallessentials.item.custom.ItemWithLore;

public class ConduitItem
extends ItemWithLore {
    private final ConduitType conduitType;

    public ConduitItem(ConduitType type, Item.Properties properties, String ... lore) {
        super(properties, lore);
        this.conduitType = type;
    }

    public ConduitType getConduitType() {
        return this.conduitType;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!level.isClientSide) {
                switch (this.conduitType) {
                    case CONTINUUM: {
                        player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 60, 0, true, false));
                        break;
                    }
                    case DOMINION: {
                        player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 60, 0, true, false));
                        player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 60, 0, true, false));
                        break;
                    }
                    case REVELATION: {
                        player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 240, 0, true, false));
                        break;
                    }
                    case ENTROPY: {
                        player.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, 60, 0, true, false));
                        player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 60, 0, true, false));
                        break;
                    }
                }
            }
        }
        super.inventoryTick(stack, level, entity, slotId, isSelected);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            switch (this.conduitType) {
                case SILENCE: {
                    if (player.getCooldowns().isOnCooldown((Item)this)) break;
                    player.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 600, 0, false, false));
                    player.getCooldowns().addCooldown((Item)this, 1200);
                    return InteractionResultHolder.success((Object)stack);
                }
                case CONTINUUM: {
                    if (player.getCooldowns().isOnCooldown((Item)this)) break;
                    player.addEffect(new MobEffectInstance(MobEffects.HEAL, 20, 0, false, false));
                    player.getCooldowns().addCooldown((Item)this, 1200);
                    return InteractionResultHolder.success((Object)stack);
                }
            }
        }
        return InteractionResultHolder.pass((Object)stack);
    }
}

