/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.moderation;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import world.landfall.landfallessentials.moderation.ModerationCommands;
import world.landfall.landfallessentials.moderation.ModerationManager;
import world.landfall.landfallessentials.moderation.approval.BanPattern;
import world.landfall.landfallessentials.moderation.approval.ClientApprovalSystem;
import world.landfall.landfallessentials.moderation.approval.ModApprovalEntry;
import world.landfall.landfallessentials.moderation.approval.ModApprovalStatus;

public class ClientApprovalCommands {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MMM d, yyyy h:mm:ss a");
    private static final int ITEMS_PER_PAGE = 15;

    private static String encodeForCommand(String text) {
        if (text == null) {
            return "";
        }
        return Base64.getEncoder().encodeToString(text.getBytes(StandardCharsets.UTF_8));
    }

    private static String decodeFromCommand(String encoded) {
        if (encoded == null || encoded.isEmpty()) {
            return "";
        }
        try {
            return new String(Base64.getDecoder().decode(encoded), StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            return encoded;
        }
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"clientapproval").requires(source -> source.hasPermission(2))).then(((LiteralArgumentBuilder)Commands.literal((String)"approve").then(Commands.literal((String)"mod").then(Commands.argument((String)"modId", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> ClientApprovalCommands.approveItem((CommandContext<CommandSourceStack>)ctx, true))))).then(Commands.literal((String)"resourcepack").then(Commands.argument((String)"modId", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> ClientApprovalCommands.approveItem((CommandContext<CommandSourceStack>)ctx, false)))))).then(((LiteralArgumentBuilder)Commands.literal((String)"ban").then(Commands.literal((String)"mod").then(Commands.argument((String)"modId", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> ClientApprovalCommands.banItem((CommandContext<CommandSourceStack>)ctx, true))))).then(Commands.literal((String)"resourcepack").then(Commands.argument((String)"modId", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> ClientApprovalCommands.banItem((CommandContext<CommandSourceStack>)ctx, false))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"clients").requires(source -> source.hasPermission(2))).executes(ClientApprovalCommands::showPlayersList)).then(Commands.literal((String)"full").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ModerationCommands::listPlayerClient)))).then(((LiteralArgumentBuilder)Commands.literal((String)"manage").then(((LiteralArgumentBuilder)Commands.literal((String)"mods").executes(ctx -> ClientApprovalCommands.showManagementInterface((CommandContext<CommandSourceStack>)ctx, true, 1))).then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> ClientApprovalCommands.showManagementInterface((CommandContext<CommandSourceStack>)ctx, true, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"resourcepacks").executes(ctx -> ClientApprovalCommands.showManagementInterface((CommandContext<CommandSourceStack>)ctx, false, 1))).then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> ClientApprovalCommands.showManagementInterface((CommandContext<CommandSourceStack>)ctx, false, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"patterns").executes(ClientApprovalCommands::listPatterns)).then(Commands.literal((String)"add").then(Commands.argument((String)"regex", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"description", (ArgumentType)StringArgumentType.greedyString()).executes(ClientApprovalCommands::addPattern))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"id", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ClientApprovalCommands::removePattern)))).then(Commands.literal((String)"test").then(Commands.argument((String)"regex", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(ClientApprovalCommands::testPattern))))));
    }

    private static int showPlayersList(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        List players = source.getServer().getPlayerList().getPlayers();
        if (players.isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)"\u00a77No players online."), false);
            return 0;
        }
        for (ServerPlayer player : players) {
            ModerationManager.requestModDataFromPlayer(player);
        }
        source.sendSuccess(() -> Component.literal((String)"\u00a76\u00a7l--- Client Mod Status ---"), false);
        source.sendSuccess(() -> Component.literal((String)"\u00a77Requesting data from all players..."), false);
        source.sendSuccess(() -> Component.literal((String)" "), false);
        ArrayList<PlayerStatusInfo> statusInfos = new ArrayList<PlayerStatusInfo>();
        for (ServerPlayer player : players) {
            ModerationManager.PlayerModData data = ModerationManager.getPlayerModData(player.getUUID());
            ClientApprovalSystem.PlayerApprovalStatus status = ClientApprovalSystem.evaluatePlayerStatus(data);
            statusInfos.add(new PlayerStatusInfo(player, status, data == null));
        }
        statusInfos.sort(Comparator.comparingInt(info -> info.status.getOverallStatus().getPriority()).reversed());
        for (PlayerStatusInfo info2 : statusInfos) {
            Component playerComponent = ClientApprovalCommands.formatPlayerStatus(info2);
            source.sendSuccess(() -> playerComponent, false);
        }
        source.sendSuccess(() -> Component.literal((String)" "), false);
        source.sendSuccess(() -> Component.literal((String)"\u00a77Use \u00a7e/clients manage [mods|resourcepacks]\u00a77 to review and approve/ban items"), false);
        return 1;
    }

    private static Component formatPlayerStatus(PlayerStatusInfo info) {
        String flagColor;
        String statusText;
        String colorCode;
        if (info.waitingForData) {
            colorCode = "\u00a77";
            statusText = "\u00a77[WAITING]";
        } else {
            switch (info.status.getOverallStatus()) {
                case BANNED: {
                    colorCode = "\u00a7c";
                    statusText = "\u00a7c[BANNED]";
                    break;
                }
                case UNCLASSIFIED: {
                    colorCode = "\u00a7e";
                    statusText = "\u00a7e[UNCLASSIFIED]";
                    break;
                }
                default: {
                    colorCode = "\u00a7a";
                    statusText = "\u00a7a[OK]";
                }
            }
        }
        StringBuilder hoverText = new StringBuilder();
        hoverText.append("\u00a77Player: \u00a7f").append(info.player.getName().getString()).append("\n");
        hoverText.append("\u00a77Status: ").append(statusText).append("\n");
        if (!info.status.getFlaggedMods().isEmpty()) {
            hoverText.append("\n\u00a7cFlagged Mods:\n");
            for (ClientApprovalSystem.FlaggedItem item : info.status.getFlaggedMods()) {
                flagColor = item.getStatus() == ModApprovalStatus.BANNED ? "\u00a7c" : "\u00a7e";
                hoverText.append(flagColor).append("- ").append(item.getDisplayName()).append(" (").append(item.getId()).append(")\n");
            }
        }
        if (!info.status.getFlaggedResourcepacks().isEmpty()) {
            hoverText.append("\n\u00a7cFlagged Resourcepacks:\n");
            for (ClientApprovalSystem.FlaggedItem item : info.status.getFlaggedResourcepacks()) {
                flagColor = item.getStatus() == ModApprovalStatus.BANNED ? "\u00a7c" : "\u00a7e";
                hoverText.append(flagColor).append("- ").append(item.getDisplayName()).append(" (").append(item.getId()).append(")\n");
            }
        }
        if (!info.waitingForData && !info.status.hasFlags()) {
            hoverText.append("\n\u00a7aAll mods and resourcepacks are approved!");
        }
        hoverText.append("\n\u00a77Click to view detailed client info");
        return Component.literal((String)(statusText + " " + colorCode + info.player.getName().getString())).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/clients full " + info.player.getName().getString())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)hoverText.toString()))));
    }

    private static int showManagementInterface(CommandContext<CommandSourceStack> context, boolean isMods, int page) {
        Map<String, ModApprovalEntry> entries;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String type = isMods ? "Mods" : "Resourcepacks";
        Map<String, ModApprovalEntry> map = entries = isMods ? ClientApprovalSystem.getModApprovals() : ClientApprovalSystem.getResourcepackApprovals();
        if (entries.isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)("\u00a77No " + type.toLowerCase() + " have been discovered yet.")), false);
            return 0;
        }
        List sortedEntries = entries.values().stream().sorted(Comparator.comparing(e -> -e.getStatus().getPriority()).thenComparing(ModApprovalEntry::getModId)).collect(Collectors.toList());
        int totalPages = (int)Math.ceil((double)sortedEntries.size() / 15.0);
        int currentPage = Math.min(Math.max(1, page), totalPages);
        int startIdx = (currentPage - 1) * 15;
        int endIdx = Math.min(startIdx + 15, sortedEntries.size());
        List pageEntries = sortedEntries.subList(startIdx, endIdx);
        source.sendSuccess(() -> Component.literal((String)("\u00a76\u00a7l--- " + type + " Management (Page " + currentPage + "/" + totalPages + ") ---")), false);
        source.sendSuccess(() -> Component.literal((String)("\u00a77Total " + type.toLowerCase() + ": " + entries.size())), false);
        source.sendSuccess(() -> Component.literal((String)" "), false);
        for (ModApprovalEntry entry : pageEntries) {
            Component entryComponent = ClientApprovalCommands.formatManagementEntry(entry, isMods);
            source.sendSuccess(() -> entryComponent, false);
        }
        source.sendSuccess(() -> Component.literal((String)" "), false);
        if (totalPages > 1) {
            MutableComponent nav = Component.literal((String)"");
            if (currentPage > 1) {
                MutableComponent prevButton = Component.literal((String)"\u00a7a[< Previous]").withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/clients manage " + (isMods ? "mods" : "resourcepacks") + " " + (currentPage - 1))));
                nav = nav.copy().append((Component)prevButton).append((Component)Component.literal((String)" "));
            }
            if (currentPage < totalPages) {
                MutableComponent nextButton = Component.literal((String)"\u00a7a[Next >]").withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/clients manage " + (isMods ? "mods" : "resourcepacks") + " " + (currentPage + 1))));
                nav = nav.copy().append((Component)nextButton);
            }
            MutableComponent finalNav = nav;
            source.sendSuccess(() -> ClientApprovalCommands.lambda$showManagementInterface$28((Component)finalNav), false);
        }
        return 1;
    }

    private static Component formatManagementEntry(ModApprovalEntry entry, boolean isMods) {
        String statusColor;
        String statusText = switch (entry.getStatus()) {
            case ModApprovalStatus.APPROVED -> {
                statusColor = "\u00a7a";
                yield "[APPROVED]";
            }
            case ModApprovalStatus.BANNED -> {
                statusColor = "\u00a7c";
                yield "[BANNED]";
            }
            default -> {
                statusColor = "\u00a7e";
                yield "[UNCLASSIFIED]";
            }
        };
        String type = isMods ? "mod" : "resourcepack";
        String encodedId = ClientApprovalCommands.encodeForCommand(entry.getModId());
        String approveCmd = "/clientapproval approve " + type + " " + encodedId;
        String banCmd = "/clientapproval ban " + type + " " + encodedId;
        String lastSeen = DATE_FORMAT.format(new Date(entry.getLastSeen()));
        MutableComponent statusComponent = Component.literal((String)(statusColor + statusText + " \u00a7f" + entry.getDisplayName() + " \u00a77(" + entry.getModId() + ") ")).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)("\u00a77ID: \u00a7f" + entry.getModId() + "\n\u00a77Display Name: \u00a7f" + entry.getDisplayName() + "\n\u00a77Status: " + statusColor + String.valueOf((Object)entry.getStatus()) + "\n\u00a77Last Seen: \u00a7f" + lastSeen)))));
        MutableComponent approveButton = Component.literal((String)"\u00a7a[\u2713]").withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, approveCmd)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"\u00a7aClick to approve"))));
        MutableComponent banButton = Component.literal((String)" \u00a7c[\u2717]").withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, banCmd)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"\u00a7cClick to ban"))));
        return statusComponent.copy().append((Component)approveButton).append((Component)banButton);
    }

    private static int listPatterns(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        List<BanPattern> patterns = ClientApprovalSystem.getBanPatterns();
        source.sendSuccess(() -> Component.literal((String)"\u00a76\u00a7l--- Ban Patterns ---"), false);
        source.sendSuccess(() -> Component.literal((String)("\u00a77Total patterns: " + patterns.size())), false);
        source.sendSuccess(() -> Component.literal((String)" "), false);
        if (patterns.isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)"\u00a77No ban patterns configured."), false);
            source.sendSuccess(() -> Component.literal((String)"\u00a77Use \u00a7e/clients patterns add <regex> <description>\u00a77 to add one."), false);
        } else {
            for (BanPattern pattern : patterns) {
                MutableComponent patternComponent = Component.literal((String)("\u00a7e#" + pattern.getId() + " \u00a77- \u00a7f" + pattern.getPatternString())).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)("\u00a77Pattern: \u00a7f" + pattern.getPatternString() + "\n\u00a77Description: \u00a7f" + pattern.getDescription() + "\n\n\u00a7cClick to remove")))).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/clients patterns remove " + pattern.getId())));
                source.sendSuccess(() -> ClientApprovalCommands.lambda$listPatterns$38((Component)patternComponent, pattern), false);
            }
        }
        source.sendSuccess(() -> Component.literal((String)" "), false);
        source.sendSuccess(() -> Component.literal((String)"\u00a77Use \u00a7e/clients patterns add <regex> <description>\u00a77 to add a pattern"), false);
        source.sendSuccess(() -> Component.literal((String)"\u00a77Use \u00a7e/clients patterns test <regex> <text>\u00a77 to test a pattern"), false);
        return 1;
    }

    private static int addPattern(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String regex = StringArgumentType.getString(context, (String)"regex");
        String description = StringArgumentType.getString(context, (String)"description");
        if (!BanPattern.isValidPattern(regex)) {
            source.sendFailure((Component)Component.literal((String)("\u00a7cInvalid regex pattern: " + regex)));
            return 0;
        }
        try {
            int id = ClientApprovalSystem.addBanPattern(regex, description);
            source.sendSuccess(() -> Component.literal((String)("\u00a7aAdded ban pattern #" + id + ": " + description)), false);
            source.sendSuccess(() -> Component.literal((String)("\u00a77Pattern: " + regex)), false);
        }
        catch (SQLException e) {
            source.sendFailure((Component)Component.literal((String)("\u00a7cFailed to save ban pattern: " + e.getMessage())));
            return 0;
        }
        return 1;
    }

    private static int removePattern(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        int id = IntegerArgumentType.getInteger(context, (String)"id");
        try {
            ClientApprovalSystem.removeBanPattern(id);
            source.sendSuccess(() -> Component.literal((String)("\u00a7aRemoved ban pattern #" + id)), false);
        }
        catch (SQLException e) {
            source.sendFailure((Component)Component.literal((String)("\u00a7cFailed to remove ban pattern: " + e.getMessage())));
            return 0;
        }
        return 1;
    }

    private static int testPattern(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String regex = StringArgumentType.getString(context, (String)"regex");
        String text = StringArgumentType.getString(context, (String)"text");
        if (!BanPattern.isValidPattern(regex)) {
            source.sendFailure((Component)Component.literal((String)("\u00a7cInvalid regex pattern: " + regex)));
            return 0;
        }
        try {
            BanPattern testPattern = new BanPattern(0, regex, "Test", System.currentTimeMillis());
            boolean matches = testPattern.matches(text);
            source.sendSuccess(() -> Component.literal((String)("\u00a77Pattern: \u00a7f" + regex)), false);
            source.sendSuccess(() -> Component.literal((String)("\u00a77Test text: \u00a7f" + text)), false);
            source.sendSuccess(() -> Component.literal((String)(matches ? "\u00a7aMatch found!" : "\u00a7cNo match")), false);
        }
        catch (Exception e) {
            source.sendFailure((Component)Component.literal((String)("\u00a7cError testing pattern: " + e.getMessage())));
            return 0;
        }
        return 1;
    }

    private static int approveItem(CommandContext<CommandSourceStack> context, boolean isMod) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String encodedId = StringArgumentType.getString(context, (String)"modId");
        String itemId = ClientApprovalCommands.decodeFromCommand(encodedId);
        String type = isMod ? "mod" : "resourcepack";
        try {
            if (isMod) {
                ClientApprovalSystem.setModApprovalStatus(itemId, ModApprovalStatus.APPROVED);
            } else {
                ClientApprovalSystem.setResourcepackApprovalStatus(itemId, ModApprovalStatus.APPROVED);
            }
            source.sendSuccess(() -> Component.literal((String)("\u00a7aApproved " + type + ": \u00a7f" + itemId)), false);
            String refreshCmd = "/clients manage " + (isMod ? "mods" : "resourcepacks");
            source.sendSuccess(() -> Component.literal((String)"\u00a77Click to refresh: ").append((Component)Component.literal((String)"\u00a7e[Refresh]").withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, refreshCmd)))), false);
        }
        catch (IllegalArgumentException e) {
            source.sendFailure((Component)Component.literal((String)("\u00a7c" + type.substring(0, 1).toUpperCase() + type.substring(1) + " not found: " + itemId)));
            return 0;
        }
        catch (SQLException e) {
            source.sendFailure((Component)Component.literal((String)("\u00a7cFailed to update " + type + ": " + e.getMessage())));
            return 0;
        }
        return 1;
    }

    private static int banItem(CommandContext<CommandSourceStack> context, boolean isMod) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String encodedId = StringArgumentType.getString(context, (String)"modId");
        String itemId = ClientApprovalCommands.decodeFromCommand(encodedId);
        String type = isMod ? "mod" : "resourcepack";
        try {
            if (isMod) {
                ClientApprovalSystem.setModApprovalStatus(itemId, ModApprovalStatus.BANNED);
            } else {
                ClientApprovalSystem.setResourcepackApprovalStatus(itemId, ModApprovalStatus.BANNED);
            }
            source.sendSuccess(() -> Component.literal((String)("\u00a7cBanned " + type + ": \u00a7f" + itemId)), false);
            String refreshCmd = "/clients manage " + (isMod ? "mods" : "resourcepacks");
            source.sendSuccess(() -> Component.literal((String)"\u00a77Click to refresh: ").append((Component)Component.literal((String)"\u00a7e[Refresh]").withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, refreshCmd)))), false);
        }
        catch (IllegalArgumentException e) {
            source.sendFailure((Component)Component.literal((String)("\u00a7c" + type.substring(0, 1).toUpperCase() + type.substring(1) + " not found: " + itemId)));
            return 0;
        }
        catch (SQLException e) {
            source.sendFailure((Component)Component.literal((String)("\u00a7cFailed to update " + type + ": " + e.getMessage())));
            return 0;
        }
        return 1;
    }

    private static /* synthetic */ Component lambda$listPatterns$38(Component patternComponent, BanPattern pattern) {
        return Component.literal((String)"  ").append(patternComponent).append((Component)Component.literal((String)(" \u00a77- " + pattern.getDescription())));
    }

    private static /* synthetic */ Component lambda$showManagementInterface$28(Component finalNav) {
        return finalNav;
    }

    private static class PlayerStatusInfo {
        final ServerPlayer player;
        final ClientApprovalSystem.PlayerApprovalStatus status;
        final boolean waitingForData;

        PlayerStatusInfo(ServerPlayer player, ClientApprovalSystem.PlayerApprovalStatus status, boolean waitingForData) {
            this.player = player;
            this.status = status;
            this.waitingForData = waitingForData;
        }
    }
}

