/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.moderation.approval;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.database.DatabaseManager;
import world.landfall.landfallessentials.moderation.approval.BanPattern;
import world.landfall.landfallessentials.moderation.approval.ModApprovalEntry;
import world.landfall.landfallessentials.moderation.approval.ModApprovalStatus;

public class ClientApprovalDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientApprovalDAO.class);

    public static Map<String, ModApprovalEntry> loadAllModApprovals() throws SQLException {
        HashMap<String, ModApprovalEntry> approvals = new HashMap<String, ModApprovalEntry>();
        String sql = "SELECT mod_id, display_name, status, first_seen, last_seen, notes\nFROM mod_approvals\n";
        try (Connection conn = DatabaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                String modId = rs.getString("mod_id");
                String displayName = rs.getString("display_name");
                ModApprovalStatus status = ModApprovalStatus.fromSerialized(rs.getString("status"));
                long firstSeen = rs.getLong("first_seen");
                long lastSeen = rs.getLong("last_seen");
                String notes = rs.getString("notes");
                ModApprovalEntry entry = new ModApprovalEntry(modId, displayName, status, firstSeen, lastSeen, notes);
                approvals.put(modId, entry);
            }
        }
        LOGGER.debug("Loaded {} mod approvals from database", (Object)approvals.size());
        return approvals;
    }

    public static void saveModApproval(ModApprovalEntry entry) throws SQLException {
        String sql = "INSERT INTO mod_approvals (mod_id, display_name, status, first_seen, last_seen, notes)\nVALUES (?, ?, ?, ?, ?, ?)\nON CONFLICT(mod_id) DO UPDATE SET\n    display_name = excluded.display_name,\n    status = excluded.status,\n    first_seen = excluded.first_seen,\n    last_seen = excluded.last_seen,\n    notes = excluded.notes\n";
        try (Connection conn = DatabaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, entry.getModId());
            stmt.setString(2, entry.getDisplayName());
            stmt.setString(3, entry.getStatus().getSerialized());
            stmt.setLong(4, entry.getFirstSeen());
            stmt.setLong(5, entry.getLastSeen());
            stmt.setString(6, entry.getNotes());
            stmt.executeUpdate();
            LOGGER.debug("Saved mod approval: {} ({})", (Object)entry.getModId(), (Object)entry.getStatus());
        }
    }

    public static void deleteModApproval(String modId) throws SQLException {
        String sql = "DELETE FROM mod_approvals WHERE mod_id = ?";
        try (Connection conn = DatabaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, modId);
            int deleted = stmt.executeUpdate();
            if (deleted > 0) {
                LOGGER.info("Deleted mod approval: {}", (Object)modId);
            }
        }
    }

    public static Map<String, ModApprovalEntry> loadAllResourcepackApprovals() throws SQLException {
        HashMap<String, ModApprovalEntry> approvals = new HashMap<String, ModApprovalEntry>();
        String sql = "SELECT mod_id, display_name, status, first_seen, last_seen, notes\nFROM resourcepack_approvals\n";
        try (Connection conn = DatabaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                String packId = rs.getString("mod_id");
                String displayName = rs.getString("display_name");
                ModApprovalStatus status = ModApprovalStatus.fromSerialized(rs.getString("status"));
                long firstSeen = rs.getLong("first_seen");
                long lastSeen = rs.getLong("last_seen");
                String notes = rs.getString("notes");
                ModApprovalEntry entry = new ModApprovalEntry(packId, displayName, status, firstSeen, lastSeen, notes);
                approvals.put(packId, entry);
            }
        }
        LOGGER.debug("Loaded {} resourcepack approvals from database", (Object)approvals.size());
        return approvals;
    }

    public static void saveResourcepackApproval(ModApprovalEntry entry) throws SQLException {
        String sql = "INSERT INTO resourcepack_approvals (mod_id, display_name, status, first_seen, last_seen, notes)\nVALUES (?, ?, ?, ?, ?, ?)\nON CONFLICT(mod_id) DO UPDATE SET\n    display_name = excluded.display_name,\n    status = excluded.status,\n    first_seen = excluded.first_seen,\n    last_seen = excluded.last_seen,\n    notes = excluded.notes\n";
        try (Connection conn = DatabaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, entry.getModId());
            stmt.setString(2, entry.getDisplayName());
            stmt.setString(3, entry.getStatus().getSerialized());
            stmt.setLong(4, entry.getFirstSeen());
            stmt.setLong(5, entry.getLastSeen());
            stmt.setString(6, entry.getNotes());
            stmt.executeUpdate();
            LOGGER.debug("Saved resourcepack approval: {} ({})", (Object)entry.getModId(), (Object)entry.getStatus());
        }
    }

    public static void deleteResourcepackApproval(String packId) throws SQLException {
        String sql = "DELETE FROM resourcepack_approvals WHERE mod_id = ?";
        try (Connection conn = DatabaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, packId);
            int deleted = stmt.executeUpdate();
            if (deleted > 0) {
                LOGGER.info("Deleted resourcepack approval: {}", (Object)packId);
            }
        }
    }

    public static List<BanPattern> loadAllBanPatterns() throws SQLException {
        ArrayList<BanPattern> patterns;
        block22: {
            patterns = new ArrayList<BanPattern>();
            String sql = "SELECT id, pattern, description, created\nFROM ban_patterns\nORDER BY id\n";
            try (Connection conn = DatabaseManager.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                ResultSet rs = stmt.executeQuery();
                block17: while (true) {
                    while (rs.next()) {
                        int id = rs.getInt("id");
                        String pattern = rs.getString("pattern");
                        String description = rs.getString("description");
                        long created = rs.getLong("created");
                        try {
                            BanPattern banPattern = new BanPattern(id, pattern, description, created);
                            patterns.add(banPattern);
                            continue block17;
                        }
                        catch (Exception e) {
                            LOGGER.warn("Failed to load ban pattern {}: {}", (Object)id, (Object)e.getMessage());
                        }
                    }
                    break block22;
                    {
                        continue block17;
                        break;
                    }
                    break;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
        }
        LOGGER.debug("Loaded {} ban patterns from database", (Object)patterns.size());
        return patterns;
    }

    public static int saveBanPattern(String pattern, String description) throws SQLException {
        String sql = "INSERT INTO ban_patterns (pattern, description, created)\nVALUES (?, ?, ?)\n";
        try (Connection conn = DatabaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql, 1);){
            stmt.setString(1, pattern);
            stmt.setString(2, description);
            stmt.setLong(3, System.currentTimeMillis());
            stmt.executeUpdate();
            try (ResultSet rs = stmt.getGeneratedKeys();){
                if (rs.next()) {
                    int id = rs.getInt(1);
                    LOGGER.info("Saved ban pattern {}: {}", (Object)id, (Object)description);
                    int n = id;
                    return n;
                }
            }
        }
        throw new SQLException("Failed to get generated key for ban pattern");
    }

    public static void deleteBanPattern(int patternId) throws SQLException {
        String sql = "DELETE FROM ban_patterns WHERE id = ?";
        try (Connection conn = DatabaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setInt(1, patternId);
            int deleted = stmt.executeUpdate();
            if (deleted > 0) {
                LOGGER.info("Deleted ban pattern: {}", (Object)patternId);
            }
        }
    }
}

