/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.regions.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import world.landfall.landfallessentials.regions.Cuboid;
import world.landfall.landfallessentials.regions.Region;
import world.landfall.landfallessentials.regions.RegionManager;
import world.landfall.landfallessentials.regions.util.CommandMessageBuilder;
import world.landfall.landfallessentials.regions.util.RegionCommandHelper;

public class RegionCuboidCommands {
    private static final int ADMIN_PERMISSION = 2;

    public static LiteralArgumentBuilder<CommandSourceStack> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return (LiteralArgumentBuilder)Commands.literal((String)"cuboid").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests(RegionCuboidCommands::suggestRegionNames).then(Commands.literal((String)"add").then(Commands.argument((String)"corner1", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"corner2", (ArgumentType)BlockPosArgument.blockPos()).executes(RegionCuboidCommands::executeAddCuboid))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(RegionCuboidCommands::executeRemoveCuboid)))).then(Commands.literal((String)"list").executes(RegionCuboidCommands::executeListCuboids))).then(Commands.literal((String)"info").then(Commands.argument((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(RegionCuboidCommands::executeCuboidInfo))));
    }

    private static CompletableFuture<Suggestions> suggestRegionNames(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggest(RegionManager.getRegionNames(), (SuggestionsBuilder)builder);
    }

    private static int executeAddCuboid(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        BlockPos corner2;
        String name = StringArgumentType.getString(ctx, (String)"name");
        Region region = RegionCommandHelper.getRegionOrFail(ctx, "name");
        if (region == null) {
            return 0;
        }
        BlockPos corner1 = BlockPosArgument.getLoadedBlockPos(ctx, (String)"corner1");
        Cuboid newCuboid = new Cuboid(corner1, corner2 = BlockPosArgument.getLoadedBlockPos(ctx, (String)"corner2"));
        if (region.addCuboid(newCuboid)) {
            RegionManager.saveRegions();
            RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().success("\u2713 Added cuboid to region '").highlight(name).success("' from ").value(RegionCommandHelper.formatPos(corner1)).success(" to ").value(RegionCommandHelper.formatPos(corner2)).success(". Region now has ").highlight(String.valueOf(region.getCuboidCount())).success(" cuboid(s).").build(), true);
            return 1;
        }
        RegionCommandHelper.sendFailure(ctx, new CommandMessageBuilder().error("\u2717 Failed to add cuboid to region '").highlight(name).error("'. Cuboid may already exist.").build());
        return 0;
    }

    private static int executeRemoveCuboid(CommandContext<CommandSourceStack> ctx) {
        String name = StringArgumentType.getString(ctx, (String)"name");
        int index = IntegerArgumentType.getInteger(ctx, (String)"index");
        Region region = RegionCommandHelper.getRegionOrFail(ctx, "name");
        if (region == null) {
            return 0;
        }
        if (region.removeCuboid(index)) {
            RegionManager.saveRegions();
            RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().success("\u2713 Removed cuboid ").highlight(String.valueOf(index)).success(" from region '").highlight(name).success("'. Region now has ").highlight(String.valueOf(region.getCuboidCount())).success(" cuboid(s).").build(), true);
            return 1;
        }
        RegionCommandHelper.sendFailure(ctx, new CommandMessageBuilder().error("\u2717 Failed to remove cuboid ").highlight(String.valueOf(index)).error(" from region '").highlight(name).error("'. Invalid index or cannot remove the last cuboid.").build());
        return 0;
    }

    private static int executeListCuboids(CommandContext<CommandSourceStack> ctx) {
        String name = StringArgumentType.getString(ctx, (String)"name");
        Region region = RegionCommandHelper.getRegionOrFail(ctx, "name");
        if (region == null) {
            return 0;
        }
        List<Cuboid> cuboids = region.getCuboids();
        StringBuilder info = new StringBuilder();
        info.append("\u00a7b=== Cuboids for Region: \u00a7e").append(name).append("\u00a7b ===\n");
        info.append("\u00a7bTotal cuboids: \u00a7e").append(cuboids.size()).append("\n");
        for (int i = 0; i < cuboids.size(); ++i) {
            Cuboid cuboid = cuboids.get(i);
            info.append("\u00a7b[\u00a7e").append(i).append("\u00a7b] ").append("\u00a77").append(cuboid.toDisplayString()).append("\u00a7b (\u00a7e").append(cuboid.getVolume()).append("\u00a7b blocks)\n");
        }
        RegionCommandHelper.sendSuccess(ctx, (Component)Component.literal((String)info.toString()));
        return cuboids.size();
    }

    private static int executeCuboidInfo(CommandContext<CommandSourceStack> ctx) {
        String name = StringArgumentType.getString(ctx, (String)"name");
        int index = IntegerArgumentType.getInteger(ctx, (String)"index");
        Region region = RegionCommandHelper.getRegionOrFail(ctx, "name");
        if (region == null) {
            return 0;
        }
        Cuboid cuboid = region.getCuboid(index);
        if (cuboid == null) {
            RegionCommandHelper.sendFailure(ctx, new CommandMessageBuilder().error("\u2717 Cuboid ").highlight(String.valueOf(index)).error(" not found in region '").highlight(name).error("'.").build());
            return 0;
        }
        StringBuilder info = new StringBuilder();
        info.append("\u00a7b=== Cuboid Info: \u00a7e").append(name).append("\u00a7b[\u00a7e").append(index).append("\u00a7b] ===\n");
        info.append("\u00a7bBounds: \u00a77").append(cuboid.toDisplayString()).append("\n");
        info.append("\u00a7bVolume: \u00a7e").append(cuboid.getVolume()).append("\u00a7b blocks\n");
        info.append("\u00a7bMin corner: \u00a77").append(RegionCommandHelper.formatPos(cuboid.getMinCorner())).append("\n");
        info.append("\u00a7bMax corner: \u00a77").append(RegionCommandHelper.formatPos(cuboid.getMaxCorner()));
        RegionCommandHelper.sendSuccess(ctx, (Component)Component.literal((String)info.toString()));
        return 1;
    }
}

