/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials;

import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="landfallessentials", bus=EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec.IntValue DEFAULT_MAX_HOMES = BUILDER.comment("Default maximum number of homes a player can set").defineInRange("defaultMaxHomes", 3, 1, 100);
    public static final ModConfigSpec.LongValue DEFAULT_HOME_COOLDOWN = BUILDER.comment("Default cooldown between home teleports in seconds").defineInRange("defaultHomeCooldown", 60L, 0L, 3600L);
    public static final ModConfigSpec.IntValue MAX_HOME_NAME_LENGTH = BUILDER.comment("Maximum length for home names").defineInRange("maxHomeNameLength", 16, 1, 32);
    public static final ModConfigSpec.BooleanValue REQUIRE_BED_FOR_HOMES = BUILDER.comment("Require homes to be set within 2 blocks of a bed. One home per bed.").define("requireBedForHomes", false);
    public static final ModConfigSpec.IntValue KEEP_INVENTORY_KARMA_THRESHOLD = BUILDER.comment("Amount of karma required to keep inventory on death. Set to 0 to disable this feature.").defineInRange("keepInventoryKarmaThreshold", 150, 0, 10000);
    public static final ModConfigSpec.IntValue BACK_COMMAND_KARMA_COST = BUILDER.comment("Karma cost for using the /back command. Set to 0 for no cost.").defineInRange("backCommandKarmaCost", 100, 0, 10000);
    public static final ModConfigSpec.BooleanValue WEBHOOK_ENABLED = BUILDER.comment("Enable webhook notifications for critical system alerts").define("webhookEnabled", false);
    public static final ModConfigSpec.ConfigValue<String> WEBHOOK_URL = BUILDER.comment("Discord webhook URL for critical system alerts. Leave empty to disable.").define("webhookUrl", (Object)"");
    public static final ModConfigSpec.ConfigValue<String> WEBHOOK_USERNAME = BUILDER.comment("Username to display for webhook messages").define("webhookUsername", (Object)"Landfall Essentials");
    public static final ModConfigSpec.BooleanValue ALERT_CONDUIT_DESTRUCTION = BUILDER.comment("Send webhook alerts for conduit destruction").define("alertConduitDestruction", true);
    public static final ModConfigSpec.DoubleValue ALERT_TPS_THRESHOLD = BUILDER.comment("TPS threshold below which alerts are sent (5-minute average). Set to 0 to disable TPS alerts.").defineInRange("alertTpsThreshold", 15.0, 0.0, 20.0);
    public static final ModConfigSpec.IntValue TPS_CHECK_INTERVAL = BUILDER.comment("Interval in seconds between TPS checks for alerts").defineInRange("tpsCheckInterval", 60, 30, 300);
    public static final ModConfigSpec.IntValue TPS_ALERT_COOLDOWN = BUILDER.comment("Cooldown in minutes before sending another TPS alert").defineInRange("tpsAlertCooldown", 10, 1, 60);
    public static final ModConfigSpec.BooleanValue MOB_SPAWN_CONTROL_ENABLED = BUILDER.comment("Enable region-based mob spawn control (peaceful and nomobs tags)").define("mobSpawnControlEnabled", true);
    public static final ModConfigSpec.IntValue MOB_SPAWN_CONTROL_CACHE_SIZE = BUILDER.comment("Maximum number of cached chunk spawn rules for performance").defineInRange("mobSpawnControlCacheSize", 1000, 100, 10000);
    public static final ModConfigSpec.LongValue MOB_SPAWN_CONTROL_CACHE_TTL = BUILDER.comment("Cache TTL in milliseconds for mob spawn rules").defineInRange("mobSpawnControlCacheTTL", 60000L, 10000L, 600000L);
    static final ModConfigSpec SPEC = BUILDER.build();
    public static int defaultMaxHomes;
    public static long defaultHomeCooldown;
    public static int maxHomeNameLength;
    public static boolean requireBedForHomes;
    public static int keepInventoryKarmaThreshold;
    public static int backCommandKarmaCost;
    public static boolean webhookEnabled;
    public static String webhookUrl;
    public static String webhookUsername;
    public static boolean alertConduitDestruction;
    public static double alertTpsThreshold;
    public static int tpsCheckInterval;
    public static int tpsAlertCooldown;
    public static boolean mobSpawnControlEnabled;
    public static int mobSpawnControlCacheSize;
    public static long mobSpawnControlCacheTTL;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        defaultMaxHomes = (Integer)DEFAULT_MAX_HOMES.get();
        defaultHomeCooldown = (Long)DEFAULT_HOME_COOLDOWN.get();
        maxHomeNameLength = (Integer)MAX_HOME_NAME_LENGTH.get();
        requireBedForHomes = (Boolean)REQUIRE_BED_FOR_HOMES.get();
        keepInventoryKarmaThreshold = (Integer)KEEP_INVENTORY_KARMA_THRESHOLD.get();
        backCommandKarmaCost = (Integer)BACK_COMMAND_KARMA_COST.get();
        webhookEnabled = (Boolean)WEBHOOK_ENABLED.get();
        webhookUrl = (String)WEBHOOK_URL.get();
        webhookUsername = (String)WEBHOOK_USERNAME.get();
        alertConduitDestruction = (Boolean)ALERT_CONDUIT_DESTRUCTION.get();
        alertTpsThreshold = (Double)ALERT_TPS_THRESHOLD.get();
        tpsCheckInterval = (Integer)TPS_CHECK_INTERVAL.get();
        tpsAlertCooldown = (Integer)TPS_ALERT_COOLDOWN.get();
        mobSpawnControlEnabled = (Boolean)MOB_SPAWN_CONTROL_ENABLED.get();
        mobSpawnControlCacheSize = (Integer)MOB_SPAWN_CONTROL_CACHE_SIZE.get();
        mobSpawnControlCacheTTL = (Long)MOB_SPAWN_CONTROL_CACHE_TTL.get();
    }
}

