/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.Config;
import world.landfall.landfallessentials.death.DeathData;
import world.landfall.landfallessentials.death.DeathLocation;
import world.landfall.landfallessentials.karma.KarmaSystem;
import world.landfall.landfallessentials.menu.VirtualCraftingMenu;

@EventBusSubscriber(modid="landfallessentials")
public class CommandRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandRegistry.class);
    private static final String PERMISSION_BACK = "landfallessentials.command.back";
    private static final String PERMISSION_ENDERCHEST = "landfallessentials.command.enderchest";
    private static final String PERMISSION_WORKBENCH = "landfallessentials.command.workbench";
    private static final String PERMISSION_ANVIL = "landfallessentials.command.anvil";

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        LOGGER.info("Registering Landfall Essentials utility commands...");
        CommandRegistry.registerBackCommand((CommandDispatcher<CommandSourceStack>)dispatcher);
        CommandRegistry.registerEnderchestCommand((CommandDispatcher<CommandSourceStack>)dispatcher);
        CommandRegistry.registerWorkbenchCommand((CommandDispatcher<CommandSourceStack>)dispatcher);
        CommandRegistry.registerAnvilCommand((CommandDispatcher<CommandSourceStack>)dispatcher);
        LOGGER.info("Successfully registered utility commands");
    }

    private static void registerBackCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"back").requires(source -> source.hasPermission(0))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            ServerLevel serverLevel = player.serverLevel();
            DeathData deathData = DeathData.get(serverLevel);
            DeathLocation lastDeathLocation = deathData.getDeathLocation(player.getUUID());
            if (lastDeathLocation == null) {
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7cYou have no previous death location recorded."));
                return 0;
            }
            int karmaCost = Config.backCommandKarmaCost;
            if (karmaCost > 0 && !KarmaSystem.hasEnoughKarma((Player)player, karmaCost)) {
                player.sendSystemMessage((Component)Component.literal((String)("\u00a7cYou do not have enough karma to use /back. Cost: " + karmaCost + " karma.")));
                return 0;
            }
            ServerLevel targetLevel = player.getServer().getLevel(lastDeathLocation.dimension());
            if (targetLevel == null) {
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7cError: Could not find the dimension of your last death. It may no longer exist."));
                return 0;
            }
            player.teleportTo(targetLevel, lastDeathLocation.x(), lastDeathLocation.y(), lastDeathLocation.z(), player.getYRot(), player.getXRot());
            if (karmaCost > 0) {
                KarmaSystem.removeKarma((Player)player, karmaCost);
                player.sendSystemMessage((Component)Component.literal((String)("\u00a7aTeleported back to your last death location. " + karmaCost + " karma deducted.")));
            } else {
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7aTeleported back to your last death location."));
            }
            deathData.clearDeathLocation(player.getUUID());
            return 1;
        }));
        LOGGER.debug("Registered /back command");
    }

    private static void registerEnderchestCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"enderchest").requires(source -> source.hasPermission(0))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            player.openMenu((MenuProvider)new SimpleMenuProvider((i, playerInventory, playerEntity) -> ChestMenu.threeRows((int)i, (Inventory)playerInventory, (Container)player.getEnderChestInventory()), (Component)Component.translatable((String)"container.enderchest")));
            player.awardStat(Stats.OPEN_ENDERCHEST);
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7aOpened your Ender Chest."));
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ec").requires(source -> source.hasPermission(0))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            player.openMenu((MenuProvider)new SimpleMenuProvider((i, playerInventory, playerEntity) -> ChestMenu.threeRows((int)i, (Inventory)playerInventory, (Container)player.getEnderChestInventory()), (Component)Component.translatable((String)"container.enderchest")));
            player.awardStat(Stats.OPEN_ENDERCHEST);
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7aOpened your Ender Chest."));
            return 1;
        }));
        LOGGER.debug("Registered /enderchest and /ec commands");
    }

    private static void registerWorkbenchCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"workbench").requires(source -> source.hasPermission(0))).executes(context -> {
            final ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            MenuProvider menuProvider = new MenuProvider(){

                public Component getDisplayName() {
                    return Component.translatable((String)"container.crafting");
                }

                public VirtualCraftingMenu createMenu(int windowId, Inventory playerInventory, Player p) {
                    return new VirtualCraftingMenu(windowId, playerInventory, ContainerLevelAccess.create((Level)player.level(), (BlockPos)player.blockPosition()));
                }
            };
            player.openMenu(menuProvider);
            player.awardStat(Stats.INTERACT_WITH_CRAFTING_TABLE);
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7aOpened a workbench."));
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"wb").requires(source -> source.hasPermission(0))).executes(context -> {
            final ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            MenuProvider menuProvider = new MenuProvider(){

                public Component getDisplayName() {
                    return Component.translatable((String)"container.crafting");
                }

                public VirtualCraftingMenu createMenu(int windowId, Inventory playerInventory, Player p) {
                    return new VirtualCraftingMenu(windowId, playerInventory, ContainerLevelAccess.create((Level)player.level(), (BlockPos)player.blockPosition()));
                }
            };
            player.openMenu(menuProvider);
            player.awardStat(Stats.INTERACT_WITH_CRAFTING_TABLE);
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7aOpened a workbench."));
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"craft").requires(source -> source.hasPermission(0))).executes(context -> {
            final ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            MenuProvider menuProvider = new MenuProvider(){

                public Component getDisplayName() {
                    return Component.translatable((String)"container.crafting");
                }

                public VirtualCraftingMenu createMenu(int windowId, Inventory playerInventory, Player p) {
                    return new VirtualCraftingMenu(windowId, playerInventory, ContainerLevelAccess.create((Level)player.level(), (BlockPos)player.blockPosition()));
                }
            };
            player.openMenu(menuProvider);
            player.awardStat(Stats.INTERACT_WITH_CRAFTING_TABLE);
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7aOpened a workbench."));
            return 1;
        }));
        LOGGER.debug("Registered /workbench, /wb, and /craft commands");
    }

    private static void registerAnvilCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"anvil").requires(source -> source.hasPermission(0))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            player.openMenu((MenuProvider)new SimpleMenuProvider((i, inventory, playerEntity) -> new AnvilMenu(i, inventory, ContainerLevelAccess.create((Level)player.level(), (BlockPos)player.blockPosition())), (Component)Component.translatable((String)"container.anvil")));
            player.awardStat(Stats.INTERACT_WITH_ANVIL);
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7aOpened an anvil."));
            return 1;
        }));
        LOGGER.debug("Registered /anvil command");
    }
}

