/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import world.landfall.landfallessentials.Config;
import world.landfall.landfallessentials.monitoring.TpsMonitor;

@EventBusSubscriber(modid="landfallessentials")
public class TpsCommand {
    @SubscribeEvent
    public static void register(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tps").requires(source -> source.hasPermission(1))).then(((LiteralArgumentBuilder)Commands.literal((String)"reset").requires(source -> source.hasPermission(2))).executes(TpsCommand::executeReset))).executes(TpsCommand::executeStats));
    }

    private static int executeStats(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        double currentTps = TpsMonitor.getCurrentTps();
        double averageTps = TpsMonitor.getAverageTps();
        double minTps = TpsMonitor.getMinTps();
        double maxTps = TpsMonitor.getMaxTps();
        String currentColor = TpsCommand.getTpsColor(currentTps);
        String averageColor = TpsCommand.getTpsColor(averageTps);
        String minColor = TpsCommand.getTpsColor(minTps);
        String maxColor = TpsCommand.getTpsColor(maxTps);
        source.sendSuccess(() -> Component.literal((String)"\u00a76=== TPS Statistics ==="), false);
        source.sendSuccess(() -> Component.literal((String)String.format("\u00a77Current TPS: %s%.2f", currentColor, currentTps)), false);
        source.sendSuccess(() -> Component.literal((String)String.format("\u00a775-Min Average: %s%.2f", averageColor, averageTps)), false);
        source.sendSuccess(() -> Component.literal((String)String.format("\u00a77Minimum: %s%.2f \u00a77| Maximum: %s%.2f", minColor, minTps, maxColor, maxTps)), false);
        if (Config.alertTpsThreshold > 0.0) {
            String thresholdColor = averageTps < Config.alertTpsThreshold ? "\u00a7c" : "\u00a7a";
            source.sendSuccess(() -> Component.literal((String)String.format("\u00a77Alert Threshold: %s%.1f %s(%s)", thresholdColor, Config.alertTpsThreshold, averageTps < Config.alertTpsThreshold ? "\u00a7c[BELOW]" : "\u00a7a[OK]", Config.webhookEnabled ? "Webhooks ON" : "Webhooks OFF")), false);
        } else {
            source.sendSuccess(() -> Component.literal((String)"\u00a77Alert Threshold: \u00a78Disabled"), false);
        }
        return 1;
    }

    private static int executeReset(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        TpsMonitor.reset();
        source.sendSuccess(() -> Component.literal((String)"\u00a7aTPS monitoring has been reset. New data will be collected starting now."), false);
        return 1;
    }

    private static String getTpsColor(double tps) {
        if (tps >= 19.0) {
            return "\u00a7a";
        }
        if (tps >= 17.0) {
            return "\u00a7e";
        }
        if (tps >= 15.0) {
            return "\u00a76";
        }
        if (tps >= 10.0) {
            return "\u00a7c";
        }
        return "\u00a74";
    }
}

