/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import world.landfall.landfallessentials.menu.VirtualCraftingMenu;
import world.landfall.landfallessentials.util.LuckPermsUtil;

public class UtilityCommands {
    private static final String PERMISSION_ENDERCHEST = "landfallessentials.command.enderchest";
    private static final String PERMISSION_WORKBENCH = "landfallessentials.command.workbench";
    private static final String PERMISSION_ANVIL = "landfallessentials.command.anvil";

    private static void oldRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        LiteralArgumentBuilder enderchestCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"enderchest").requires(source -> source.getPlayer() != null && LuckPermsUtil.hasPermission(source.getPlayer().getUUID(), PERMISSION_ENDERCHEST))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            player.openMenu((MenuProvider)new SimpleMenuProvider((i, playerInventory, playerEntity) -> ChestMenu.threeRows((int)i, (Inventory)playerInventory, (Container)player.getEnderChestInventory()), (Component)Component.translatable((String)"container.enderchest")));
            player.awardStat(Stats.OPEN_ENDERCHEST);
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7aOpened your Ender Chest."));
            return 1;
        });
        dispatcher.register(enderchestCommand);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ec").requires(source -> source.getPlayer() != null && LuckPermsUtil.hasPermission(source.getPlayer().getUUID(), PERMISSION_ENDERCHEST))).executes(enderchestCommand.getCommand()));
        LiteralArgumentBuilder workbenchCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"workbench").requires(source -> source.getPlayer() != null && LuckPermsUtil.hasPermission(source.getPlayer().getUUID(), PERMISSION_WORKBENCH))).executes(context -> {
            final ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            MenuProvider menuProvider = new MenuProvider(){

                public Component getDisplayName() {
                    return Component.translatable((String)"container.crafting");
                }

                public VirtualCraftingMenu createMenu(int windowId, Inventory playerInventory, Player p) {
                    return new VirtualCraftingMenu(windowId, playerInventory, ContainerLevelAccess.create((Level)player.level(), (BlockPos)player.blockPosition()));
                }
            };
            player.openMenu(menuProvider);
            player.awardStat(Stats.INTERACT_WITH_CRAFTING_TABLE);
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7aOpened a workbench."));
            return 1;
        });
        dispatcher.register(workbenchCommand);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"wb").requires(source -> source.getPlayer() != null && LuckPermsUtil.hasPermission(source.getPlayer().getUUID(), PERMISSION_WORKBENCH))).executes(workbenchCommand.getCommand()));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"craft").requires(source -> source.getPlayer() != null && LuckPermsUtil.hasPermission(source.getPlayer().getUUID(), PERMISSION_WORKBENCH))).executes(workbenchCommand.getCommand()));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"anvil").requires(source -> source.getPlayer() != null && LuckPermsUtil.hasPermission(source.getPlayer().getUUID(), PERMISSION_ANVIL))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            player.openMenu((MenuProvider)new SimpleMenuProvider((i, inventory, playerEntity) -> new AnvilMenu(i, inventory, ContainerLevelAccess.NULL), (Component)Component.translatable((String)"container.anvil")));
            player.awardStat(Stats.INTERACT_WITH_ANVIL);
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7aOpened an anvil."));
            return 1;
        }));
    }
}

