/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.entity;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.Config;
import world.landfall.landfallessentials.item.custom.ConduitItem;
import world.landfall.landfallessentials.util.WebhookUtil;

public class ConduitItemEntity
extends ItemEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConduitItemEntity.class);
    private volatile boolean destructionAlertSent = false;

    public ConduitItemEntity(EntityType<? extends ItemEntity> entityType, Level level) {
        super(entityType, level);
    }

    public ConduitItemEntity(Level level, double x, double y, double z, ItemStack itemStack) {
        super(level, x, y, z, itemStack);
        try {
            this.setUnlimitedLifetime();
        }
        catch (Exception e) {
            LOGGER.error("Failed to set unlimited lifetime for conduit entity", (Throwable)e);
        }
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        try {
            if (damageSource == null) {
                LOGGER.warn("Null damage source attempted on conduit entity");
                return false;
            }
            if (!this.level().isClientSide) {
                LOGGER.debug("Conduit damage attempt: {} with amount {}", (Object)(damageSource.getMsgId() != null ? damageSource.getMsgId() : "unknown"), (Object)Float.valueOf(amount));
            }
            if (damageSource.is(DamageTypeTags.IS_FIRE) || damageSource.is(DamageTypeTags.IS_EXPLOSION) || damageSource.getDirectEntity() instanceof AbstractArrow || damageSource.getDirectEntity() instanceof LivingEntity) {
                return false;
            }
            if (damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
                this.broadcastConduitDestruction("void damage");
                return super.hurt(damageSource, amount);
            }
            if (amount > 0.0f) {
                boolean wouldBeHurt = super.hurt(damageSource, amount);
                if (wouldBeHurt) {
                    String damageType = damageSource.getMsgId() != null ? damageSource.getMsgId() : "unknown";
                    this.broadcastConduitDestruction("unknown damage: " + damageType);
                }
                return wouldBeHurt;
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Error processing damage for conduit entity", (Throwable)e);
            return super.hurt(damageSource, amount);
        }
    }

    public void tick() {
        try {
            super.tick();
            if (this.level() == null) {
                LOGGER.error("Conduit entity has null level, discarding");
                this.discard();
                return;
            }
            if (this.getY() < (double)(this.level().getMinBuildHeight() - 64)) {
                this.broadcastConduitDestruction("fell out of world");
                this.discard();
                return;
            }
            ItemStack stack = this.getItem();
            if (stack == null || stack.isEmpty()) {
                this.broadcastConduitDestruction("item stack became empty");
                this.discard();
                return;
            }
            if (!(stack.getItem() instanceof ConduitItem)) {
                LOGGER.warn("Conduit entity no longer contains a conduit item, discarding");
                this.discard();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error during conduit entity tick", (Throwable)e);
        }
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean isInvulnerableTo(DamageSource damageSource) {
        try {
            if (damageSource == null) {
                return true;
            }
            return !damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY);
        }
        catch (Exception e) {
            LOGGER.error("Error checking invulnerability for conduit entity", (Throwable)e);
            return true;
        }
    }

    public void setUnlimitedLifetime() {
        try {
            super.setUnlimitedLifetime();
        }
        catch (Exception e) {
            LOGGER.error("Failed to set unlimited lifetime", (Throwable)e);
        }
    }

    public boolean hasPickUpDelay() {
        try {
            return super.hasPickUpDelay();
        }
        catch (Exception e) {
            LOGGER.error("Error checking pickup delay", (Throwable)e);
            return false;
        }
    }

    public boolean hasDestructionAlertBeenSent() {
        return this.destructionAlertSent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastConduitDestruction(String reason) {
        if (this.destructionAlertSent) {
            return;
        }
        try {
            double z;
            Item item;
            if (this.level() == null || this.level().isClientSide) {
                return;
            }
            Object object = this.level();
            if (!(object instanceof ServerLevel)) {
                LOGGER.warn("Conduit destruction called on non-server level");
                return;
            }
            ServerLevel serverLevel = (ServerLevel)object;
            object = this;
            synchronized (object) {
                if (this.destructionAlertSent) {
                    return;
                }
                this.destructionAlertSent = true;
            }
            ItemStack stack = this.getItem();
            if (stack == null || stack.isEmpty() || !((item = stack.getItem()) instanceof ConduitItem)) {
                LOGGER.warn("Conduit destruction called but item is not a conduit");
                return;
            }
            ConduitItem conduitItem = (ConduitItem)item;
            String conduitName = this.sanitizeString(stack.getDisplayName().getString(), "Unknown Conduit");
            String conduitType = this.sanitizeString(conduitItem.getConduitType().name(), "UNKNOWN");
            String dimensionName = this.sanitizeString(serverLevel.dimension().location().toString(), "unknown_dimension");
            String sanitizedReason = this.sanitizeString(reason, "unknown reason");
            double x = Double.isFinite(this.getX()) ? this.getX() : 0.0;
            double y = Double.isFinite(this.getY()) ? this.getY() : 0.0;
            double d = z = Double.isFinite(this.getZ()) ? this.getZ() : 0.0;
            if (Config.alertConduitDestruction) {
                WebhookUtil.sendConduitDestructionAlert(conduitName, conduitType, x, y, z, dimensionName, sanitizedReason);
            }
            LOGGER.warn("CONDUIT DESTROYED: {} ({}) at [{}, {}, {}] in dimension {} - Reason: {}", new Object[]{conduitName, conduitType, x, y, z, dimensionName, sanitizedReason});
        }
        catch (Exception e) {
            LOGGER.error("Critical error during conduit destruction broadcast", (Throwable)e);
            this.destructionAlertSent = false;
        }
    }

    private String sanitizeString(String input, String defaultValue) {
        if (input == null || input.trim().isEmpty()) {
            return defaultValue;
        }
        Object sanitized = input.trim();
        if (((String)sanitized).length() > 256) {
            sanitized = ((String)sanitized).substring(0, 256) + "...";
        }
        sanitized = ((String)sanitized).replaceAll("[\\r\\n\\t]", " ");
        return sanitized;
    }
}

