/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.home;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.home.Home;

public class HomeData
extends SavedData {
    private static final Logger LOGGER = LoggerFactory.getLogger(HomeData.class);
    private static final String DATA_NAME = "landfallessentials_homes";
    private final Map<UUID, Map<String, Home>> playerHomes = new HashMap<UUID, Map<String, Home>>();
    private final Map<UUID, Long> lastTeleportTimes = new HashMap<UUID, Long>();
    private final Map<String, UUID> bedOwnership = new HashMap<String, UUID>();
    private final Map<String, String> bedToHomeName = new HashMap<String, String>();

    public HomeData() {
    }

    public HomeData(CompoundTag tag, HolderLookup.Provider registries) {
        this();
        this.load(tag, registries);
    }

    public static HomeData get(ServerLevel level) {
        return (HomeData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(HomeData::new, HomeData::new), DATA_NAME);
    }

    private String bedPosToString(BlockPos pos, ResourceKey<Level> dimension) {
        return dimension.location().toString() + ":" + pos.getX() + "," + pos.getY() + "," + pos.getZ();
    }

    private void load(CompoundTag tag, HolderLookup.Provider registries) {
        this.playerHomes.clear();
        this.lastTeleportTimes.clear();
        this.bedOwnership.clear();
        this.bedToHomeName.clear();
        if (tag.contains("PlayerHomes", 10)) {
            CompoundTag playerHomesTag = tag.getCompound("PlayerHomes");
            for (String uuidString : playerHomesTag.getAllKeys()) {
                try {
                    UUID playerUUID = UUID.fromString(uuidString);
                    CompoundTag playerTag = playerHomesTag.getCompound(uuidString);
                    HashMap<String, Home> homes = new HashMap<String, Home>();
                    if (playerTag.contains("Homes", 9)) {
                        ListTag homesList = playerTag.getList("Homes", 10);
                        for (int i = 0; i < homesList.size(); ++i) {
                            CompoundTag homeTag = homesList.getCompound(i);
                            Home home = Home.fromNBT(homeTag, registries);
                            if (home == null) continue;
                            homes.put(home.getName(), home);
                            if (!home.isBedBased()) continue;
                            String bedKey = this.bedPosToString(home.getBedPosition(), home.getDimension());
                            this.bedOwnership.put(bedKey, playerUUID);
                            this.bedToHomeName.put(bedKey, home.getName());
                        }
                    }
                    this.playerHomes.put(playerUUID, homes);
                    if (!playerTag.contains("LastTeleport", 4)) continue;
                    this.lastTeleportTimes.put(playerUUID, playerTag.getLong("LastTeleport"));
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warn("Invalid UUID in home data: {}", (Object)uuidString);
                }
            }
        }
        LOGGER.info("Loaded home data for {} players with {} bed claims", (Object)this.playerHomes.size(), (Object)this.bedOwnership.size());
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        CompoundTag playerHomesTag = new CompoundTag();
        for (Map.Entry<UUID, Map<String, Home>> entry : this.playerHomes.entrySet()) {
            UUID playerUUID = entry.getKey();
            Map<String, Home> homes = entry.getValue();
            CompoundTag playerTag = new CompoundTag();
            ListTag homesList = new ListTag();
            for (Home home : homes.values()) {
                CompoundTag homeTag = home.toNBT(registries);
                homesList.add((Object)homeTag);
            }
            playerTag.put("Homes", (Tag)homesList);
            Long lastTeleport = this.lastTeleportTimes.get(playerUUID);
            if (lastTeleport != null) {
                playerTag.putLong("LastTeleport", lastTeleport.longValue());
            }
            playerHomesTag.put(playerUUID.toString(), (Tag)playerTag);
        }
        tag.put("PlayerHomes", (Tag)playerHomesTag);
        return tag;
    }

    public Map<String, Home> getPlayerHomes(UUID playerUUID) {
        return this.playerHomes.computeIfAbsent(playerUUID, k -> new HashMap());
    }

    public Home getHome(UUID playerUUID, String homeName) {
        Map<String, Home> homes = this.getPlayerHomes(playerUUID);
        return homes.get(homeName);
    }

    public void setHome(UUID playerUUID, String homeName, Home home) {
        Map<String, Home> homes = this.getPlayerHomes(playerUUID);
        Home oldHome = homes.get(homeName);
        if (oldHome != null && oldHome.isBedBased()) {
            String oldBedKey = this.bedPosToString(oldHome.getBedPosition(), oldHome.getDimension());
            this.bedOwnership.remove(oldBedKey);
            this.bedToHomeName.remove(oldBedKey);
        }
        homes.put(homeName, home);
        if (home.isBedBased()) {
            String bedKey = this.bedPosToString(home.getBedPosition(), home.getDimension());
            this.bedOwnership.put(bedKey, playerUUID);
            this.bedToHomeName.put(bedKey, homeName);
        }
        this.setDirty();
    }

    public boolean deleteHome(UUID playerUUID, String homeName) {
        Map<String, Home> homes = this.getPlayerHomes(playerUUID);
        Home home = homes.remove(homeName);
        if (home != null) {
            if (home.isBedBased()) {
                String bedKey = this.bedPosToString(home.getBedPosition(), home.getDimension());
                this.bedOwnership.remove(bedKey);
                this.bedToHomeName.remove(bedKey);
            }
            this.setDirty();
            return true;
        }
        return false;
    }

    public void clearPlayerHomes(UUID playerUUID) {
        Map<String, Home> homes = this.getPlayerHomes(playerUUID);
        for (Home home : homes.values()) {
            if (!home.isBedBased()) continue;
            String bedKey = this.bedPosToString(home.getBedPosition(), home.getDimension());
            this.bedOwnership.remove(bedKey);
            this.bedToHomeName.remove(bedKey);
        }
        if (!homes.isEmpty()) {
            homes.clear();
            this.setDirty();
        }
    }

    public boolean isBedClaimed(BlockPos bedPos, ResourceKey<Level> dimension) {
        String bedKey = this.bedPosToString(bedPos, dimension);
        return this.bedOwnership.containsKey(bedKey);
    }

    public UUID getBedOwner(BlockPos bedPos, ResourceKey<Level> dimension) {
        String bedKey = this.bedPosToString(bedPos, dimension);
        return this.bedOwnership.get(bedKey);
    }

    public String getBedHomeName(BlockPos bedPos, ResourceKey<Level> dimension) {
        String bedKey = this.bedPosToString(bedPos, dimension);
        return this.bedToHomeName.get(bedKey);
    }

    public void disableHomeByBed(BlockPos bedPos, ResourceKey<Level> dimension) {
        Home home;
        String bedKey = this.bedPosToString(bedPos, dimension);
        UUID owner = this.bedOwnership.get(bedKey);
        String homeName = this.bedToHomeName.get(bedKey);
        if (owner != null && homeName != null && (home = this.getHome(owner, homeName)) != null) {
            home.setDisabled(true);
            this.setDirty();
            LOGGER.info("Disabled home '{}' for player {} due to bed destruction at {}", new Object[]{homeName, owner, bedPos});
        }
    }

    public void enableHomeByBed(BlockPos bedPos, ResourceKey<Level> dimension) {
        Home home;
        String bedKey = this.bedPosToString(bedPos, dimension);
        UUID owner = this.bedOwnership.get(bedKey);
        String homeName = this.bedToHomeName.get(bedKey);
        if (owner != null && homeName != null && (home = this.getHome(owner, homeName)) != null) {
            home.setDisabled(false);
            this.setDirty();
            LOGGER.info("Re-enabled home '{}' for player {} due to bed placement at {}", new Object[]{homeName, owner, bedPos});
        }
    }

    public int getHomeCount(UUID playerUUID) {
        return this.getPlayerHomes(playerUUID).size();
    }

    public boolean hasHome(UUID playerUUID, String homeName) {
        return this.getPlayerHomes(playerUUID).containsKey(homeName);
    }

    public Set<String> getHomeNames(UUID playerUUID) {
        return new HashSet<String>(this.getPlayerHomes(playerUUID).keySet());
    }

    public void setLastTeleportTime(UUID playerUUID, long timestamp) {
        this.lastTeleportTimes.put(playerUUID, timestamp);
        this.setDirty();
    }

    public long getLastTeleportTime(UUID playerUUID) {
        return this.lastTeleportTimes.getOrDefault(playerUUID, 0L);
    }

    public boolean isOnCooldown(UUID playerUUID, long cooldownSeconds) {
        long cooldownMillis;
        long lastTeleport = this.getLastTeleportTime(playerUUID);
        if (lastTeleport == 0L) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        return currentTime - lastTeleport < (cooldownMillis = cooldownSeconds * 1000L);
    }

    public long getRemainingCooldown(UUID playerUUID, long cooldownSeconds) {
        long cooldownMillis;
        long lastTeleport = this.getLastTeleportTime(playerUUID);
        if (lastTeleport == 0L) {
            return 0L;
        }
        long currentTime = System.currentTimeMillis();
        long elapsed = currentTime - lastTeleport;
        if (elapsed >= (cooldownMillis = cooldownSeconds * 1000L)) {
            return 0L;
        }
        return (cooldownMillis - elapsed) / 1000L;
    }
}

