/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.regions;

import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import world.landfall.landfallessentials.regions.Cuboid;

public class Region {
    @Expose
    private String name;
    @Expose
    private String dimension;
    @Expose
    private List<Cuboid> cuboids = new ArrayList<Cuboid>();
    @Expose
    private String soundEventId;
    @Expose
    private String soundCategory;
    @Expose
    private float soundVolume;
    @Expose
    private float soundPitch;
    @Expose
    private int soundLoopDelayTicks;
    @Expose
    private String entryMessage;
    @Expose
    private String exitMessage;
    @Expose
    private String entryActionbarMessage;
    @Expose
    private String exitActionbarMessage;
    @Expose
    private String gamemodeOnEntry;
    @Expose
    private String gamemodeOnExit;
    @Expose
    private String accessDeniedMessage;
    @Expose
    private Set<String> tags = ConcurrentHashMap.newKeySet();
    private transient long lastSoundPlayTime = 0L;
    private transient Cuboid boundingBox = null;
    private transient boolean boundingBoxDirty = true;
    private final transient Map<UUID, Integer> playerLastCuboidIndex = new ConcurrentHashMap<UUID, Integer>();
    private final transient Map<Long, Set<Integer>> spatialIndex = new ConcurrentHashMap<Long, Set<Integer>>();
    private transient boolean spatialIndexDirty = true;
    private static final int CHUNK_SIZE = 16;

    private Region() {
    }

    public Region(String name, String dimension, BlockPos corner1, BlockPos corner2) {
        this.name = Objects.requireNonNull(name, "Region name cannot be null");
        this.dimension = Objects.requireNonNull(dimension, "Region dimension cannot be null");
        this.cuboids = new ArrayList<Cuboid>();
        this.cuboids.add(new Cuboid(corner1, corner2));
        this.initializeDefaults();
    }

    public Region(String name, String dimension, List<Cuboid> cuboids) {
        this.name = Objects.requireNonNull(name, "Region name cannot be null");
        this.dimension = Objects.requireNonNull(dimension, "Region dimension cannot be null");
        if (cuboids == null || cuboids.isEmpty()) {
            throw new IllegalArgumentException("Cuboids list cannot be null or empty");
        }
        this.cuboids = new ArrayList<Cuboid>(cuboids);
        this.initializeDefaults();
    }

    private void initializeDefaults() {
        this.soundCategory = "ambient";
        this.soundVolume = 1.0f;
        this.soundPitch = 1.0f;
        this.soundLoopDelayTicks = 0;
        this.tags = ConcurrentHashMap.newKeySet();
    }

    private Object readResolve() {
        if (this.tags == null) {
            this.tags = ConcurrentHashMap.newKeySet();
        } else if (!(this.tags instanceof ConcurrentHashMap.KeySetView)) {
            Set<String> oldTags = this.tags;
            this.tags = ConcurrentHashMap.newKeySet();
            this.tags.addAll(oldTags);
        }
        if (this.cuboids == null) {
            this.cuboids = new ArrayList<Cuboid>();
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getDimension() {
        return this.dimension;
    }

    public List<Cuboid> getCuboids() {
        return new ArrayList<Cuboid>(this.cuboids);
    }

    public int getCuboidCount() {
        return this.cuboids.size();
    }

    public boolean isMultiCuboid() {
        return this.cuboids.size() > 1;
    }

    public String getSoundEventId() {
        return this.soundEventId;
    }

    public String getSoundCategory() {
        return this.soundCategory;
    }

    public float getSoundVolume() {
        return this.soundVolume;
    }

    public float getSoundPitch() {
        return this.soundPitch;
    }

    public int getSoundLoopDelayTicks() {
        return this.soundLoopDelayTicks;
    }

    public String getEntryMessage() {
        return this.entryMessage;
    }

    public String getExitMessage() {
        return this.exitMessage;
    }

    public String getEntryActionbarMessage() {
        return this.entryActionbarMessage;
    }

    public String getExitActionbarMessage() {
        return this.exitActionbarMessage;
    }

    public String getGamemodeOnEntry() {
        return this.gamemodeOnEntry;
    }

    public String getGamemodeOnExit() {
        return this.gamemodeOnExit;
    }

    public String getAccessDeniedMessage() {
        return this.accessDeniedMessage;
    }

    public int getMinX() {
        return this.cuboids.stream().mapToInt(Cuboid::getMinX).min().orElse(0);
    }

    public int getMinY() {
        return this.cuboids.stream().mapToInt(Cuboid::getMinY).min().orElse(0);
    }

    public int getMinZ() {
        return this.cuboids.stream().mapToInt(Cuboid::getMinZ).min().orElse(0);
    }

    public int getMaxX() {
        return this.cuboids.stream().mapToInt(Cuboid::getMaxX).max().orElse(0);
    }

    public int getMaxY() {
        return this.cuboids.stream().mapToInt(Cuboid::getMaxY).max().orElse(0);
    }

    public int getMaxZ() {
        return this.cuboids.stream().mapToInt(Cuboid::getMaxZ).max().orElse(0);
    }

    public void setSound(String soundEventId, String category, float volume, float pitch, int loopDelayTicks) {
        this.soundEventId = soundEventId;
        this.soundCategory = category == null || category.isBlank() ? "ambient" : category;
        this.soundVolume = volume;
        this.soundPitch = pitch;
        this.soundLoopDelayTicks = Math.max(0, loopDelayTicks);
        this.lastSoundPlayTime = 0L;
    }

    public void clearSound() {
        this.soundEventId = null;
        this.soundLoopDelayTicks = 0;
        this.lastSoundPlayTime = 0L;
    }

    public void setEntryMessage(String message) {
        this.entryMessage = message;
    }

    public void clearEntryMessage() {
        this.entryMessage = null;
    }

    public void setExitMessage(String message) {
        this.exitMessage = message;
    }

    public void clearExitMessage() {
        this.exitMessage = null;
    }

    public void setEntryActionbarMessage(String message) {
        this.entryActionbarMessage = message;
    }

    public void clearEntryActionbarMessage() {
        this.entryActionbarMessage = null;
    }

    public void setExitActionbarMessage(String message) {
        this.exitActionbarMessage = message;
    }

    public void clearExitActionbarMessage() {
        this.exitActionbarMessage = null;
    }

    private void setValidatedGamemode(String gamemode, Consumer<String> setter) {
        if (gamemode != null && !gamemode.isBlank()) {
            try {
                GameType.byName((String)gamemode.toLowerCase());
                setter.accept(gamemode.toLowerCase());
            }
            catch (IllegalArgumentException e) {
                setter.accept(null);
            }
        } else {
            setter.accept(null);
        }
    }

    public void setGamemodeOnEntry(String gamemode) {
        this.setValidatedGamemode(gamemode, gm -> {
            this.gamemodeOnEntry = gm;
        });
    }

    public void clearGamemodeOnEntry() {
        this.gamemodeOnEntry = null;
    }

    public void setGamemodeOnExit(String gamemode) {
        this.setValidatedGamemode(gamemode, gm -> {
            this.gamemodeOnExit = gm;
        });
    }

    public void clearGamemodeOnExit() {
        this.gamemodeOnExit = null;
    }

    public void setAccessDeniedMessage(String message) {
        this.accessDeniedMessage = message != null && !message.isBlank() ? message : null;
    }

    public void clearAccessDeniedMessage() {
        this.accessDeniedMessage = null;
    }

    public boolean hasSound() {
        return this.soundEventId != null && !this.soundEventId.isBlank();
    }

    public boolean hasEntryMessage() {
        return this.entryMessage != null && !this.entryMessage.isBlank();
    }

    public boolean hasExitMessage() {
        return this.exitMessage != null && !this.exitMessage.isBlank();
    }

    public boolean hasGamemodeOnEntry() {
        return this.gamemodeOnEntry != null && !this.gamemodeOnEntry.isBlank();
    }

    public boolean hasGamemodeOnExit() {
        return this.gamemodeOnExit != null && !this.gamemodeOnExit.isBlank();
    }

    public boolean hasAccessDeniedMessage() {
        return this.accessDeniedMessage != null && !this.accessDeniedMessage.isBlank();
    }

    public boolean hasEntryActionbarMessage() {
        return this.entryActionbarMessage != null && !this.entryActionbarMessage.isBlank();
    }

    public boolean hasExitActionbarMessage() {
        return this.exitActionbarMessage != null && !this.exitActionbarMessage.isBlank();
    }

    public boolean contains(Player player) {
        Cuboid lastCuboid;
        Cuboid bounds;
        if (player == null || !player.level().dimension().location().toString().equals(this.dimension)) {
            return false;
        }
        if (this.cuboids.size() > 3 && (bounds = this.getBoundingBox()) != null && !bounds.contains(player)) {
            return false;
        }
        UUID playerUUID = player.getUUID();
        Integer lastCuboidIndex = this.playerLastCuboidIndex.get(playerUUID);
        if (lastCuboidIndex != null && lastCuboidIndex >= 0 && lastCuboidIndex < this.cuboids.size() && (lastCuboid = this.cuboids.get(lastCuboidIndex)).contains(player)) {
            return true;
        }
        BlockPos playerPos = player.blockPosition();
        Set<Integer> candidateCuboids = this.getCuboidsInChunk(playerPos);
        if (candidateCuboids != null) {
            for (Integer cuboidIndex : candidateCuboids) {
                Cuboid cuboid;
                if (cuboidIndex >= this.cuboids.size() || !(cuboid = this.cuboids.get(cuboidIndex)).contains(player)) continue;
                this.playerLastCuboidIndex.put(playerUUID, cuboidIndex);
                return true;
            }
        } else {
            for (int i = 0; i < this.cuboids.size(); ++i) {
                Cuboid cuboid = this.cuboids.get(i);
                if (!cuboid.contains(player)) continue;
                this.playerLastCuboidIndex.put(playerUUID, i);
                return true;
            }
        }
        this.playerLastCuboidIndex.remove(playerUUID);
        return false;
    }

    public boolean contains(BlockPos pos) {
        Cuboid bounds;
        if (pos == null) {
            return false;
        }
        if (this.cuboids.size() > 3 && (bounds = this.getBoundingBox()) != null && !bounds.contains(pos)) {
            return false;
        }
        Set<Integer> candidateCuboids = this.getCuboidsInChunk(pos);
        if (candidateCuboids != null) {
            for (Integer cuboidIndex : candidateCuboids) {
                Cuboid cuboid;
                if (cuboidIndex >= this.cuboids.size() || !(cuboid = this.cuboids.get(cuboidIndex)).contains(pos)) continue;
                return true;
            }
        } else {
            for (Cuboid cuboid : this.cuboids) {
                if (!cuboid.contains(pos)) continue;
                return true;
            }
        }
        return false;
    }

    public long getLastSoundPlayTime() {
        return this.lastSoundPlayTime;
    }

    public void setLastSoundPlayTime(long time) {
        this.lastSoundPlayTime = time;
    }

    public long getVolume() {
        return this.cuboids.stream().mapToLong(Cuboid::getVolume).sum();
    }

    public static Region getSmallestRegion(Collection<Region> regions) {
        return regions.stream().min(Comparator.comparingLong(Region::getVolume)).orElse(null);
    }

    public boolean addCuboid(Cuboid cuboid) {
        if (cuboid == null || this.cuboids.contains(cuboid)) {
            return false;
        }
        boolean result = this.cuboids.add(cuboid);
        if (result) {
            this.invalidateBoundingBox();
        }
        return result;
    }

    public boolean removeCuboid(int index) {
        if (index < 0 || index >= this.cuboids.size() || this.cuboids.size() <= 1) {
            return false;
        }
        this.cuboids.remove(index);
        this.invalidateBoundingBox();
        return true;
    }

    public Cuboid getCuboid(int index) {
        if (index < 0 || index >= this.cuboids.size()) {
            return null;
        }
        return this.cuboids.get(index);
    }

    public boolean replaceCuboid(int index, Cuboid cuboid) {
        if (index < 0 || index >= this.cuboids.size() || cuboid == null) {
            return false;
        }
        this.cuboids.set(index, cuboid);
        this.invalidateBoundingBox();
        return true;
    }

    public boolean setCuboids(List<Cuboid> newCuboids) {
        if (newCuboids == null || newCuboids.isEmpty()) {
            return false;
        }
        this.cuboids = new ArrayList<Cuboid>(newCuboids);
        this.invalidateBoundingBox();
        return true;
    }

    public Set<String> getTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    public boolean hasTag(String tag) {
        if (tag == null || tag.trim().isEmpty()) {
            return false;
        }
        return this.tags.contains(tag.trim());
    }

    public boolean addTag(String tag) {
        if (tag == null || tag.trim().isEmpty()) {
            return false;
        }
        return this.tags.add(tag.trim());
    }

    public boolean removeTag(String tag) {
        if (tag == null || tag.trim().isEmpty()) {
            return false;
        }
        return this.tags.remove(tag.trim());
    }

    public void clearTags() {
        this.tags.clear();
    }

    public boolean hasTags() {
        return !this.tags.isEmpty();
    }

    public boolean hasExplosionProtection() {
        return this.hasTag("explosion-protect");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Region region = (Region)o;
        return this.name.equals(region.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean isFullyContainedWithin(Region other) {
        if (other == null || !this.dimension.equals(other.dimension)) {
            return false;
        }
        for (Cuboid thisCuboid : this.cuboids) {
            boolean cuboidContained = false;
            for (Cuboid otherCuboid : other.cuboids) {
                if (!thisCuboid.isFullyContainedWithin(otherCuboid)) continue;
                cuboidContained = true;
                break;
            }
            if (cuboidContained) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Region{");
        sb.append("name='").append(this.name).append("'");
        sb.append(", dim='").append(this.dimension).append("'");
        sb.append(", cuboids=").append(this.cuboids.size());
        sb.append(", bounds=[").append(this.getMinX()).append(",").append(this.getMinY()).append(",").append(this.getMinZ()).append("] to [").append(this.getMaxX()).append(",").append(this.getMaxY()).append(",").append(this.getMaxZ()).append("]");
        sb.append(", volume=").append(this.getVolume()).append(" blocks");
        if (this.hasEntryMessage()) {
            sb.append(", entryMsg=true");
        }
        if (this.hasExitMessage()) {
            sb.append(", exitMsg=true");
        }
        if (this.hasSound()) {
            sb.append(", sound='").append(this.soundEventId).append("'(loop: ").append(this.soundLoopDelayTicks).append("t)");
        }
        if (this.hasGamemodeOnEntry()) {
            sb.append(", gamemode='").append(this.gamemodeOnEntry).append("'");
        }
        if (this.hasGamemodeOnExit()) {
            sb.append(", gamemodeExit='").append(this.gamemodeOnExit).append("'");
        }
        if (this.hasAccessDeniedMessage()) {
            sb.append(", accessDenied=true");
        }
        if (this.hasTags()) {
            sb.append(", tags=").append(this.tags);
        }
        sb.append('}');
        return sb.toString();
    }

    private Cuboid getBoundingBox() {
        if (this.boundingBoxDirty || this.boundingBox == null) {
            this.calculateBoundingBox();
        }
        return this.boundingBox;
    }

    private void calculateBoundingBox() {
        if (this.cuboids.isEmpty()) {
            this.boundingBox = null;
            this.boundingBoxDirty = false;
            return;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (Cuboid cuboid : this.cuboids) {
            minX = Math.min(minX, cuboid.getMinX());
            minY = Math.min(minY, cuboid.getMinY());
            minZ = Math.min(minZ, cuboid.getMinZ());
            maxX = Math.max(maxX, cuboid.getMaxX());
            maxY = Math.max(maxY, cuboid.getMaxY());
            maxZ = Math.max(maxZ, cuboid.getMaxZ());
        }
        this.boundingBox = new Cuboid(minX, minY, minZ, maxX, maxY, maxZ);
        this.boundingBoxDirty = false;
    }

    private void invalidateBoundingBox() {
        this.boundingBoxDirty = true;
        this.spatialIndexDirty = true;
        this.playerLastCuboidIndex.clear();
    }

    public void cleanupPlayerCache(UUID playerUUID) {
        this.playerLastCuboidIndex.remove(playerUUID);
    }

    public String getPerformanceInfo() {
        return String.format("Region '%s': %d cuboids, %d cached players, bounding box %s, spatial index %s", this.name, this.cuboids.size(), this.playerLastCuboidIndex.size(), this.boundingBoxDirty ? "dirty" : "cached", this.spatialIndexDirty ? "dirty" : "cached");
    }

    private void buildSpatialIndex() {
        this.spatialIndex.clear();
        for (int i = 0; i < this.cuboids.size(); ++i) {
            Cuboid cuboid = this.cuboids.get(i);
            this.addCuboidToSpatialIndex(i, cuboid);
        }
        this.spatialIndexDirty = false;
    }

    private void addCuboidToSpatialIndex(int cuboidIndex, Cuboid cuboid) {
        int minChunkX = cuboid.getMinX() >> 4;
        int maxChunkX = cuboid.getMaxX() >> 4;
        int minChunkZ = cuboid.getMinZ() >> 4;
        int maxChunkZ = cuboid.getMaxZ() >> 4;
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                long chunkKey = (long)chunkX << 32 | (long)chunkZ & 0xFFFFFFFFL;
                this.spatialIndex.computeIfAbsent(chunkKey, k -> ConcurrentHashMap.newKeySet()).add(cuboidIndex);
            }
        }
    }

    private static long getChunkKey(int x, int z) {
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        return (long)chunkX << 32 | (long)chunkZ & 0xFFFFFFFFL;
    }

    private Set<Integer> getCuboidsInChunk(BlockPos pos) {
        if (this.cuboids.size() <= 10) {
            return null;
        }
        if (this.spatialIndexDirty) {
            this.buildSpatialIndex();
        }
        long chunkKey = Region.getChunkKey(pos.getX(), pos.getZ());
        return this.spatialIndex.get(chunkKey);
    }
}

