/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.regions;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import world.landfall.landfallessentials.regions.Region;

public class RegionWandData {
    private static final Map<UUID, BlockPos> firstCorners = new ConcurrentHashMap<UUID, BlockPos>();
    private static final Map<UUID, BlockPos> secondCorners = new ConcurrentHashMap<UUID, BlockPos>();
    private static final Map<UUID, String> targetRegions = new ConcurrentHashMap<UUID, String>();
    private static final Map<UUID, Long> lastInteraction = new ConcurrentHashMap<UUID, Long>();
    private static final Map<UUID, RegionClipboard> clipboards = new ConcurrentHashMap<UUID, RegionClipboard>();
    private static final Map<UUID, Boolean> visualizationEnabled = new ConcurrentHashMap<UUID, Boolean>();

    public static void setFirstCorner(Player player, BlockPos pos) {
        UUID uuid = player.getUUID();
        firstCorners.put(uuid, pos);
        lastInteraction.put(uuid, System.currentTimeMillis());
        secondCorners.remove(uuid);
    }

    public static void setSecondCorner(Player player, BlockPos pos) {
        UUID uuid = player.getUUID();
        secondCorners.put(uuid, pos);
        lastInteraction.put(uuid, System.currentTimeMillis());
    }

    public static BlockPos getFirstCorner(Player player) {
        return firstCorners.get(player.getUUID());
    }

    public static BlockPos getSecondCorner(Player player) {
        return secondCorners.get(player.getUUID());
    }

    public static boolean hasCompleteSelection(Player player) {
        UUID uuid = player.getUUID();
        return firstCorners.containsKey(uuid) && secondCorners.containsKey(uuid);
    }

    public static void clearSelection(Player player) {
        UUID uuid = player.getUUID();
        firstCorners.remove(uuid);
        secondCorners.remove(uuid);
        targetRegions.remove(uuid);
    }

    public static void setTargetRegion(Player player, String regionName) {
        targetRegions.put(player.getUUID(), regionName);
    }

    public static String getTargetRegion(Player player) {
        return targetRegions.get(player.getUUID());
    }

    public static void copyRegion(Player player, Region region) {
        clipboards.put(player.getUUID(), new RegionClipboard(region));
    }

    public static RegionClipboard getClipboard(Player player) {
        RegionClipboard clipboard = clipboards.get(player.getUUID());
        if (clipboard != null && clipboard.isExpired()) {
            clipboards.remove(player.getUUID());
            return null;
        }
        return clipboard;
    }

    public static boolean hasClipboard(Player player) {
        return RegionWandData.getClipboard(player) != null;
    }

    public static void setVisualizationEnabled(Player player, boolean enabled) {
        visualizationEnabled.put(player.getUUID(), enabled);
    }

    public static boolean isVisualizationEnabled(Player player) {
        return visualizationEnabled.getOrDefault(player.getUUID(), true);
    }

    public static void cleanupPlayer(UUID playerUUID) {
        firstCorners.remove(playerUUID);
        secondCorners.remove(playerUUID);
        targetRegions.remove(playerUUID);
        lastInteraction.remove(playerUUID);
        clipboards.remove(playerUUID);
        visualizationEnabled.remove(playerUUID);
    }

    public static void cleanupStaleData() {
        long now = System.currentTimeMillis();
        long staleThreshold = 600000L;
        lastInteraction.entrySet().removeIf(entry -> {
            if (now - (Long)entry.getValue() > staleThreshold) {
                UUID uuid = (UUID)entry.getKey();
                firstCorners.remove(uuid);
                secondCorners.remove(uuid);
                targetRegions.remove(uuid);
                return true;
            }
            return false;
        });
        clipboards.entrySet().removeIf(entry -> {
            RegionClipboard clipboard = (RegionClipboard)entry.getValue();
            return clipboard.isExpired();
        });
    }

    public static long getSelectionVolume(Player player) {
        BlockPos corner1 = RegionWandData.getFirstCorner(player);
        BlockPos corner2 = RegionWandData.getSecondCorner(player);
        if (corner1 == null || corner2 == null) {
            return 0L;
        }
        int minX = Math.min(corner1.getX(), corner2.getX());
        int minY = Math.min(corner1.getY(), corner2.getY());
        int minZ = Math.min(corner1.getZ(), corner2.getZ());
        int maxX = Math.max(corner1.getX(), corner2.getX());
        int maxY = Math.max(corner1.getY(), corner2.getY());
        int maxZ = Math.max(corner1.getZ(), corner2.getZ());
        long width = maxX - minX + 1;
        long height = maxY - minY + 1;
        long length = maxZ - minZ + 1;
        return width * height * length;
    }

    public static boolean isSelectionValid(Player player) {
        long volume = RegionWandData.getSelectionVolume(player);
        return volume > 0L;
    }

    public static class RegionClipboard {
        public final Set<String> tags;
        public final String entryMessage;
        public final String exitMessage;
        public final String entryActionbarMessage;
        public final String exitActionbarMessage;
        public final String gamemodeOnEntry;
        public final String gamemodeOnExit;
        public final String accessDeniedMessage;
        public final String soundEventId;
        public final String soundCategory;
        public final float soundVolume;
        public final float soundPitch;
        public final int soundLoopDelayTicks;
        public final String sourceRegion;
        public final long timestamp;

        public RegionClipboard(Region region) {
            this.tags = new HashSet<String>(region.getTags());
            this.entryMessage = region.getEntryMessage();
            this.exitMessage = region.getExitMessage();
            this.entryActionbarMessage = region.getEntryActionbarMessage();
            this.exitActionbarMessage = region.getExitActionbarMessage();
            this.gamemodeOnEntry = region.getGamemodeOnEntry();
            this.gamemodeOnExit = region.getGamemodeOnExit();
            this.accessDeniedMessage = region.getAccessDeniedMessage();
            this.soundEventId = region.getSoundEventId();
            this.soundCategory = region.getSoundCategory();
            this.soundVolume = region.getSoundVolume();
            this.soundPitch = region.getSoundPitch();
            this.soundLoopDelayTicks = region.getSoundLoopDelayTicks();
            this.sourceRegion = region.getName();
            this.timestamp = System.currentTimeMillis();
        }

        public void applyTo(Region region) {
            region.clearTags();
            for (String tag : this.tags) {
                region.addTag(tag);
            }
            if (this.entryMessage != null) {
                region.setEntryMessage(this.entryMessage);
            }
            if (this.exitMessage != null) {
                region.setExitMessage(this.exitMessage);
            }
            if (this.entryActionbarMessage != null) {
                region.setEntryActionbarMessage(this.entryActionbarMessage);
            }
            if (this.exitActionbarMessage != null) {
                region.setExitActionbarMessage(this.exitActionbarMessage);
            }
            if (this.gamemodeOnEntry != null) {
                region.setGamemodeOnEntry(this.gamemodeOnEntry);
            }
            if (this.gamemodeOnExit != null) {
                region.setGamemodeOnExit(this.gamemodeOnExit);
            }
            if (this.accessDeniedMessage != null) {
                region.setAccessDeniedMessage(this.accessDeniedMessage);
            }
            if (this.soundEventId != null) {
                region.setSound(this.soundEventId, this.soundCategory, this.soundVolume, this.soundPitch, this.soundLoopDelayTicks);
            }
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp > 3600000L;
        }
    }
}

