/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.regions;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.ServerChatEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.item.custom.RegionWandItem;
import world.landfall.landfallessentials.regions.Cuboid;
import world.landfall.landfallessentials.regions.Region;
import world.landfall.landfallessentials.regions.RegionManager;
import world.landfall.landfallessentials.regions.RegionVisualizer;
import world.landfall.landfallessentials.regions.RegionWandData;
import world.landfall.landfallessentials.regions.RegionWandVisualizer;

@EventBusSubscriber(modid="landfallessentials")
public class RegionWandHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegionWandHandler.class);
    private static final Map<UUID, PendingRegionCreation> pendingCreations = new ConcurrentHashMap<UUID, PendingRegionCreation>();

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (!(stack.getItem() instanceof RegionWandItem)) {
            return;
        }
        event.setCanceled(true);
        if (player.level().isClientSide()) {
            return;
        }
        BlockPos pos = event.getPos();
        RegionWandItem.WandMode mode = RegionWandItem.getMode(stack);
        if (mode == RegionWandItem.WandMode.COPY_PASTE) {
            RegionWandHandler.handleCopyProperties(player, pos);
        } else if (mode == RegionWandItem.WandMode.DELETE) {
            RegionWandHandler.handleDeleteMode(player, pos);
        } else {
            RegionWandHandler.handleSetFirstCorner(player, stack, pos);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        ItemStack stack = player.getItemInHand(event.getHand());
        if (!(stack.getItem() instanceof RegionWandItem) || event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        event.setCanceled(true);
        if (player.level().isClientSide()) {
            return;
        }
        BlockPos pos = event.getPos();
        RegionWandItem.WandMode mode = RegionWandItem.getMode(stack);
        if (mode == RegionWandItem.WandMode.COPY_PASTE) {
            RegionWandHandler.handlePasteProperties(player, pos);
        } else {
            RegionWandHandler.handleSetSecondCorner(player, stack, pos);
        }
    }

    private static void handleSetFirstCorner(Player player, ItemStack stack, BlockPos pos) {
        RegionWandItem.WandMode mode = RegionWandItem.getMode(stack);
        if (mode == RegionWandItem.WandMode.COPY_PASTE || mode == RegionWandItem.WandMode.DELETE) {
            player.displayClientMessage((Component)Component.literal((String)"\u2717 Switch to a different mode to set corners!").withStyle(ChatFormatting.RED), true);
            return;
        }
        RegionWandData.setFirstCorner(player, pos);
        RegionWandItem.setCorner1(stack, pos);
        RegionWandVisualizer.showCornerParticles(player, pos, true);
        player.displayClientMessage((Component)Component.literal((String)"\u2713 First corner set at ").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)String.format("%d, %d, %d", pos.getX(), pos.getY(), pos.getZ())).withStyle(ChatFormatting.YELLOW)), true);
        player.level().playSound(null, pos, SoundEvents.STONE_BUTTON_CLICK_ON, SoundSource.BLOCKS, 0.5f, 1.2f);
    }

    private static void handleSetSecondCorner(Player player, ItemStack stack, BlockPos pos) {
        RegionWandItem.WandMode mode = RegionWandItem.getMode(stack);
        if (mode == RegionWandItem.WandMode.COPY_PASTE || mode == RegionWandItem.WandMode.DELETE) {
            player.displayClientMessage((Component)Component.literal((String)"\u2717 Switch to a different mode to set corners!").withStyle(ChatFormatting.RED), true);
            return;
        }
        BlockPos corner1 = RegionWandData.getFirstCorner(player);
        if (corner1 == null) {
            player.displayClientMessage((Component)Component.literal((String)"\u2717 Set the first corner first!").withStyle(ChatFormatting.RED), true);
            return;
        }
        RegionWandData.setSecondCorner(player, pos);
        long volume = RegionWandData.getSelectionVolume(player);
        if (!RegionWandData.isSelectionValid(player)) {
            player.displayClientMessage((Component)Component.literal((String)"\u2717 Invalid selection! ").withStyle(ChatFormatting.RED), true);
            RegionWandData.clearSelection(player);
            return;
        }
        if (volume > 10000000L) {
            player.displayClientMessage((Component)Component.literal((String)"\u26a0 Large region warning: ").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)String.format("%,d blocks", volume)).withStyle(ChatFormatting.GOLD)).append((Component)Component.literal((String)" - Performance may be impacted with many cuboids").withStyle(ChatFormatting.YELLOW)), false);
        }
        RegionWandVisualizer.showCornerParticles(player, pos, false);
        player.displayClientMessage((Component)Component.literal((String)"\u2713 Selection complete: ").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)String.format("%,d blocks", volume)).withStyle(ChatFormatting.YELLOW)), true);
        RegionWandItem.WandMode currentMode = RegionWandItem.getMode(stack);
        String dimension = player.level().dimension().location().toString();
        switch (currentMode) {
            case NEW_CUBOID: {
                RegionWandHandler.handleNewCuboid(player, corner1, pos, dimension);
                break;
            }
            case NEW_REGION: {
                RegionWandHandler.handleNewRegion(player, corner1, pos, dimension);
                break;
            }
            case COPY_PASTE: {
                player.displayClientMessage((Component)Component.literal((String)"\u2717 Copy/Paste mode doesn't use corner selection!").withStyle(ChatFormatting.RED), true);
                return;
            }
        }
        RegionWandData.clearSelection(player);
        RegionWandItem.clearSelection(stack);
        player.level().playSound(null, pos, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 0.5f, 1.0f);
    }

    private static void handleNewCuboid(Player player, BlockPos corner1, BlockPos corner2, String dimension) {
        BlockPos playerPos = player.blockPosition();
        List<Region> regionsAtPlayer = RegionManager.getRegionsAt(playerPos, dimension);
        if (regionsAtPlayer.isEmpty()) {
            player.displayClientMessage((Component)Component.literal((String)"\u2717 Stand inside the region you want to add a cuboid to!").withStyle(ChatFormatting.RED), false);
            return;
        }
        Region targetRegion = Region.getSmallestRegion(regionsAtPlayer);
        if (targetRegion == null) {
            player.displayClientMessage((Component)Component.literal((String)"\u2717 No region found at your location").withStyle(ChatFormatting.RED), false);
            return;
        }
        Cuboid newCuboid = new Cuboid(corner1, corner2);
        if (targetRegion.addCuboid(newCuboid)) {
            RegionManager.saveRegions();
            int cuboidCount = targetRegion.getCuboidCount();
            player.displayClientMessage((Component)Component.literal((String)"\u2713 Added cuboid #").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)String.valueOf(cuboidCount)).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)" to region ").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)targetRegion.getName()).withStyle(ChatFormatting.AQUA)), false);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                RegionVisualizer.updatePlayerVisualizations(serverPlayer);
            }
        } else {
            player.displayClientMessage((Component)Component.literal((String)"\u2717 Failed to add cuboid to region").withStyle(ChatFormatting.RED), false);
        }
    }

    private static void handleNewRegion(Player player, BlockPos corner1, BlockPos corner2, String dimension) {
        UUID uuid = player.getUUID();
        pendingCreations.put(uuid, new PendingRegionCreation(corner1, corner2, dimension));
        player.displayClientMessage((Component)Component.literal((String)"Enter region name in chat:").withStyle(ChatFormatting.YELLOW), false);
        player.displayClientMessage((Component)Component.literal((String)"Type the name or 'cancel' to abort").withStyle(ChatFormatting.GRAY), false);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onServerChat(ServerChatEvent event) {
        if (RegionWandHandler.processChatForRegionName(event.getPlayer(), event.getMessage().getString())) {
            event.setCanceled(true);
        }
    }

    public static boolean processChatForRegionName(ServerPlayer player, String message) {
        UUID uuid = player.getUUID();
        PendingRegionCreation pending = pendingCreations.get(uuid);
        if (pending == null || pending.isExpired()) {
            pendingCreations.remove(uuid);
            return false;
        }
        pendingCreations.remove(uuid);
        if (message.equalsIgnoreCase("cancel")) {
            player.displayClientMessage((Component)Component.literal((String)"\u2717 Region creation cancelled").withStyle(ChatFormatting.RED), false);
            return true;
        }
        String regionName = message.trim().replaceAll("[^a-zA-Z0-9_-]", "");
        if (regionName.isEmpty()) {
            player.displayClientMessage((Component)Component.literal((String)"\u2717 Invalid region name").withStyle(ChatFormatting.RED), false);
            return true;
        }
        if (RegionManager.getRegion(regionName) != null) {
            player.displayClientMessage((Component)Component.literal((String)"\u2717 Region '").withStyle(ChatFormatting.RED).append((Component)Component.literal((String)regionName).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)"' already exists!").withStyle(ChatFormatting.RED)), false);
            return true;
        }
        Region newRegion = new Region(regionName, pending.dimension, pending.corner1, pending.corner2);
        if (RegionManager.addRegion(newRegion)) {
            player.displayClientMessage((Component)Component.literal((String)"\u2713 Created new region '").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)regionName).withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)"'").withStyle(ChatFormatting.GREEN)), false);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = player;
                RegionVisualizer.updatePlayerVisualizations(serverPlayer);
            }
        } else {
            player.displayClientMessage((Component)Component.literal((String)"\u2717 Failed to create region").withStyle(ChatFormatting.RED), false);
        }
        return true;
    }

    private static void handleCopyProperties(Player player, BlockPos pos) {
        String dimension = player.level().dimension().location().toString();
        List<Region> regions = RegionManager.getRegionsAt(pos, dimension);
        if (regions.isEmpty()) {
            player.displayClientMessage((Component)Component.literal((String)"\u2717 No region found at this location").withStyle(ChatFormatting.RED), true);
            return;
        }
        Region region = Region.getSmallestRegion(regions);
        if (region == null) {
            return;
        }
        RegionWandData.copyRegion(player, region);
        player.displayClientMessage((Component)Component.literal((String)"\u2713 Copied properties from region '").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)region.getName()).withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)"'").withStyle(ChatFormatting.GREEN)), false);
        Set<String> tags = region.getTags();
        if (!tags.isEmpty()) {
            player.displayClientMessage((Component)Component.literal((String)"  Tags: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.join((CharSequence)", ", tags)).withStyle(ChatFormatting.YELLOW)), false);
        }
        player.level().playSound(null, player.blockPosition(), SoundEvents.BOOK_PAGE_TURN, SoundSource.PLAYERS, 0.5f, 1.0f);
    }

    private static void handlePasteProperties(Player player, BlockPos pos) {
        RegionWandData.RegionClipboard clipboard = RegionWandData.getClipboard(player);
        if (clipboard == null) {
            player.displayClientMessage((Component)Component.literal((String)"\u2717 No properties in clipboard! Shift + Right-click a region first").withStyle(ChatFormatting.RED), true);
            return;
        }
        String dimension = player.level().dimension().location().toString();
        List<Region> regions = RegionManager.getRegionsAt(pos, dimension);
        if (regions.isEmpty()) {
            player.displayClientMessage((Component)Component.literal((String)"\u2717 No region found at this location").withStyle(ChatFormatting.RED), true);
            return;
        }
        Region region = Region.getSmallestRegion(regions);
        if (region == null) {
            return;
        }
        clipboard.applyTo(region);
        RegionManager.saveRegions();
        player.displayClientMessage((Component)Component.literal((String)"\u2713 Applied properties to region '").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)region.getName()).withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)"' from '").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)clipboard.sourceRegion).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)"'").withStyle(ChatFormatting.GREEN)), false);
        player.level().playSound(null, player.blockPosition(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS, 0.5f, 1.0f);
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        ServerPlayer player;
        ItemStack mainHand;
        Player player2;
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        if (event.getEntity().tickCount % 400 == 0) {
            RegionWandData.cleanupStaleData();
            pendingCreations.entrySet().removeIf(entry -> ((PendingRegionCreation)entry.getValue()).isExpired());
        }
        if ((player2 = event.getEntity()) instanceof ServerPlayer && (mainHand = (player = (ServerPlayer)player2).getItemInHand(InteractionHand.MAIN_HAND)).getItem() instanceof RegionWandItem && player.tickCount % 10 == 0) {
            RegionWandVisualizer.updateSelectionVisualization(player);
        }
    }

    private static void handleDeleteMode(Player player, BlockPos pos) {
        String dimension = player.level().dimension().location().toString();
        List<Region> regions = RegionManager.getRegionsAt(pos, dimension);
        if (regions.isEmpty()) {
            player.displayClientMessage((Component)Component.literal((String)"\u2717 No region found at this location").withStyle(ChatFormatting.RED), true);
            return;
        }
        Region targetRegion = Region.getSmallestRegion(regions);
        if (targetRegion == null) {
            return;
        }
        boolean isShiftClick = player.isShiftKeyDown();
        if (isShiftClick) {
            RegionWandHandler.handleDeleteRegion(player, targetRegion);
        } else {
            RegionWandHandler.handleDeleteCuboid(player, targetRegion, pos);
        }
    }

    private static void handleDeleteCuboid(Player player, Region region, BlockPos pos) {
        List<Cuboid> cuboids = region.getCuboids();
        Cuboid targetCuboid = null;
        int cuboidIndex = -1;
        for (int i = 0; i < cuboids.size(); ++i) {
            Cuboid cuboid = cuboids.get(i);
            if (!cuboid.contains(pos)) continue;
            targetCuboid = cuboid;
            cuboidIndex = i;
            break;
        }
        if (targetCuboid == null) {
            player.displayClientMessage((Component)Component.literal((String)"\u2717 No cuboid found at this exact position").withStyle(ChatFormatting.RED), true);
            return;
        }
        if (cuboids.size() == 1) {
            player.displayClientMessage((Component)Component.literal((String)"\u2717 Cannot delete the last cuboid! Use Shift + Left-click to delete the entire region").withStyle(ChatFormatting.RED), false);
            return;
        }
        if (region.removeCuboid(cuboidIndex)) {
            RegionManager.saveRegions();
            player.displayClientMessage((Component)Component.literal((String)"\u2713 Deleted cuboid #").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)String.valueOf(cuboidIndex)).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)" from region '").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)region.getName()).withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)"' (").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)String.valueOf(region.getCuboidCount())).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)" remaining)").withStyle(ChatFormatting.GREEN)), false);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                RegionVisualizer.updatePlayerVisualizations(serverPlayer);
            }
            player.level().playSound(null, pos, SoundEvents.ANVIL_BREAK, SoundSource.BLOCKS, 0.5f, 1.0f);
        } else {
            player.displayClientMessage((Component)Component.literal((String)"\u2717 Failed to delete cuboid").withStyle(ChatFormatting.RED), false);
        }
    }

    private static void handleDeleteRegion(Player player, Region region) {
        String regionName = region.getName();
        if (RegionManager.removeRegion(regionName)) {
            player.displayClientMessage((Component)Component.literal((String)"\u2713 Deleted region '").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)regionName).withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)"'").withStyle(ChatFormatting.GREEN)), false);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                RegionVisualizer.updatePlayerVisualizations(serverPlayer);
            }
            player.level().playSound(null, player.blockPosition(), SoundEvents.ANVIL_DESTROY, SoundSource.BLOCKS, 0.7f, 0.8f);
        } else {
            player.displayClientMessage((Component)Component.literal((String)"\u2717 Failed to delete region '").withStyle(ChatFormatting.RED).append((Component)Component.literal((String)regionName).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)"'").withStyle(ChatFormatting.RED)), false);
        }
    }

    private static class PendingRegionCreation {
        final BlockPos corner1;
        final BlockPos corner2;
        final String dimension;
        final long timestamp;

        PendingRegionCreation(BlockPos corner1, BlockPos corner2, String dimension) {
            this.corner1 = corner1;
            this.corner2 = corner2;
            this.dimension = dimension;
            this.timestamp = System.currentTimeMillis();
        }

        boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp > 60000L;
        }
    }
}

