/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.regions;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import world.landfall.landfallessentials.item.custom.RegionWandItem;
import world.landfall.landfallessentials.regions.Cuboid;
import world.landfall.landfallessentials.regions.Region;
import world.landfall.landfallessentials.regions.RegionManager;
import world.landfall.landfallessentials.regions.RegionVisualizer;
import world.landfall.landfallessentials.regions.RegionWandData;

public class RegionWandVisualizer {
    private static final DustParticleOptions PARTICLE_NEW_CUBOID = new DustParticleOptions(new Vector3f(0.0f, 1.0f, 0.0f), 1.0f);
    private static final DustParticleOptions PARTICLE_NEW_REGION = new DustParticleOptions(new Vector3f(0.0f, 0.5f, 1.0f), 1.0f);
    private static final DustParticleOptions PARTICLE_COPY_PASTE = new DustParticleOptions(new Vector3f(0.8f, 0.4f, 1.0f), 1.0f);
    private static final DustParticleOptions PARTICLE_DELETE = new DustParticleOptions(new Vector3f(1.0f, 0.0f, 0.0f), 1.0f);
    private static final DustParticleOptions PARTICLE_CORNER = new DustParticleOptions(new Vector3f(1.0f, 0.0f, 0.0f), 1.5f);

    public static void showCornerParticles(Player player, BlockPos pos, boolean isFirstCorner) {
        Level level = player.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        Vec3 center = Vec3.atCenterOf((Vec3i)pos);
        for (int i = 0; i < 3; ++i) {
            double y = center.y + (double)i * 0.5;
            ((ServerPlayer)player).connection.send((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)PARTICLE_CORNER, false, center.x, y, center.z, 0.2f, 0.0f, 0.2f, 0.0f, 5));
        }
        ((ServerPlayer)player).connection.send((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)ParticleTypes.END_ROD, false, center.x, center.y + 0.5, center.z, 0.3f, 0.3f, 0.3f, 0.05f, 10));
    }

    public static void updateSelectionVisualization(ServerPlayer player) {
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof RegionWandItem)) {
            return;
        }
        BlockPos corner1 = RegionWandData.getFirstCorner((Player)player);
        BlockPos corner2 = RegionWandData.getSecondCorner((Player)player);
        if (corner1 == null) {
            return;
        }
        RegionWandItem.WandMode mode = RegionWandItem.getMode(stack);
        DustParticleOptions particleOptions = RegionWandVisualizer.getParticleForMode(mode);
        if (corner2 == null) {
            RegionWandVisualizer.showSingleCorner(player, corner1, particleOptions);
        } else {
            RegionWandVisualizer.showSelectionBox(player, corner1, corner2, particleOptions);
        }
    }

    private static DustParticleOptions getParticleForMode(RegionWandItem.WandMode mode) {
        return switch (mode) {
            default -> throw new MatchException(null, null);
            case RegionWandItem.WandMode.NEW_CUBOID -> PARTICLE_NEW_CUBOID;
            case RegionWandItem.WandMode.NEW_REGION -> PARTICLE_NEW_REGION;
            case RegionWandItem.WandMode.COPY_PASTE -> PARTICLE_COPY_PASTE;
            case RegionWandItem.WandMode.DELETE -> PARTICLE_DELETE;
        };
    }

    private static void showSingleCorner(ServerPlayer player, BlockPos pos, DustParticleOptions particle) {
        Vec3 center = Vec3.atCenterOf((Vec3i)pos);
        double pulse = Math.sin((double)player.tickCount * 0.1) * 0.1 + 0.3;
        player.connection.send((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)particle, false, center.x, center.y + 0.5, center.z, (float)pulse, (float)pulse, (float)pulse, 0.0f, 3));
    }

    private static void showSelectionBox(ServerPlayer player, BlockPos corner1, BlockPos corner2, DustParticleOptions particle) {
        int minX = Math.min(corner1.getX(), corner2.getX());
        int minY = Math.min(corner1.getY(), corner2.getY());
        int minZ = Math.min(corner1.getZ(), corner2.getZ());
        int maxX = Math.max(corner1.getX(), corner2.getX()) + 1;
        int maxY = Math.max(corner1.getY(), corner2.getY()) + 1;
        int maxZ = Math.max(corner1.getZ(), corner2.getZ()) + 1;
        double stepSize = RegionWandVisualizer.calculateStepSize(maxX - minX, maxY - minY, maxZ - minZ);
        RegionWandVisualizer.drawBoxEdges(player, minX, minY, minZ, maxX, maxY, maxZ, stepSize, particle);
        RegionWandVisualizer.showBoxCorners(player, minX, minY, minZ, maxX, maxY, maxZ);
    }

    private static double calculateStepSize(int width, int height, int depth) {
        int maxDimension = Math.max(Math.max(width, height), depth);
        if (maxDimension <= 10) {
            return 0.25;
        }
        if (maxDimension <= 50) {
            return 0.5;
        }
        if (maxDimension <= 100) {
            return 1.0;
        }
        if (maxDimension <= 500) {
            return 2.0;
        }
        return 5.0;
    }

    private static void drawBoxEdges(ServerPlayer player, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, double step, DustParticleOptions particle) {
        RegionWandVisualizer.drawLine(player, minX, minY, minZ, maxX, minY, minZ, step, particle);
        RegionWandVisualizer.drawLine(player, minX, minY, minZ, minX, minY, maxZ, step, particle);
        RegionWandVisualizer.drawLine(player, maxX, minY, minZ, maxX, minY, maxZ, step, particle);
        RegionWandVisualizer.drawLine(player, minX, minY, maxZ, maxX, minY, maxZ, step, particle);
        RegionWandVisualizer.drawLine(player, minX, maxY, minZ, maxX, maxY, minZ, step, particle);
        RegionWandVisualizer.drawLine(player, minX, maxY, minZ, minX, maxY, maxZ, step, particle);
        RegionWandVisualizer.drawLine(player, maxX, maxY, minZ, maxX, maxY, maxZ, step, particle);
        RegionWandVisualizer.drawLine(player, minX, maxY, maxZ, maxX, maxY, maxZ, step, particle);
        RegionWandVisualizer.drawLine(player, minX, minY, minZ, minX, maxY, minZ, step, particle);
        RegionWandVisualizer.drawLine(player, maxX, minY, minZ, maxX, maxY, minZ, step, particle);
        RegionWandVisualizer.drawLine(player, minX, minY, maxZ, minX, maxY, maxZ, step, particle);
        RegionWandVisualizer.drawLine(player, maxX, minY, maxZ, maxX, maxY, maxZ, step, particle);
    }

    private static void drawLine(ServerPlayer player, double x1, double y1, double z1, double x2, double y2, double z2, double step, DustParticleOptions particle) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (distance < 0.01) {
            return;
        }
        int steps = Math.max(1, (int)(distance / step));
        double stepX = dx / (double)steps;
        double stepY = dy / (double)steps;
        double stepZ = dz / (double)steps;
        int particleStep = Math.max(1, steps / 50);
        for (int i = 0; i <= steps; i += particleStep) {
            double x = x1 + stepX * (double)i;
            double y = y1 + stepY * (double)i;
            double z = z1 + stepZ * (double)i;
            player.connection.send((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)particle, false, x, y, z, 0.0f, 0.0f, 0.0f, 0.0f, 1));
        }
    }

    private static void showBoxCorners(ServerPlayer player, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        double[][] corners;
        for (double[] corner : corners = new double[][]{{minX, minY, minZ}, {maxX, minY, minZ}, {minX, maxY, minZ}, {maxX, maxY, minZ}, {minX, minY, maxZ}, {maxX, minY, maxZ}, {minX, maxY, maxZ}, {maxX, maxY, maxZ}}) {
            player.connection.send((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)ParticleTypes.END_ROD, false, corner[0], corner[1], corner[2], 0.0f, 0.0f, 0.0f, 0.0f, 1));
        }
    }

    public static void updateVisualization(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            RegionVisualizer.updatePlayerVisualizations(serverPlayer);
        }
    }

    public static void showCuboidPreview(ServerPlayer player, Region targetRegion, BlockPos corner1, BlockPos corner2) {
        for (Cuboid cuboid : targetRegion.getCuboids()) {
            DustParticleOptions dimParticle = new DustParticleOptions(new Vector3f(0.3f, 0.3f, 0.3f), 0.8f);
            RegionWandVisualizer.showSelectionBox(player, new BlockPos(cuboid.getMinX(), cuboid.getMinY(), cuboid.getMinZ()), new BlockPos(cuboid.getMaxX(), cuboid.getMaxY(), cuboid.getMaxZ()), dimParticle);
        }
        RegionWandVisualizer.showSelectionBox(player, corner1, corner2, PARTICLE_NEW_CUBOID);
    }

    public static void showNearbyRegionBoundaries(ServerPlayer player) {
        String dimension = player.level().dimension().location().toString();
        BlockPos playerPos = player.blockPosition();
        List<Region> nearbyRegions = RegionManager.getAllRegions().values().stream().filter(r -> r.getDimension().equals(dimension)).filter(r -> {
            int dx = Math.abs(playerPos.getX() - (r.getMinX() + r.getMaxX()) / 2);
            int dz = Math.abs(playerPos.getZ() - (r.getMinZ() + r.getMaxZ()) / 2);
            return dx <= 50 && dz <= 50;
        }).toList();
        for (Region region : nearbyRegions) {
            DustParticleOptions faintParticle = new DustParticleOptions(new Vector3f(0.5f, 0.5f, 1.0f), 0.5f);
            for (Cuboid cuboid : region.getCuboids()) {
                RegionWandVisualizer.showBoxCorners(player, cuboid.getMinX(), cuboid.getMinY(), cuboid.getMinZ(), cuboid.getMaxX() + 1, cuboid.getMaxY() + 1, cuboid.getMaxZ() + 1);
            }
        }
    }
}

