/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.seen;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import world.landfall.landfallessentials.seen.PlayerSeenEntry;
import world.landfall.landfallessentials.seen.SeenManager;

public class SeenCommand {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MMM d, yyyy h:mm:ss a");
    private static final int SEENLIST_ENTRIES_PER_PAGE = 10;
    public static final Component SEEN_PREFIX = Component.literal((String)"[").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)"Seen").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)"] ").withStyle(ChatFormatting.YELLOW));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder seenCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"seen").executes(SeenCommand::runSeenUsage)).then(Commands.argument((String)"playerName", (ArgumentType)StringArgumentType.greedyString()).suggests(SeenCommand::suggestPlayerNames).executes(SeenCommand::runSeenPlayer));
        LiteralArgumentBuilder seenListCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"seenlist").executes(ctx -> SeenCommand.runSeenList((CommandContext<CommandSourceStack>)ctx, 1))).then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> SeenCommand.runSeenList((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"))));
        dispatcher.register(seenCommand);
        dispatcher.register(seenListCommand);
    }

    private static int runSeenUsage(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> SEEN_PREFIX.copy().append((Component)Component.literal((String)"Usage: /seen <playerName>").withStyle(ChatFormatting.YELLOW)), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> SEEN_PREFIX.copy().append((Component)Component.literal((String)"Shows when a player was last online.").withStyle(ChatFormatting.YELLOW)), false);
        return 1;
    }

    private static CompletableFuture<Suggestions> suggestPlayerNames(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        String input = builder.getRemaining().toLowerCase(Locale.ROOT);
        server.getPlayerList().getPlayers().stream().map(player -> player.getName().getString()).filter(name -> name.toLowerCase(Locale.ROOT).contains(input)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        Map<UUID, PlayerSeenEntry> seenData = SeenManager.getAllSeenData(server);
        seenData.values().stream().map(PlayerSeenEntry::playerName).distinct().filter(name -> name.toLowerCase(Locale.ROOT).contains(input)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static int runSeenPlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        MinecraftServer server = source.getServer();
        String searchName = StringArgumentType.getString(context, (String)"playerName").toLowerCase(Locale.ROOT);
        List<ServerPlayer> onlineMatches = server.getPlayerList().getPlayers().stream().filter(p -> p.getName().getString().toLowerCase(Locale.ROOT).contains(searchName)).collect(Collectors.toList());
        if (!onlineMatches.isEmpty()) {
            if (onlineMatches.size() == 1 && ((ServerPlayer)onlineMatches.get(0)).getName().getString().equalsIgnoreCase(searchName)) {
                source.sendSuccess(() -> SEEN_PREFIX.copy().append((Component)Component.literal((String)((ServerPlayer)onlineMatches.get(0)).getName().getString()).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)" is currently online.").withStyle(ChatFormatting.YELLOW)), false);
                return 1;
            }
            source.sendSuccess(() -> SEEN_PREFIX.copy().append((Component)Component.literal((String)"Online players matching '").withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)searchName).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)"':").withStyle(ChatFormatting.YELLOW)), false);
            onlineMatches.forEach(p -> source.sendSuccess(() -> SEEN_PREFIX.copy().append((Component)Component.literal((String)"- ").withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)p.getName().getString()).withStyle(ChatFormatting.GREEN)), false));
            if (onlineMatches.stream().noneMatch(p -> p.getName().getString().equalsIgnoreCase(searchName))) {
                source.sendSuccess(() -> SEEN_PREFIX.copy().append((Component)Component.literal((String)"For offline status, try an exact name or check /seenlist.").withStyle(ChatFormatting.YELLOW)), false);
            }
            return 1;
        }
        Map<UUID, PlayerSeenEntry> seenData = SeenManager.getAllSeenData(server);
        List offlineMatches = seenData.values().stream().filter(entry -> entry.playerName().toLowerCase(Locale.ROOT).contains(searchName)).sorted(Comparator.comparingLong(PlayerSeenEntry::lastSeenTimestamp).reversed()).collect(Collectors.toList());
        if (offlineMatches.isEmpty()) {
            source.sendFailure((Component)SEEN_PREFIX.copy().append((Component)Component.literal((String)"Player '").withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)searchName).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)"' not found. They may have never joined or data is not yet available.").withStyle(ChatFormatting.YELLOW)));
            return 0;
        }
        if (offlineMatches.size() == 1 || ((PlayerSeenEntry)offlineMatches.get(0)).playerName().equalsIgnoreCase(searchName)) {
            PlayerSeenEntry match = (PlayerSeenEntry)offlineMatches.get(0);
            source.sendSuccess(() -> SEEN_PREFIX.copy().append((Component)Component.literal((String)match.playerName()).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)" was last seen ").withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)SeenCommand.formatTimeDifference(match.lastSeenTimestamp())).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)" (").withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)DATE_FORMAT.format(new Date(match.lastSeenTimestamp()))).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)")").withStyle(ChatFormatting.YELLOW)), false);
            return 1;
        }
        source.sendSuccess(() -> SEEN_PREFIX.copy().append((Component)Component.literal((String)"Offline players matching '").withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)searchName).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)"':").withStyle(ChatFormatting.YELLOW)), false);
        int showCount = Math.min(5, offlineMatches.size());
        for (int i = 0; i < showCount; ++i) {
            PlayerSeenEntry entry2 = (PlayerSeenEntry)offlineMatches.get(i);
            source.sendSuccess(() -> SEEN_PREFIX.copy().append((Component)Component.literal((String)"- ").withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)entry2.playerName()).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)" (last seen ").withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)SeenCommand.formatTimeDifference(entry2.lastSeenTimestamp())).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)")").withStyle(ChatFormatting.YELLOW)), false);
        }
        if (offlineMatches.size() > showCount) {
            source.sendSuccess(() -> SEEN_PREFIX.copy().append((Component)Component.literal((String)"...and ").withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)String.valueOf(offlineMatches.size() - showCount)).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)" more. Use a more specific name or check /seenlist.").withStyle(ChatFormatting.YELLOW)), false);
        }
        return 1;
    }

    private static int runSeenList(CommandContext<CommandSourceStack> context, int page) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        MinecraftServer server = source.getServer();
        Map<UUID, PlayerSeenEntry> seenData = SeenManager.getAllSeenData(server);
        if (seenData.isEmpty()) {
            source.sendSuccess(() -> SEEN_PREFIX.copy().append((Component)Component.literal((String)"No player data found.").withStyle(ChatFormatting.YELLOW)), false);
            return 0;
        }
        List sortedEntries = seenData.values().stream().sorted(Comparator.comparingLong(PlayerSeenEntry::lastSeenTimestamp).reversed()).collect(Collectors.toList());
        int totalEntries = sortedEntries.size();
        int maxPage = (totalEntries + 10 - 1) / 10;
        if (page < 1 || page > maxPage) {
            source.sendFailure((Component)SEEN_PREFIX.copy().append((Component)Component.literal((String)"Invalid page number. Max page: ").withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)String.valueOf(maxPage)).withStyle(ChatFormatting.GREEN)));
            return 0;
        }
        source.sendSuccess(() -> SEEN_PREFIX.copy().append((Component)Component.literal((String)"===== Player Logout Times (Page ").withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)String.valueOf(page)).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)String.valueOf(maxPage)).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)") =====").withStyle(ChatFormatting.YELLOW)), false);
        int startIndex = (page - 1) * 10;
        int endIndex = Math.min(startIndex + 10, totalEntries);
        for (int i = startIndex; i < endIndex; ++i) {
            PlayerSeenEntry entry = (PlayerSeenEntry)sortedEntries.get(i);
            source.sendSuccess(() -> SEEN_PREFIX.copy().append((Component)Component.literal((String)entry.playerName()).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)": ").withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)SeenCommand.formatTimeDifference(entry.lastSeenTimestamp())).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)" (").withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)DATE_FORMAT.format(new Date(entry.lastSeenTimestamp()))).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)")").withStyle(ChatFormatting.YELLOW)), false);
        }
        if (page < maxPage) {
            source.sendSuccess(() -> SEEN_PREFIX.copy().append((Component)Component.literal((String)"Use ").withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)("/seenlist " + (page + 1))).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)" to see the next page.").withStyle(ChatFormatting.YELLOW)), false);
        }
        return 1;
    }

    private static String formatTimeDifference(long timestamp) {
        long diffInDays;
        long now = System.currentTimeMillis();
        long diffInSeconds = (now - timestamp) / 1000L;
        if (diffInSeconds < 0L) {
            return "in the future?!";
        }
        if (diffInSeconds < 60L) {
            return diffInSeconds + " second" + (diffInSeconds != 1L ? "s" : "") + " ago";
        }
        long diffInMinutes = diffInSeconds / 60L;
        if (diffInMinutes < 60L) {
            return diffInMinutes + " minute" + (diffInMinutes != 1L ? "s" : "") + " ago";
        }
        long diffInHours = diffInMinutes / 60L;
        if (diffInHours < 24L) {
            return diffInHours + " hour" + (diffInHours != 1L ? "s" : "") + " ago";
        }
        return diffInDays + " day" + ((diffInDays = diffInHours / 24L) != 1L ? "s" : "") + " ago";
    }
}

