/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.seen;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.seen.PlayerSeenEntry;
import world.landfall.landfallessentials.seen.SeenPersistentState;

public class SeenManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SeenManager.class);

    public static void initialize() {
        LOGGER.debug("SeenManager initialized. Event handling via NeoForge event bus.");
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player playerEntity = event.getEntity();
        if (playerEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)playerEntity;
            MinecraftServer server = player.getServer();
            if (server == null) {
                return;
            }
            ServerLevel overworld = server.overworld();
            if (overworld == null) {
                LOGGER.warn("Overworld is null during PlayerLoggedInEvent for {}. Cannot update seen data.", (Object)player.getName().getString());
                return;
            }
            SeenPersistentState persistentState = SeenPersistentState.getServerState(overworld);
            PlayerSeenEntry existingEntry = persistentState.getPlayerSeenEntry(player.getUUID());
            if (existingEntry != null) {
                if (!existingEntry.playerName().equals(player.getName().getString())) {
                    persistentState.updatePlayerName(player.getUUID(), player.getName().getString());
                    LOGGER.debug("Updated player name for {} in seen data.", (Object)player.getName().getString());
                }
            } else {
                persistentState.updatePlayerSeenEntry(player.getUUID(), player.getName().getString(), System.currentTimeMillis());
                LOGGER.debug("Initial seen data created for new player {}.", (Object)player.getName().getString());
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player playerEntity = event.getEntity();
        if (playerEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)playerEntity;
            MinecraftServer server = player.getServer();
            if (server == null) {
                return;
            }
            ServerLevel overworld = server.overworld();
            if (overworld == null) {
                LOGGER.warn("Overworld is null during PlayerLoggedOutEvent for {}. Cannot update seen data.", (Object)player.getName().getString());
                return;
            }
            SeenPersistentState persistentState = SeenPersistentState.getServerState(overworld);
            persistentState.updatePlayerSeenEntry(player.getUUID(), player.getName().getString(), System.currentTimeMillis());
            LOGGER.debug("Recorded logout time for {}", (Object)player.getName().getString());
        }
    }

    public static PlayerSeenEntry getPlayerSeenData(MinecraftServer server, UUID playerUuid) {
        if (server == null) {
            return null;
        }
        ServerLevel overworld = server.overworld();
        if (overworld == null) {
            return null;
        }
        SeenPersistentState persistentState = SeenPersistentState.getServerState(overworld);
        return persistentState.getPlayerSeenEntry(playerUuid);
    }

    public static Map<UUID, PlayerSeenEntry> getAllSeenData(MinecraftServer server) {
        if (server == null) {
            return new HashMap<UUID, PlayerSeenEntry>();
        }
        ServerLevel overworld = server.overworld();
        if (overworld == null) {
            return new HashMap<UUID, PlayerSeenEntry>();
        }
        SeenPersistentState persistentState = SeenPersistentState.getServerState(overworld);
        return persistentState.getAllSeenEntries();
    }
}

