/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.tpa;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.tpa.TPALuckPermsIntegration;
import world.landfall.landfallessentials.tpa.TPARequest;

public class TPAManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TPAManager.class);
    private static final Duration REQUEST_EXPIRY = Duration.ofSeconds(60L);
    private static Duration COOLDOWN_DURATION = Duration.ofMinutes(2L);
    private final Map<UUID, TPARequest> activeRequests = new ConcurrentHashMap<UUID, TPARequest>();
    private final Map<UUID, Instant> cooldowns = new ConcurrentHashMap<UUID, Instant>();
    private MinecraftServer server;
    private static volatile TPAManager instance;
    public static final Component TPA_PREFIX;

    private TPAManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TPAManager getInstance() {
        if (instance != null) return instance;
        Class<TPAManager> clazz = TPAManager.class;
        synchronized (TPAManager.class) {
            if (instance != null) return instance;
            instance = new TPAManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setServer(MinecraftServer server) {
        this.server = server;
    }

    private void sendSystemMessage(ServerPlayer player, Component message) {
        player.sendSystemMessage((Component)TPA_PREFIX.copy().append(message));
    }

    private MutableComponent formatPlayerName(String playerName) {
        return Component.literal((String)playerName).withStyle(ChatFormatting.GREEN);
    }

    public boolean createRequest(ServerPlayer from, ServerPlayer to, boolean isTpaHere) {
        Duration currentCooldown;
        UUID fromUUID = from.getUUID();
        long cooldownOverride = TPALuckPermsIntegration.getCooldownOverride(from);
        Duration duration = currentCooldown = cooldownOverride >= 0L ? Duration.ofSeconds(cooldownOverride) : COOLDOWN_DURATION;
        if (this.isOnCooldown(fromUUID, currentCooldown)) {
            Duration remaining = this.getRemainingCooldown(fromUUID, currentCooldown);
            this.sendSystemMessage(from, (Component)Component.literal((String)"You must wait ").append((Component)Component.literal((String)this.formatDuration(remaining)).withStyle(ChatFormatting.RED)).append((Component)Component.literal((String)" before sending another request.").withStyle(ChatFormatting.YELLOW)));
            return false;
        }
        if (this.activeRequests.containsKey(fromUUID)) {
            this.sendSystemMessage(from, (Component)Component.literal((String)"You already have an active teleport request.").withStyle(ChatFormatting.RED));
            return false;
        }
        TPARequest request = new TPARequest(fromUUID, to.getUUID(), Instant.now().plus(REQUEST_EXPIRY), isTpaHere);
        this.activeRequests.put(fromUUID, request);
        MutableComponent notificationToTarget = this.formatPlayerName(from.getScoreboardName()).copy();
        if (isTpaHere) {
            notificationToTarget.append((Component)Component.literal((String)" wants you to teleport to them (").withStyle(ChatFormatting.YELLOW)).append((Component)this.formatPlayerName(from.getScoreboardName())).append((Component)Component.literal((String)" <- ").withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)"You").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)").").withStyle(ChatFormatting.YELLOW));
        } else {
            notificationToTarget.append((Component)Component.literal((String)" wants to teleport to you (").withStyle(ChatFormatting.YELLOW)).append((Component)this.formatPlayerName(from.getScoreboardName())).append((Component)Component.literal((String)" -> ").withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)"You").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)").").withStyle(ChatFormatting.YELLOW));
        }
        MutableComponent acceptButton = Component.literal((String)" [\u2714 Accept]").withStyle(ChatFormatting.GREEN).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tpaccept " + from.getScoreboardName())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)("Click to accept request from " + from.getScoreboardName())))));
        MutableComponent denyButton = Component.literal((String)" [\u2718 Deny]").withStyle(ChatFormatting.RED).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tpdeny " + from.getScoreboardName())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)("Click to deny request from " + from.getScoreboardName())))));
        notificationToTarget.append((Component)acceptButton).append((Component)denyButton);
        this.sendSystemMessage(to, (Component)notificationToTarget);
        MutableComponent confirmationToSender = Component.literal((String)"Teleport request sent: ").withStyle(ChatFormatting.YELLOW);
        if (isTpaHere) {
            confirmationToSender.append((Component)this.formatPlayerName(from.getScoreboardName())).append((Component)Component.literal((String)" <- ").withStyle(ChatFormatting.YELLOW)).append((Component)this.formatPlayerName(to.getScoreboardName()));
        } else {
            confirmationToSender.append((Component)this.formatPlayerName(from.getScoreboardName())).append((Component)Component.literal((String)" -> ").withStyle(ChatFormatting.YELLOW)).append((Component)this.formatPlayerName(to.getScoreboardName()));
        }
        this.sendSystemMessage(from, (Component)confirmationToSender);
        return true;
    }

    public boolean acceptRequest(ServerPlayer acceptor, ServerPlayer requester) {
        TPARequest request = this.activeRequests.get(requester.getUUID());
        if (request == null || !request.getToPlayer().equals(acceptor.getUUID())) {
            this.sendSystemMessage(acceptor, (Component)Component.literal((String)"No active teleport request from ").append((Component)this.formatPlayerName(requester.getScoreboardName())).append((Component)Component.literal((String)".").withStyle(ChatFormatting.RED)).withStyle(ChatFormatting.RED));
            return false;
        }
        if (request.isExpired()) {
            this.activeRequests.remove(requester.getUUID());
            this.sendSystemMessage(acceptor, (Component)Component.literal((String)"The teleport request from ").append((Component)this.formatPlayerName(requester.getScoreboardName())).append((Component)Component.literal((String)" has expired.").withStyle(ChatFormatting.RED)).withStyle(ChatFormatting.RED));
            this.sendSystemMessage(requester, (Component)Component.literal((String)"Your teleport request to ").append((Component)this.formatPlayerName(acceptor.getScoreboardName())).append((Component)Component.literal((String)" has expired.").withStyle(ChatFormatting.RED)).withStyle(ChatFormatting.RED));
            return false;
        }
        this.activeRequests.remove(requester.getUUID());
        long cooldownOverride = TPALuckPermsIntegration.getCooldownOverride(requester);
        Duration currentCooldown = cooldownOverride >= 0L ? Duration.ofSeconds(cooldownOverride) : COOLDOWN_DURATION;
        this.cooldowns.put(requester.getUUID(), Instant.now().plus(currentCooldown));
        if (request.isTpaHere()) {
            this.sendSystemMessage(acceptor, (Component)Component.literal((String)"Accepted. Teleporting ").append((Component)this.formatPlayerName(acceptor.getScoreboardName())).append((Component)Component.literal((String)" to ").withStyle(ChatFormatting.YELLOW)).append((Component)this.formatPlayerName(requester.getScoreboardName())).append((Component)Component.literal((String)".").withStyle(ChatFormatting.YELLOW)).withStyle(ChatFormatting.GREEN));
            this.sendSystemMessage(requester, (Component)this.formatPlayerName(acceptor.getScoreboardName()).copy().append((Component)Component.literal((String)" accepted your request. You are being teleported to them.").withStyle(ChatFormatting.GREEN)));
        } else {
            this.sendSystemMessage(acceptor, (Component)Component.literal((String)"Accepted. Teleporting ").append((Component)this.formatPlayerName(requester.getScoreboardName())).append((Component)Component.literal((String)" to you.").withStyle(ChatFormatting.YELLOW)).withStyle(ChatFormatting.GREEN));
            this.sendSystemMessage(requester, (Component)this.formatPlayerName(acceptor.getScoreboardName()).copy().append((Component)Component.literal((String)" accepted your teleport request.").withStyle(ChatFormatting.GREEN)));
        }
        return true;
    }

    public void denyRequest(ServerPlayer denier, ServerPlayer requester) {
        TPARequest request = this.activeRequests.get(requester.getUUID());
        if (request == null || !request.getToPlayer().equals(denier.getUUID())) {
            this.sendSystemMessage(denier, (Component)Component.literal((String)"No active teleport request from ").append((Component)this.formatPlayerName(requester.getScoreboardName())).append((Component)Component.literal((String)".").withStyle(ChatFormatting.RED)).withStyle(ChatFormatting.RED));
            return;
        }
        this.activeRequests.remove(requester.getUUID());
        this.sendSystemMessage(denier, (Component)Component.literal((String)"Denied teleport request from ").append((Component)this.formatPlayerName(requester.getScoreboardName())).append((Component)Component.literal((String)".").withStyle(ChatFormatting.YELLOW)).withStyle(ChatFormatting.YELLOW));
        this.sendSystemMessage(requester, (Component)this.formatPlayerName(denier.getScoreboardName()).copy().append((Component)Component.literal((String)" denied your teleport request.").withStyle(ChatFormatting.RED)));
    }

    public void cancelRequest(ServerPlayer requester) {
        ServerPlayer targetPlayer;
        TPARequest request = this.activeRequests.remove(requester.getUUID());
        if (request == null) {
            this.sendSystemMessage(requester, (Component)Component.literal((String)"You don't have any active teleport requests to cancel.").withStyle(ChatFormatting.RED));
            return;
        }
        if (this.server != null && (targetPlayer = this.server.getPlayerList().getPlayer(request.getToPlayer())) != null) {
            this.sendSystemMessage(targetPlayer, (Component)this.formatPlayerName(requester.getScoreboardName()).copy().append((Component)Component.literal((String)" cancelled their teleport request to you.").withStyle(ChatFormatting.YELLOW)));
        }
        this.sendSystemMessage(requester, (Component)Component.literal((String)"Cancelled your teleport request.").withStyle(ChatFormatting.YELLOW));
    }

    public void cleanupExpiredRequests() {
        this.activeRequests.entrySet().removeIf(entry -> {
            if (((TPARequest)entry.getValue()).isExpired()) {
                if (this.server != null) {
                    MutableComponent toName;
                    ServerPlayer fromPlayer = this.server.getPlayerList().getPlayer(((TPARequest)entry.getValue()).getFromPlayer());
                    ServerPlayer toPlayer = this.server.getPlayerList().getPlayer(((TPARequest)entry.getValue()).getToPlayer());
                    MutableComponent fromName = fromPlayer != null ? this.formatPlayerName(fromPlayer.getScoreboardName()) : Component.literal((String)"another player").withStyle(ChatFormatting.GREEN);
                    MutableComponent mutableComponent = toName = toPlayer != null ? this.formatPlayerName(toPlayer.getScoreboardName()) : Component.literal((String)"another player").withStyle(ChatFormatting.GREEN);
                    if (fromPlayer != null) {
                        this.sendSystemMessage(fromPlayer, (Component)Component.literal((String)"Your teleport request to ").append((Component)toName.copy()).append((Component)Component.literal((String)" has timed out.").withStyle(ChatFormatting.RED)));
                    }
                    if (toPlayer != null) {
                        this.sendSystemMessage(toPlayer, (Component)Component.literal((String)"The teleport request from ").append((Component)fromName.copy()).append((Component)Component.literal((String)" has timed out.").withStyle(ChatFormatting.RED)));
                    }
                }
                return true;
            }
            return false;
        });
    }

    public void resetAllCooldowns() {
        this.cooldowns.clear();
    }

    public void cleanupPlayerData(UUID playerUUID) {
        if (playerUUID == null) {
            return;
        }
        TPARequest request = this.activeRequests.remove(playerUUID);
        if (request != null) {
            LOGGER.debug("Removed active TPA request from disconnected player: {}", (Object)playerUUID);
        }
        this.cooldowns.remove(playerUUID);
        this.activeRequests.entrySet().removeIf(entry -> {
            if (((TPARequest)entry.getValue()).getToPlayer().equals(playerUUID)) {
                LOGGER.debug("Removed TPA request to disconnected player: {}", (Object)playerUUID);
                return true;
            }
            return false;
        });
    }

    private boolean isOnCooldown(UUID player, Duration specificCooldown) {
        Instant cooldownEnd = this.cooldowns.get(player);
        if (cooldownEnd == null) {
            return false;
        }
        return Instant.now().isBefore(cooldownEnd);
    }

    private Duration getRemainingCooldown(UUID player, Duration specificCooldown) {
        Instant cooldownEnd = this.cooldowns.get(player);
        if (cooldownEnd == null) {
            return Duration.ZERO;
        }
        Duration remaining = Duration.between(Instant.now(), cooldownEnd);
        return remaining.isNegative() ? Duration.ZERO : remaining;
    }

    private String formatDuration(Duration duration) {
        long seconds = duration.getSeconds();
        if (seconds < 0L) {
            seconds = 0L;
        }
        if (seconds < 60L) {
            return String.format("%d second%s", seconds, seconds == 1L ? "" : "s");
        }
        long minutes = seconds / 60L;
        long remainingSeconds = seconds % 60L;
        if (remainingSeconds == 0L) {
            return String.format("%d minute%s", minutes, minutes == 1L ? "" : "s");
        }
        return String.format("%d minute%s and %d second%s", minutes, minutes == 1L ? "" : "s", remainingSeconds, remainingSeconds == 1L ? "" : "s");
    }

    public boolean isTpaHereRequest(UUID requesterUUID) {
        TPARequest request = this.activeRequests.get(requesterUUID);
        return request != null && request.isTpaHere();
    }

    public ServerPlayer getLatestRequester(UUID targetUUID) {
        Instant latestTime = Instant.MIN;
        UUID latestRequesterUUID = null;
        for (Map.Entry<UUID, TPARequest> entry : this.activeRequests.entrySet()) {
            TPARequest currentRequest = entry.getValue();
            if (!currentRequest.getToPlayer().equals(targetUUID) || !currentRequest.getExpirationTime().isAfter(latestTime) || currentRequest.isExpired()) continue;
            latestTime = currentRequest.getExpirationTime();
            latestRequesterUUID = entry.getKey();
        }
        if (latestRequesterUUID == null) {
            return null;
        }
        if (this.server == null) {
            LOGGER.error("TPAManager: MinecraftServer instance is null! Cannot find player for latest TPA request. Ensure setServer() is called during server startup.");
            return null;
        }
        return this.server.getPlayerList().getPlayer(latestRequesterUUID);
    }

    static {
        TPA_PREFIX = Component.literal((String)"[").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)"TPA").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)"] ").withStyle(ChatFormatting.YELLOW));
    }
}

