/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.api;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.world.entity.player.Player;
import world.landfall.landfallessentials.regions.RegionManager;

public final class RegionTagAPI {
    public static final String API_VERSION = "1.0.0";

    private RegionTagAPI() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    public static String getAPIVersion() {
        return API_VERSION;
    }

    public static boolean isPlayerInTaggedRegion(Player player, String tag) {
        if (player == null) {
            throw new IllegalArgumentException("Player cannot be null");
        }
        if (tag == null || tag.trim().isEmpty()) {
            throw new IllegalArgumentException("Tag cannot be null or empty");
        }
        return RegionManager.isPlayerInTaggedRegion(player, tag.trim());
    }

    public static Set<String> getPlayerRegionTags(Player player) {
        if (player == null) {
            throw new IllegalArgumentException("Player cannot be null");
        }
        Set<String> tags = RegionManager.getPlayerRegionTags(player);
        return Collections.unmodifiableSet(tags);
    }

    public static List<String> getRegionsWithTag(String tag) {
        if (tag == null || tag.trim().isEmpty()) {
            throw new IllegalArgumentException("Tag cannot be null or empty");
        }
        List<String> regions = RegionManager.getRegionsWithTag(tag.trim());
        return Collections.unmodifiableList(regions);
    }

    public static Set<String> getAllTags() {
        Set<String> tags = RegionManager.getAllTags();
        return Collections.unmodifiableSet(tags);
    }

    public static Set<String> getRegionTags(String regionName) {
        if (regionName == null || regionName.trim().isEmpty()) {
            throw new IllegalArgumentException("Region name cannot be null or empty");
        }
        Set<String> tags = RegionManager.getRegionTags(regionName.trim());
        return Collections.unmodifiableSet(tags);
    }

    public static boolean regionHasTag(String regionName, String tag) {
        if (regionName == null || regionName.trim().isEmpty()) {
            throw new IllegalArgumentException("Region name cannot be null or empty");
        }
        if (tag == null || tag.trim().isEmpty()) {
            throw new IllegalArgumentException("Tag cannot be null or empty");
        }
        return RegionManager.regionHasTag(regionName.trim(), tag.trim());
    }
}

