/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.api.karma;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.loading.FMLEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.api.karma.IKarmaAPI;
import world.landfall.landfallessentials.api.karma.KarmaTransaction;
import world.landfall.landfallessentials.karma.KarmaData;
import world.landfall.landfallessentials.karma.LuckPermsIntegration;

public class KarmaAPI
implements IKarmaAPI {
    private static final Logger LOGGER = LoggerFactory.getLogger(KarmaAPI.class);
    private static KarmaAPI instance;
    private final Map<UUID, KarmaTransaction> activeTransactions = new ConcurrentHashMap<UUID, KarmaTransaction>();
    private final Map<String, Integer> karmaSourceStats = new ConcurrentHashMap<String, Integer>();

    private KarmaAPI() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KarmaAPI getInstance() {
        if (instance != null) return instance;
        Class<KarmaAPI> clazz = KarmaAPI.class;
        synchronized (KarmaAPI.class) {
            if (instance != null) return instance;
            instance = new KarmaAPI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private KarmaData getKarmaData(MinecraftServer server) {
        if (server == null) {
            LOGGER.warn("Server is null when trying to get KarmaData");
            return null;
        }
        ServerLevel overworldLevel = server.overworld();
        return KarmaData.get(overworldLevel);
    }

    private KarmaData getKarmaData(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return this.getKarmaData(serverPlayer.getServer());
        }
        return null;
    }

    @Override
    public int getKarma(UUID playerUUID, MinecraftServer server) {
        if (FMLEnvironment.dist.isClient()) {
            return 0;
        }
        if (playerUUID == null || server == null) {
            return 0;
        }
        KarmaData data = this.getKarmaData(server);
        return data != null ? data.getKarma(playerUUID) : 0;
    }

    @Override
    public int getKarma(Player player) {
        if (FMLEnvironment.dist.isClient() || player == null) {
            return 0;
        }
        KarmaData data = this.getKarmaData(player);
        return data != null ? data.getKarma(player.getUUID()) : 0;
    }

    @Override
    public double getTotalKarma(UUID playerUUID, MinecraftServer server) {
        if (FMLEnvironment.dist.isClient()) {
            return 0.0;
        }
        if (playerUUID == null || server == null) {
            return 0.0;
        }
        KarmaData data = this.getKarmaData(server);
        if (data != null) {
            int wholeKarma = data.getKarma(playerUUID);
            double fractionalKarma = data.getFractionalKarma(playerUUID);
            return (double)wholeKarma + fractionalKarma;
        }
        return 0.0;
    }

    @Override
    public double getTotalKarma(Player player) {
        if (FMLEnvironment.dist.isClient() || player == null) {
            return 0.0;
        }
        KarmaData data = this.getKarmaData(player);
        if (data != null) {
            int wholeKarma = data.getKarma(player.getUUID());
            double fractionalKarma = data.getFractionalKarma(player.getUUID());
            return (double)wholeKarma + fractionalKarma;
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setKarma(UUID playerUUID, int amount, MinecraftServer server, @Nullable String source) {
        KarmaData data;
        if (FMLEnvironment.dist.isClient()) {
            return false;
        }
        if (playerUUID == null || server == null) {
            LOGGER.warn("Attempted to set karma with null UUID or server");
            return false;
        }
        if (amount < 0) {
            LOGGER.warn("Attempted to set negative karma for player {}. Clamping to 0.", (Object)playerUUID);
            amount = 0;
        }
        if ((data = this.getKarmaData(server)) != null) {
            KarmaData karmaData = data;
            synchronized (karmaData) {
                int oldKarma = data.getKarma(playerUUID);
                data.setKarma(playerUUID, amount);
                if (source != null) {
                    LOGGER.info("Karma set for player {} from {} to {} by {}", new Object[]{playerUUID, oldKarma, amount, source});
                    this.trackSource(source);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean setKarma(Player player, int amount, @Nullable String source) {
        if (player == null) {
            return false;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return this.setKarma(player.getUUID(), amount, serverPlayer.getServer(), source);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addKarma(UUID playerUUID, int amount, MinecraftServer server, @Nullable String source) {
        if (FMLEnvironment.dist.isClient()) {
            return false;
        }
        if (playerUUID == null || server == null) {
            LOGGER.warn("Attempted to add karma with null UUID or server");
            return false;
        }
        if (amount <= 0) {
            LOGGER.warn("Attempted to add non-positive karma amount: {}", (Object)amount);
            return false;
        }
        KarmaData data = this.getKarmaData(server);
        if (data != null) {
            KarmaData karmaData = data;
            synchronized (karmaData) {
                data.addKarma(playerUUID, amount);
                if (source != null) {
                    LOGGER.debug("Added {} karma to player {} from source: {}", new Object[]{amount, playerUUID, source});
                    this.trackSource(source);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean addKarma(Player player, int amount, @Nullable String source) {
        if (player == null) {
            return false;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return this.addKarma(player.getUUID(), amount, serverPlayer.getServer(), source);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addFractionalKarma(UUID playerUUID, double amount, MinecraftServer server, @Nullable String source) {
        if (FMLEnvironment.dist.isClient()) {
            return false;
        }
        if (playerUUID == null || server == null) {
            LOGGER.warn("Attempted to add fractional karma with null UUID or server");
            return false;
        }
        if (amount <= 0.0) {
            LOGGER.warn("Attempted to add non-positive fractional karma amount: {}", (Object)amount);
            return false;
        }
        KarmaData data = this.getKarmaData(server);
        if (data != null) {
            KarmaData karmaData = data;
            synchronized (karmaData) {
                data.addFractionalKarma(playerUUID, amount);
                if (source != null) {
                    LOGGER.debug("Added {} fractional karma to player {} from source: {}", new Object[]{amount, playerUUID, source});
                    this.trackSource(source);
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeKarma(UUID playerUUID, int amount, MinecraftServer server, @Nullable String reason) {
        if (FMLEnvironment.dist.isClient()) {
            return false;
        }
        if (playerUUID == null || server == null) {
            LOGGER.warn("Attempted to remove karma with null UUID or server");
            return false;
        }
        if (amount <= 0) {
            LOGGER.warn("Attempted to remove non-positive karma amount: {}", (Object)amount);
            return false;
        }
        KarmaData data = this.getKarmaData(server);
        if (data != null) {
            KarmaData karmaData = data;
            synchronized (karmaData) {
                data.removeKarma(playerUUID, amount);
                if (reason != null) {
                    LOGGER.debug("Removed {} karma from player {} for reason: {}", new Object[]{amount, playerUUID, reason});
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean removeKarma(Player player, int amount, @Nullable String reason) {
        if (player == null) {
            return false;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return this.removeKarma(player.getUUID(), amount, serverPlayer.getServer(), reason);
        }
        return false;
    }

    @Override
    public boolean hasKarma(UUID playerUUID, int amount, MinecraftServer server) {
        return this.getKarma(playerUUID, server) >= amount;
    }

    @Override
    public boolean hasKarma(Player player, int amount) {
        return this.getKarma(player) >= amount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean spendKarma(UUID playerUUID, int amount, MinecraftServer server, @Nullable String reason) {
        if (FMLEnvironment.dist.isClient()) {
            return false;
        }
        if (playerUUID == null || server == null || amount <= 0) {
            return false;
        }
        KarmaData data = this.getKarmaData(server);
        if (data != null) {
            KarmaData karmaData = data;
            synchronized (karmaData) {
                if (data.getKarma(playerUUID) >= amount) {
                    data.removeKarma(playerUUID, amount);
                    if (reason != null) {
                        LOGGER.info("Player {} spent {} karma for: {}", new Object[]{playerUUID, amount, reason});
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean spendKarma(Player player, int amount, @Nullable String reason) {
        if (player == null) {
            return false;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return this.spendKarma(player.getUUID(), amount, serverPlayer.getServer(), reason);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<UUID, Integer> getAllKarma(MinecraftServer server) {
        if (FMLEnvironment.dist.isClient() || server == null) {
            return Collections.emptyMap();
        }
        KarmaData data = this.getKarmaData(server);
        if (data != null) {
            KarmaData karmaData = data;
            synchronized (karmaData) {
                return new HashMap<UUID, Integer>(data.getAllKarma());
            }
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<UUID, Integer> getTopKarmaPlayers(int limit, MinecraftServer server) {
        if (FMLEnvironment.dist.isClient() || server == null || limit <= 0) {
            return Collections.emptyMap();
        }
        Map<UUID, Integer> allKarma = this.getAllKarma(server);
        return allKarma.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(limit).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    @Override
    public KarmaTransaction beginTransaction(UUID playerUUID) {
        if (playerUUID == null) {
            throw new IllegalArgumentException("Player UUID cannot be null");
        }
        if (this.activeTransactions.containsKey(playerUUID)) {
            LOGGER.warn("Player {} already has an active transaction. Rolling it back.", (Object)playerUUID);
            this.rollbackTransaction(this.activeTransactions.get(playerUUID));
        }
        int currentKarma = 0;
        KarmaTransaction transaction = new KarmaTransaction(playerUUID, currentKarma);
        this.activeTransactions.put(playerUUID, transaction);
        LOGGER.debug("Started karma transaction for player {}", (Object)playerUUID);
        return transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitTransaction(KarmaTransaction transaction, MinecraftServer server) {
        if (transaction == null || server == null) {
            return false;
        }
        if (transaction.isCommitted() || transaction.isRolledBack()) {
            LOGGER.warn("Attempted to commit already finalized transaction: {}", (Object)transaction);
            return false;
        }
        UUID playerUUID = transaction.getPlayerUUID();
        this.activeTransactions.remove(playerUUID);
        if (transaction.isEmpty()) {
            transaction.markCommitted();
            return true;
        }
        KarmaData data = this.getKarmaData(server);
        if (data != null) {
            KarmaData karmaData = data;
            synchronized (karmaData) {
                int currentKarma = data.getKarma(playerUUID);
                for (KarmaTransaction.Operation op : transaction.getOperations()) {
                    switch (op.getType()) {
                        case ADD: {
                            data.addKarma(playerUUID, op.getAmount());
                            break;
                        }
                        case REMOVE: {
                            data.removeKarma(playerUUID, op.getAmount());
                            break;
                        }
                        case SET: {
                            data.setKarma(playerUUID, op.getAmount());
                        }
                    }
                }
                transaction.markCommitted();
                int finalKarma = data.getKarma(playerUUID);
                LOGGER.info("Committed karma transaction for player {}: {} -> {} ({} operations)", new Object[]{playerUUID, currentKarma, finalKarma, transaction.getOperationCount()});
                return true;
            }
        }
        return false;
    }

    @Override
    public void rollbackTransaction(KarmaTransaction transaction) {
        if (transaction == null) {
            return;
        }
        if (transaction.isCommitted() || transaction.isRolledBack()) {
            LOGGER.warn("Attempted to rollback already finalized transaction: {}", (Object)transaction);
            return;
        }
        this.activeTransactions.remove(transaction.getPlayerUUID());
        transaction.markRolledBack();
        LOGGER.debug("Rolled back karma transaction for player {}", (Object)transaction.getPlayerUUID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<UUID, Boolean> addKarmaBatch(Map<UUID, Integer> players, MinecraftServer server, @Nullable String source) {
        if (FMLEnvironment.dist.isClient() || players == null || server == null) {
            return Collections.emptyMap();
        }
        HashMap<UUID, Boolean> results = new HashMap<UUID, Boolean>();
        KarmaData data = this.getKarmaData(server);
        if (data != null) {
            KarmaData karmaData = data;
            synchronized (karmaData) {
                for (Map.Entry<UUID, Integer> entry : players.entrySet()) {
                    UUID playerUUID = entry.getKey();
                    Integer amount = entry.getValue();
                    if (playerUUID != null && amount != null && amount > 0) {
                        data.addKarma(playerUUID, amount);
                        results.put(playerUUID, true);
                        continue;
                    }
                    results.put(playerUUID, false);
                }
                if (source != null) {
                    LOGGER.info("Batch added karma to {} players from source: {}", (Object)players.size(), (Object)source);
                    this.trackSource(source);
                }
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<UUID, Boolean> removeKarmaBatch(Map<UUID, Integer> players, MinecraftServer server, @Nullable String reason) {
        if (FMLEnvironment.dist.isClient() || players == null || server == null) {
            return Collections.emptyMap();
        }
        HashMap<UUID, Boolean> results = new HashMap<UUID, Boolean>();
        KarmaData data = this.getKarmaData(server);
        if (data != null) {
            KarmaData karmaData = data;
            synchronized (karmaData) {
                for (Map.Entry<UUID, Integer> entry : players.entrySet()) {
                    UUID playerUUID = entry.getKey();
                    Integer amount = entry.getValue();
                    if (playerUUID != null && amount != null && amount > 0) {
                        data.removeKarma(playerUUID, amount);
                        results.put(playerUUID, true);
                        continue;
                    }
                    results.put(playerUUID, false);
                }
                if (reason != null) {
                    LOGGER.info("Batch removed karma from {} players for reason: {}", (Object)players.size(), (Object)reason);
                }
            }
        }
        return results;
    }

    @Override
    public CompletableFuture<Integer> getKarmaAsync(UUID playerUUID, MinecraftServer server) {
        return CompletableFuture.supplyAsync(() -> this.getKarma(playerUUID, server));
    }

    @Override
    public String getDonorLevel(ServerPlayer player) {
        if (FMLEnvironment.dist.isClient() || player == null) {
            return "";
        }
        return LuckPermsIntegration.getDonorLevel(player);
    }

    @Override
    public double getDonorBonus(ServerPlayer player) {
        if (FMLEnvironment.dist.isClient() || player == null) {
            return 0.0;
        }
        return LuckPermsIntegration.getDonorBonus(player);
    }

    @Override
    public int calculateGroupBonus(ServerPlayer player, int radius) {
        if (FMLEnvironment.dist.isClient() || player == null) {
            return 0;
        }
        if (player.getServer() == null) {
            return 0;
        }
        int nearbyPlayers = 0;
        for (ServerPlayer otherPlayer : player.getServer().getPlayerList().getPlayers()) {
            double distance;
            if (otherPlayer.getUUID().equals(player.getUUID()) || !((distance = (double)player.distanceTo((Entity)otherPlayer)) <= (double)radius)) continue;
            ++nearbyPlayers;
        }
        return nearbyPlayers;
    }

    @Override
    public boolean isInitialized() {
        return !FMLEnvironment.dist.isClient();
    }

    @Override
    public String getSystemStatus() {
        if (FMLEnvironment.dist.isClient()) {
            return "Client side - API disabled";
        }
        StringBuilder status = new StringBuilder();
        status.append("KarmaAPI Status:\n");
        status.append("- Active transactions: ").append(this.activeTransactions.size()).append("\n");
        status.append("- Tracked sources: ").append(this.karmaSourceStats.size()).append("\n");
        if (!this.karmaSourceStats.isEmpty()) {
            status.append("- Top sources:\n");
            this.karmaSourceStats.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(5L).forEach(entry -> status.append("  - ").append((String)entry.getKey()).append(": ").append(entry.getValue()).append(" operations\n"));
        }
        return status.toString();
    }

    private void trackSource(String source) {
        if (source != null && !source.isEmpty()) {
            this.karmaSourceStats.merge(source, 1, Integer::sum);
        }
    }

    public void cleanupPlayer(UUID playerUUID) {
        if (playerUUID == null) {
            return;
        }
        KarmaTransaction activeTransaction = this.activeTransactions.remove(playerUUID);
        if (activeTransaction != null && !activeTransaction.isCommitted() && !activeTransaction.isRolledBack()) {
            this.rollbackTransaction(activeTransaction);
            LOGGER.info("Rolled back active transaction for disconnected player: {}", (Object)playerUUID);
        }
    }

    public Map<String, Integer> getSourceStatistics() {
        return new HashMap<String, Integer>(this.karmaSourceStats);
    }

    public void clearSourceStatistics() {
        this.karmaSourceStats.clear();
        LOGGER.info("Cleared karma source statistics");
    }
}

