/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.block.custom;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import world.landfall.landfallessentials.block.custom.ShonkBlock;
import world.landfall.landfallessentials.block.entity.PinkShonkBlockEntity;
import world.landfall.landfallessentials.block.entity.ShonkBlockEntity;
import world.landfall.landfallessentials.registry.ModBlockEntities;

public class PinkShonkBlock
extends ShonkBlock {
    public static final MapCodec<PinkShonkBlock> CODEC = PinkShonkBlock.simpleCodec(PinkShonkBlock::new);
    private static final double RANGE = 5.0;

    public PinkShonkBlock(BlockBehaviour.Properties properties) {
        super(properties, 5.0);
    }

    protected MapCodec<? extends ShonkBlock> codec() {
        return CODEC;
    }

    @Override
    protected void applyEffectToEntity(LivingEntity entity, Level level, BlockPos pos) {
        if (!entity.hasEffect(MobEffects.DAMAGE_RESISTANCE)) {
            entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 100, 0, true, false));
        }
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PinkShonkBlockEntity(pos, state);
    }

    @Override
    protected BlockEntityType<? extends ShonkBlockEntity> getBlockEntityType() {
        return ModBlockEntities.PINK_SHONK_BLOCK_ENTITY.get();
    }
}

