/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.block.custom;

import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import world.landfall.landfallessentials.block.entity.ShonkBlockEntity;

public abstract class ShonkBlock
extends BaseEntityBlock {
    private static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    protected final double effectRange;

    public ShonkBlock(BlockBehaviour.Properties properties, double effectRange) {
        super(properties);
        this.effectRange = effectRange;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HorizontalDirectionalBlock.FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.applyAreaEffects((Level)level, pos);
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        return Collections.singletonList(new ItemStack((ItemLike)this));
    }

    public void applyAreaEffects(Level level, BlockPos pos) {
        if (level.isClientSide) {
            return;
        }
        AABB effectArea = new AABB(pos).inflate(this.effectRange);
        List nearbyEntities = level.getEntitiesOfClass(LivingEntity.class, effectArea);
        for (LivingEntity entity : nearbyEntities) {
            this.applyEffectToEntity(entity, level, pos);
        }
    }

    protected abstract void applyEffectToEntity(LivingEntity var1, Level var2, BlockPos var3);

    @Nullable
    public abstract BlockEntity newBlockEntity(BlockPos var1, BlockState var2);

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : ShonkBlock.createTickerHelper(blockEntityType, this.getBlockEntityType(), (level1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof ShonkBlockEntity) {
                ShonkBlockEntity shonkEntity = blockEntity;
                shonkEntity.tick();
            }
        });
    }

    protected abstract BlockEntityType<? extends ShonkBlockEntity> getBlockEntityType();
}

