/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import world.landfall.landfallessentials.Config;
import world.landfall.landfallessentials.monitoring.TpsMonitor;
import world.landfall.landfallessentials.util.WebhookUtil;

@EventBusSubscriber(modid="landfallessentials")
public class WebhookTestCommand {
    @SubscribeEvent
    public static void register(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"webhooktest").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"basic").executes(WebhookTestCommand::executeBasicTest))).then(Commands.literal((String)"conduit").executes(WebhookTestCommand::executeConduitTest))).then(Commands.literal((String)"tps").executes(WebhookTestCommand::executeTpsTest))).then(Commands.literal((String)"system").executes(WebhookTestCommand::executeSystemTest))).executes(WebhookTestCommand::executeBasicTest));
    }

    private static int executeBasicTest(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (!Config.webhookEnabled) {
            source.sendSuccess(() -> Component.literal((String)"\u00a7cWebhook is disabled in the configuration."), false);
            return 0;
        }
        if (Config.webhookUrl == null || Config.webhookUrl.trim().isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)"\u00a7cWebhook URL is not configured."), false);
            return 0;
        }
        source.sendSuccess(() -> Component.literal((String)"\u00a7eSending basic webhook test message..."), false);
        WebhookUtil.sendTestMessage();
        source.sendSuccess(() -> Component.literal((String)"\u00a7aBasic webhook test message sent! Check your Discord channel."), false);
        return 1;
    }

    private static int executeConduitTest(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (!WebhookTestCommand.checkWebhookConfig(source)) {
            return 0;
        }
        if (!Config.alertConduitDestruction) {
            source.sendSuccess(() -> Component.literal((String)"\u00a7cConduit destruction alerts are disabled in the configuration."), false);
            return 0;
        }
        source.sendSuccess(() -> Component.literal((String)"\u00a7eSending test conduit destruction alert..."), false);
        WebhookUtil.sendConduitDestructionAlert("Test Conduit of Testing", "TEST", 123.5, 64.0, -456.7, "minecraft:overworld", "webhook test");
        source.sendSuccess(() -> Component.literal((String)"\u00a7aTest conduit destruction alert sent! Check your Discord channel."), false);
        return 1;
    }

    private static int executeTpsTest(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (!WebhookTestCommand.checkWebhookConfig(source)) {
            return 0;
        }
        if (Config.alertTpsThreshold <= 0.0) {
            source.sendSuccess(() -> Component.literal((String)"\u00a7cTPS alerts are disabled (threshold set to 0)."), false);
            return 0;
        }
        source.sendSuccess(() -> Component.literal((String)"\u00a7eSending test TPS alerts..."), false);
        WebhookUtil.sendTpsAlert(12.5, 13.2, false);
        WebhookUtil.sendTpsAlert(8.1, 9.3, true);
        source.sendSuccess(() -> Component.literal((String)"\u00a7aTest TPS alerts sent (warning + critical)! Check your Discord channel."), false);
        source.sendSuccess(() -> Component.literal((String)("\u00a77Current TPS stats: " + TpsMonitor.getTpsStats())), false);
        return 1;
    }

    private static int executeSystemTest(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (!WebhookTestCommand.checkWebhookConfig(source)) {
            return 0;
        }
        source.sendSuccess(() -> Component.literal((String)"\u00a7eSending test system alert..."), false);
        WebhookUtil.sendSystemAlert(WebhookUtil.AlertType.SYSTEM_ERROR, "Test System Alert", "This is a test system alert to verify webhook functionality.", "Test Field", "Test Value", "Server", "Test Server", "Status", "Testing");
        source.sendSuccess(() -> Component.literal((String)"\u00a7aTest system alert sent! Check your Discord channel."), false);
        return 1;
    }

    private static boolean checkWebhookConfig(CommandSourceStack source) {
        if (!Config.webhookEnabled) {
            source.sendSuccess(() -> Component.literal((String)"\u00a7cWebhook is disabled in the configuration."), false);
            return false;
        }
        if (Config.webhookUrl == null || Config.webhookUrl.trim().isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)"\u00a7cWebhook URL is not configured."), false);
            return false;
        }
        return true;
    }
}

