/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class DatabaseSchema {
    public static void createTables(Connection connection) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.execute("PRAGMA foreign_keys = ON;");
            stmt.execute("    CREATE TABLE IF NOT EXISTS regions (\n        name TEXT PRIMARY KEY NOT NULL,\n        dimension TEXT NOT NULL,\n        sound_event_id TEXT,\n        sound_category TEXT DEFAULT 'ambient',\n        sound_volume REAL DEFAULT 1.0,\n        sound_pitch REAL DEFAULT 1.0,\n        sound_loop_delay_ticks INTEGER DEFAULT 0,\n        entry_message TEXT,\n        exit_message TEXT,\n        entry_actionbar_message TEXT,\n        exit_actionbar_message TEXT,\n        gamemode_on_entry TEXT,\n        gamemode_on_exit TEXT,\n        access_denied_message TEXT\n    );\n");
            stmt.execute("    CREATE INDEX IF NOT EXISTS idx_regions_dimension\n    ON regions(dimension);\n");
            stmt.execute("    CREATE TABLE IF NOT EXISTS region_cuboids (\n        id INTEGER PRIMARY KEY AUTOINCREMENT,\n        region_name TEXT NOT NULL,\n        min_x INTEGER NOT NULL,\n        min_y INTEGER NOT NULL,\n        min_z INTEGER NOT NULL,\n        max_x INTEGER NOT NULL,\n        max_y INTEGER NOT NULL,\n        max_z INTEGER NOT NULL,\n        FOREIGN KEY (region_name) REFERENCES regions(name) ON DELETE CASCADE\n    );\n");
            stmt.execute("    CREATE INDEX IF NOT EXISTS idx_cuboids_region\n    ON region_cuboids(region_name);\n");
            stmt.execute("    CREATE TABLE IF NOT EXISTS region_tags (\n        region_name TEXT NOT NULL,\n        tag TEXT NOT NULL,\n        PRIMARY KEY (region_name, tag),\n        FOREIGN KEY (region_name) REFERENCES regions(name) ON DELETE CASCADE\n    );\n");
            stmt.execute("    CREATE INDEX IF NOT EXISTS idx_tags_tag\n    ON region_tags(tag);\n");
            stmt.execute("    CREATE TABLE IF NOT EXISTS rentals (\n        region_name TEXT PRIMARY KEY NOT NULL,\n        renter_uuid TEXT NOT NULL,\n        renter_name TEXT NOT NULL,\n        expiration_time INTEGER NOT NULL,\n        karma_price INTEGER NOT NULL,\n        rented_at INTEGER NOT NULL,\n        FOREIGN KEY (region_name) REFERENCES regions(name) ON DELETE CASCADE\n    );\n");
            stmt.execute("    CREATE INDEX IF NOT EXISTS idx_rentals_expiration\n    ON rentals(expiration_time);\n");
            stmt.execute("    CREATE INDEX IF NOT EXISTS idx_rentals_renter\n    ON rentals(renter_uuid);\n");
            stmt.execute("    CREATE TABLE IF NOT EXISTS rental_trusted (\n        region_name TEXT NOT NULL,\n        player_name TEXT NOT NULL,\n        PRIMARY KEY (region_name, player_name),\n        FOREIGN KEY (region_name) REFERENCES rentals(region_name) ON DELETE CASCADE\n    );\n");
            stmt.execute("    CREATE INDEX IF NOT EXISTS idx_trusted_region\n    ON rental_trusted(region_name);\n");
            stmt.execute("    CREATE TABLE IF NOT EXISTS markets (\n        name TEXT PRIMARY KEY NOT NULL,\n        floor_price INTEGER NOT NULL,\n        ceiling_price INTEGER NOT NULL,\n        price_exponent REAL DEFAULT 1.5,\n        description TEXT\n    );\n");
            stmt.execute("    CREATE TABLE IF NOT EXISTS market_regions (\n        market_name TEXT NOT NULL,\n        region_name TEXT NOT NULL,\n        PRIMARY KEY (market_name, region_name),\n        FOREIGN KEY (market_name) REFERENCES markets(name) ON DELETE CASCADE,\n        FOREIGN KEY (region_name) REFERENCES regions(name) ON DELETE CASCADE\n    );\n");
            stmt.execute("    CREATE INDEX IF NOT EXISTS idx_market_regions_region\n    ON market_regions(region_name);\n");
            stmt.execute("    CREATE INDEX IF NOT EXISTS idx_market_regions_market\n    ON market_regions(market_name);\n");
        }
    }

    public static void dropAllTables(Connection connection) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.execute("DROP TABLE IF EXISTS rental_trusted;");
            stmt.execute("DROP TABLE IF EXISTS rentals;");
            stmt.execute("DROP TABLE IF EXISTS market_regions;");
            stmt.execute("DROP TABLE IF EXISTS markets;");
            stmt.execute("DROP TABLE IF EXISTS region_tags;");
            stmt.execute("DROP TABLE IF EXISTS region_cuboids;");
            stmt.execute("DROP TABLE IF EXISTS regions;");
        }
    }
}

