/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.database;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.Map;
import net.neoforged.fml.loading.FMLPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.database.DatabaseManager;
import world.landfall.landfallessentials.database.RegionDAO;
import world.landfall.landfallessentials.database.RentalDAO;
import world.landfall.landfallessentials.regions.Region;
import world.landfall.landfallessentials.regions.RegionRental;

public class JsonToSqliteMigrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonToSqliteMigrator.class);
    private static final File REGIONS_JSON = new File(String.valueOf(FMLPaths.CONFIGDIR.get().toFile()) + "/landfallessentials/regions.json");
    private static final File RENTALS_JSON = new File("config/landfall_rentals.json");
    private static final File REGIONS_BACKUP = new File(String.valueOf(FMLPaths.CONFIGDIR.get().toFile()) + "/landfallessentials/regions.json.backup");
    private static final File RENTALS_BACKUP = new File("config/landfall_rentals.json.backup");
    private static final File MIGRATION_MARKER = new File(String.valueOf(FMLPaths.CONFIGDIR.get().toFile()) + "/landfallessentials/.migrated_to_sqlite");
    private static final Gson GSON = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setPrettyPrinting().create();

    public static boolean migrateIfNeeded() {
        boolean hasRentalsJson;
        if (MIGRATION_MARKER.exists()) {
            LOGGER.debug("Migration marker found, skipping JSON to SQLite migration");
            return false;
        }
        boolean hasRegionsJson = REGIONS_JSON.exists() && REGIONS_JSON.length() > 0L;
        boolean bl = hasRentalsJson = RENTALS_JSON.exists() && RENTALS_JSON.length() > 0L;
        if (!hasRegionsJson && !hasRentalsJson) {
            LOGGER.info("No JSON files found to migrate, marking migration as complete");
            JsonToSqliteMigrator.createMigrationMarker();
            return false;
        }
        try {
            if (!JsonToSqliteMigrator.isDatabaseEmpty()) {
                LOGGER.warn("Database is not empty, skipping migration to avoid data loss");
                LOGGER.warn("If you want to force migration, delete the database file at: {}", (Object)DatabaseManager.getDatabasePath());
                JsonToSqliteMigrator.createMigrationMarker();
                return false;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Failed to check if database is empty", (Throwable)e);
            return false;
        }
        LOGGER.info("Starting JSON to SQLite migration...");
        long startTime = System.currentTimeMillis();
        try {
            int regionCount = 0;
            int rentalCount = 0;
            if (hasRegionsJson) {
                regionCount = JsonToSqliteMigrator.migrateRegions();
                LOGGER.info("Migrated {} regions from JSON to SQLite", (Object)regionCount);
            }
            if (hasRentalsJson) {
                rentalCount = JsonToSqliteMigrator.migrateRentals();
                LOGGER.info("Migrated {} rentals from JSON to SQLite", (Object)rentalCount);
            }
            JsonToSqliteMigrator.backupJsonFiles();
            JsonToSqliteMigrator.createMigrationMarker();
            long duration = System.currentTimeMillis() - startTime;
            LOGGER.info("Migration completed successfully in {}ms ({} regions, {} rentals)", new Object[]{duration, regionCount, rentalCount});
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Migration failed! Original JSON files are preserved.", (Throwable)e);
            return false;
        }
    }

    private static int migrateRegions() throws IOException, SQLException {
        LOGGER.info("Migrating regions from: {}", (Object)REGIONS_JSON.getAbsolutePath());
        try (FileReader reader = new FileReader(REGIONS_JSON);){
            Type type = new TypeToken<Map<String, Region>>(){}.getType();
            Map regions = (Map)GSON.fromJson((Reader)reader, type);
            if (regions == null || regions.isEmpty()) {
                LOGGER.warn("No regions found in JSON file");
                int n = 0;
                return n;
            }
            RegionDAO.saveRegions(regions.values());
            int n = regions.size();
            return n;
        }
    }

    private static int migrateRentals() throws IOException, SQLException {
        LOGGER.info("Migrating rentals from: {}", (Object)RENTALS_JSON.getAbsolutePath());
        Gson rentalGson = new GsonBuilder().setPrettyPrinting().create();
        try (FileReader reader = new FileReader(RENTALS_JSON);){
            Type type = new TypeToken<Map<String, RegionRental.RentalInfo>>(){}.getType();
            Map rentals = (Map)rentalGson.fromJson((Reader)reader, type);
            if (rentals == null || rentals.isEmpty()) {
                LOGGER.warn("No rentals found in JSON file");
                int n = 0;
                return n;
            }
            RentalDAO.saveRentals(rentals.values());
            int n = rentals.size();
            return n;
        }
    }

    private static void backupJsonFiles() {
        if (REGIONS_JSON.exists()) {
            if (REGIONS_JSON.renameTo(REGIONS_BACKUP)) {
                LOGGER.info("Backed up regions JSON to: {}", (Object)REGIONS_BACKUP.getAbsolutePath());
            } else {
                LOGGER.warn("Failed to backup regions JSON file");
            }
        }
        if (RENTALS_JSON.exists()) {
            if (RENTALS_JSON.renameTo(RENTALS_BACKUP)) {
                LOGGER.info("Backed up rentals JSON to: {}", (Object)RENTALS_BACKUP.getAbsolutePath());
            } else {
                LOGGER.warn("Failed to backup rentals JSON file");
            }
        }
    }

    private static void createMigrationMarker() {
        try {
            MIGRATION_MARKER.getParentFile().mkdirs();
            if (MIGRATION_MARKER.createNewFile()) {
                LOGGER.info("Created migration marker file");
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to create migration marker file", (Throwable)e);
        }
    }

    private static boolean isDatabaseEmpty() throws SQLException {
        Map<String, Region> regions = RegionDAO.loadAllRegions();
        Map<String, RegionRental.RentalInfo> rentals = RentalDAO.loadAllRentals();
        return regions.isEmpty() && rentals.isEmpty();
    }

    public static void resetMigrationMarker() {
        if (MIGRATION_MARKER.exists()) {
            if (MIGRATION_MARKER.delete()) {
                LOGGER.info("Migration marker deleted, migration will run on next startup");
            } else {
                LOGGER.error("Failed to delete migration marker");
            }
        }
    }

    public static boolean isMigrationComplete() {
        return MIGRATION_MARKER.exists();
    }

    public static File getRegionsJsonFile() {
        return REGIONS_JSON;
    }

    public static File getRentalsJsonFile() {
        return RENTALS_JSON;
    }
}

