/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.event;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.Config;
import world.landfall.landfallessentials.entity.ConduitItemEntity;
import world.landfall.landfallessentials.item.custom.ConduitItem;
import world.landfall.landfallessentials.util.WebhookUtil;

@EventBusSubscriber(modid="landfallessentials")
public class ConduitProtectionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConduitProtectionHandler.class);

    @SubscribeEvent
    public static void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
        try {
            Item item;
            if (event.getLevel() == null || event.getLevel().isClientSide()) {
                return;
            }
            if (event.getEntity() == null) {
                LOGGER.warn("EntityLeaveLevelEvent received with null entity");
                return;
            }
            Entity entity = event.getEntity();
            if (!(entity instanceof ConduitItemEntity)) {
                return;
            }
            ConduitItemEntity conduitEntity = (ConduitItemEntity)entity;
            Level level = event.getLevel();
            if (!(level instanceof ServerLevel)) {
                LOGGER.warn("ConduitProtectionHandler called on non-server level");
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack stack = conduitEntity.getItem();
            if (stack == null || stack.isEmpty() || !((item = stack.getItem()) instanceof ConduitItem)) {
                LOGGER.debug("Conduit entity leaving level but item is not a valid conduit");
                return;
            }
            ConduitItem conduitItem = (ConduitItem)item;
            if (conduitEntity.isRemoved() && !conduitEntity.hasDestructionAlertBeenSent()) {
                double z;
                String conduitName = ConduitProtectionHandler.sanitizeString(stack.getDisplayName().getString(), "Unknown Conduit");
                String conduitType = ConduitProtectionHandler.sanitizeString(conduitItem.getConduitType().name(), "UNKNOWN");
                String dimensionName = ConduitProtectionHandler.sanitizeString(serverLevel.dimension().location().toString(), "unknown_dimension");
                String reason = "entity left level (safety net)";
                double x = Double.isFinite(conduitEntity.getX()) ? conduitEntity.getX() : 0.0;
                double y = Double.isFinite(conduitEntity.getY()) ? conduitEntity.getY() : 0.0;
                double d = z = Double.isFinite(conduitEntity.getZ()) ? conduitEntity.getZ() : 0.0;
                if (Config.alertConduitDestruction) {
                    WebhookUtil.sendConduitDestructionAlert(conduitName, conduitType, x, y, z, dimensionName, reason);
                }
                LOGGER.warn("CONDUIT DESTROYED: {} ({}) at [{}, {}, {}] in dimension {} - Reason: {}", new Object[]{conduitName, conduitType, x, y, z, dimensionName, reason});
            }
        }
        catch (Exception e) {
            LOGGER.error("Critical error in ConduitProtectionHandler", (Throwable)e);
        }
    }

    private static String sanitizeString(String input, String defaultValue) {
        if (input == null || input.trim().isEmpty()) {
            return defaultValue;
        }
        Object sanitized = input.trim();
        if (((String)sanitized).length() > 256) {
            sanitized = ((String)sanitized).substring(0, 256) + "...";
        }
        sanitized = ((String)sanitized).replaceAll("[\\r\\n\\t]", " ");
        sanitized = ((String)sanitized).replaceAll("\\p{Cntrl}", "");
        return sanitized;
    }
}

