/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.fluid;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.content.fluids.VirtualFluid;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.util.entry.FluidEntry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import world.landfall.landfallessentials.Landfallessentials;

public class AllFluids {
    public static final FluidEntry<VirtualFluid> SWEET_BERRY_WINE = ((FluidBuilder)Landfallessentials.REGISTRATE.virtualFluid("sweet_berry_wine").lang("Sweet Berry Wine").bucket().build()).register();
    public static final FluidEntry<VirtualFluid> HEAVY_OIL = ((FluidBuilder)Landfallessentials.REGISTRATE.virtualFluid("heavy_oil").lang("Heavy Oil").bucket().build()).register();
    public static final FluidEntry<VirtualFluid> KEROSENE = ((FluidBuilder)Landfallessentials.REGISTRATE.virtualFluid("kerosene").lang("Kerosene").bucket().build()).register();
    public static final FluidEntry<VirtualFluid> SEED_OIL = ((FluidBuilder)Landfallessentials.REGISTRATE.virtualFluid("seed_oil").lang("Seed Oil").bucket().build()).register();
    public static final FluidEntry<VirtualFluid> ETHANOL = ((FluidBuilder)Landfallessentials.REGISTRATE.virtualFluid("ethanol").lang("Ethanol").bucket().build()).register();
    public static final FluidEntry<VirtualFluid> NAPHTHA = ((FluidBuilder)Landfallessentials.REGISTRATE.virtualFluid("naphtha").lang("Naphtha").bucket().build()).register();
    public static final FluidEntry<VirtualFluid> MALT_BREW = ((FluidBuilder)Landfallessentials.REGISTRATE.virtualFluid("malt_brew").lang("Malt Brew").bucket().build()).register();
    public static final FluidEntry<BaseFlowingFluid.Flowing> CRUDE_OIL = ((FluidBuilder)((FluidBuilder)Landfallessentials.REGISTRATE.standardFluid("crude_oil", SolidRenderedPlaceableFluidType.create(15582339, () -> Float.valueOf(0.125f))).lang("Crude Oil").properties(b -> b.density(900).viscosity(900).temperature(300).canConvertToSource(false).canSwim(true).supportsBoating(false)).fluidProperties(p -> p.levelDecreasePerBlock(2).slopeFindDistance(3).explosionResistance(100.0f)).source(BaseFlowingFluid.Source::new).block().lang("Crude Oil").properties(p -> p.mapColor(MapColor.TERRACOTTA_BLACK)).build()).bucket().lang("Crude Bucket").tag(new TagKey[]{Tags.Items.BUCKETS}).build()).register();

    public static void register() {
    }

    private static class SolidRenderedPlaceableFluidType
    extends TintedFluidType {
        private Vector3f fogColor;
        private Supplier<Float> fogDistance;

        public static FluidBuilder.FluidTypeFactory create(int fogColor, Supplier<Float> fogDistance) {
            return (p, s, f) -> {
                SolidRenderedPlaceableFluidType fluidType = new SolidRenderedPlaceableFluidType(p, s, f);
                float r = (float)(fogColor >> 16 & 0xFF) / 255.0f;
                float g = (float)(fogColor >> 8 & 0xFF) / 255.0f;
                float b = (float)(fogColor & 0xFF) / 255.0f;
                fluidType.fogColor = new Vector3f(r, g, b);
                fluidType.fogDistance = fogDistance;
                return fluidType;
            };
        }

        private SolidRenderedPlaceableFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture);
        }

        @Override
        protected int getTintColor(FluidStack stack) {
            return -1;
        }

        @Override
        public int getTintColor(FluidState state, BlockAndTintGetter world, BlockPos pos) {
            return 0xFFFFFF;
        }

        @Override
        protected Vector3f getCustomFogColor() {
            return this.fogColor;
        }

        @Override
        protected float getFogDistanceModifier() {
            return this.fogDistance.get().floatValue();
        }
    }

    public static abstract class TintedFluidType
    extends FluidType {
        protected static final int NO_TINT = -1;
        private ResourceLocation stillTexture;
        private ResourceLocation flowingTexture;

        public TintedFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties);
            this.stillTexture = stillTexture;
            this.flowingTexture = flowingTexture;
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return stillTexture;
                }

                public ResourceLocation getFlowingTexture() {
                    return flowingTexture;
                }

                public int getTintColor(FluidStack stack) {
                    return this.getTintColor(stack);
                }

                public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                    return this.getTintColor(state, getter, pos);
                }

                @NotNull
                public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                    Vector3f customFogColor = this.getCustomFogColor();
                    return customFogColor == null ? fluidFogColor : customFogColor;
                }

                public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                    float modifier = this.getFogDistanceModifier();
                    float baseWaterFog = 96.0f;
                    if (modifier != 1.0f) {
                        RenderSystem.setShaderFogShape((FogShape)FogShape.CYLINDER);
                        RenderSystem.setShaderFogStart((float)-8.0f);
                        RenderSystem.setShaderFogEnd((float)(baseWaterFog * modifier));
                    }
                }
            });
        }

        protected abstract int getTintColor(FluidStack var1);

        protected abstract int getTintColor(FluidState var1, BlockAndTintGetter var2, BlockPos var3);

        protected Vector3f getCustomFogColor() {
            return null;
        }

        protected float getFogDistanceModifier() {
            return 1.0f;
        }
    }
}

