/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.home;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Home {
    private static final Logger LOGGER = LoggerFactory.getLogger(Home.class);
    private final String name;
    private final double x;
    private final double y;
    private final double z;
    private final float yaw;
    private final float pitch;
    private final ResourceKey<Level> dimension;
    private final long createdTime;
    private final BlockPos bedPosition;
    private boolean disabled;

    public Home(String name, double x, double y, double z, float yaw, float pitch, ResourceKey<Level> dimension) {
        this(name, x, y, z, yaw, pitch, dimension, System.currentTimeMillis(), null, false);
    }

    public Home(String name, double x, double y, double z, float yaw, float pitch, ResourceKey<Level> dimension, BlockPos bedPosition) {
        this(name, x, y, z, yaw, pitch, dimension, System.currentTimeMillis(), bedPosition, false);
    }

    public Home(String name, double x, double y, double z, float yaw, float pitch, ResourceKey<Level> dimension, long createdTime, BlockPos bedPosition, boolean disabled) {
        this.name = name;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        this.dimension = dimension;
        this.createdTime = createdTime;
        this.bedPosition = bedPosition;
        this.disabled = disabled;
    }

    public static Home fromNBT(CompoundTag tag, HolderLookup.Provider registries) {
        try {
            String name = tag.getString("Name");
            double x = tag.getDouble("X");
            double y = tag.getDouble("Y");
            double z = tag.getDouble("Z");
            float yaw = tag.getFloat("Yaw");
            float pitch = tag.getFloat("Pitch");
            long createdTime = tag.getLong("CreatedTime");
            boolean disabled = tag.getBoolean("Disabled");
            String dimensionString = tag.getString("Dimension");
            ResourceLocation dimensionLocation = ResourceLocation.tryParse((String)dimensionString);
            if (dimensionLocation == null) {
                LOGGER.warn("Invalid dimension in home data: {}", (Object)dimensionString);
                return null;
            }
            ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimensionLocation);
            BlockPos bedPosition = null;
            if (tag.contains("BedX") && tag.contains("BedY") && tag.contains("BedZ")) {
                bedPosition = new BlockPos(tag.getInt("BedX"), tag.getInt("BedY"), tag.getInt("BedZ"));
            }
            return new Home(name, x, y, z, yaw, pitch, (ResourceKey<Level>)dimension, createdTime, bedPosition, disabled);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load home from NBT", (Throwable)e);
            return null;
        }
    }

    public CompoundTag toNBT(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        tag.putString("Name", this.name);
        tag.putDouble("X", this.x);
        tag.putDouble("Y", this.y);
        tag.putDouble("Z", this.z);
        tag.putFloat("Yaw", this.yaw);
        tag.putFloat("Pitch", this.pitch);
        tag.putString("Dimension", this.dimension.location().toString());
        tag.putLong("CreatedTime", this.createdTime);
        tag.putBoolean("Disabled", this.disabled);
        if (this.bedPosition != null) {
            tag.putInt("BedX", this.bedPosition.getX());
            tag.putInt("BedY", this.bedPosition.getY());
            tag.putInt("BedZ", this.bedPosition.getZ());
        }
        return tag;
    }

    public String getName() {
        return this.name;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public BlockPos getBedPosition() {
        return this.bedPosition;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isBedBased() {
        return this.bedPosition != null;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public String getLocationString() {
        return String.format("%.1f, %.1f, %.1f in %s", this.x, this.y, this.z, this.dimension.location().toString());
    }

    public String getDimensionDisplayName() {
        String dimensionPath;
        switch (dimensionPath = this.dimension.location().getPath()) {
            case "overworld": {
                return "Overworld";
            }
            case "the_nether": {
                return "Nether";
            }
            case "the_end": {
                return "End";
            }
        }
        return dimensionPath;
    }

    public String toString() {
        return String.format("Home{name='%s', location=%s, disabled=%s}", this.name, this.getLocationString(), this.disabled);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Home home = (Home)obj;
        return Double.compare(home.x, this.x) == 0 && Double.compare(home.y, this.y) == 0 && Double.compare(home.z, this.z) == 0 && Float.compare(home.yaw, this.yaw) == 0 && Float.compare(home.pitch, this.pitch) == 0 && this.name.equals(home.name) && this.dimension.equals(home.dimension);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

