/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.karma;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import world.landfall.landfallessentials.karma.BlueMapIntegration;

@EventBusSubscriber
public class BlueMapCommands {
    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"map").then(Commands.literal((String)"toggle").executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            return BlueMapCommands.togglePlayerVisibility(player);
        }))).then(Commands.literal((String)"show").executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            return BlueMapCommands.setPlayerVisibility(player, true);
        }))).then(Commands.literal((String)"hide").executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            return BlueMapCommands.setPlayerVisibility(player, false);
        }))).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            return BlueMapCommands.showMapStatus(player);
        }));
    }

    private static int showMapStatus(ServerPlayer player) {
        if (!BlueMapIntegration.isAvailable()) {
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7cBlueMap is not available on this server."));
            return 0;
        }
        boolean isVisible = BlueMapIntegration.isPlayerVisible(player);
        String status = isVisible ? "\u00a7avisible" : "\u00a7chidden";
        player.sendSystemMessage((Component)Component.literal((String)("\u00a7eYou are currently " + status + " \u00a7eon the map.")));
        player.sendSystemMessage((Component)Component.literal((String)"\u00a77Use \u00a7e/map show\u00a77, \u00a7e/map hide\u00a77, or \u00a7e/map toggle\u00a77 to change visibility."));
        return 1;
    }

    private static int togglePlayerVisibility(ServerPlayer player) {
        boolean newVisibility;
        if (!BlueMapIntegration.isAvailable()) {
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7cBlueMap is not available on this server."));
            return 0;
        }
        boolean currentVisibility = BlueMapIntegration.isPlayerVisible(player);
        boolean bl = newVisibility = !currentVisibility;
        if (BlueMapIntegration.setPlayerVisibility(player, newVisibility)) {
            String status = newVisibility ? "\u00a7avisible" : "\u00a7chidden";
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7eYou are now " + status + " \u00a7eon the map.")));
            return 1;
        }
        player.sendSystemMessage((Component)Component.literal((String)"\u00a7cFailed to change map visibility."));
        return 0;
    }

    private static int setPlayerVisibility(ServerPlayer player, boolean visible) {
        if (!BlueMapIntegration.isAvailable()) {
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7cBlueMap is not available on this server."));
            return 0;
        }
        if (BlueMapIntegration.setPlayerVisibility(player, visible)) {
            String status = visible ? "\u00a7avisible" : "\u00a7chidden";
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7eYou are now " + status + " \u00a7eon the map.")));
            return 1;
        }
        player.sendSystemMessage((Component)Component.literal((String)"\u00a7cFailed to change map visibility."));
        return 0;
    }
}

