/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.karma;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import world.landfall.landfallessentials.Config;
import world.landfall.landfallessentials.api.karma.IKarmaAPI;
import world.landfall.landfallessentials.api.karma.KarmaAPI;
import world.landfall.landfallessentials.entity.ConduitItemEntity;
import world.landfall.landfallessentials.item.custom.ConduitItem;
import world.landfall.landfallessentials.karma.BlueMapIntegration;
import world.landfall.landfallessentials.karma.KarmaData;
import world.landfall.landfallessentials.karma.LuckPermsIntegration;
import world.landfall.landfallessentials.karma.PlayerSnapshotData;

@EventBusSubscriber
public class KarmaSystem {
    private static final Logger LOGGER = LoggerFactory.getLogger(KarmaSystem.class);
    public static final int INCREMENT_INTERVAL = 1200;
    public static final int GROUP_ACTIVITY_RADIUS = 50;
    private static final long AFK_THRESHOLD_MS = 300000L;
    private static boolean initialized = false;
    private static final Map<UUID, Boolean> isCurrentlyShowingAfkMessage = new ConcurrentHashMap<UUID, Boolean>();
    private static final Map<UUID, PlayerPosition> lastPlayerPositions = new ConcurrentHashMap<UUID, PlayerPosition>();
    private static final Map<UUID, Long> lastMovementTimes = new ConcurrentHashMap<UUID, Long>();
    private static final Map<UUID, PlayerSnapshot> protectedPlayerSnapshots = new ConcurrentHashMap<UUID, PlayerSnapshot>();
    private static final IKarmaAPI api = KarmaAPI.getInstance();

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        if (FMLEnvironment.dist.isClient()) {
            return;
        }
        KarmaSystem.initialize();
    }

    public static void initialize() {
        if (initialized) {
            LOGGER.debug("KarmaSystem already initialized.");
            return;
        }
        if (FMLEnvironment.dist.isClient()) {
            LOGGER.warn("KarmaSystem.initialize() called on client. Skipping.");
            return;
        }
        LOGGER.debug("Initializing KarmaSystem (triggered by ServerStartedEvent)...");
        BlueMapIntegration.initialize();
        LuckPermsIntegration.initialize();
        initialized = true;
        LOGGER.debug("KarmaSystem initialized successfully.");
    }

    private static KarmaData getKarmaData(Player player) {
        if (FMLEnvironment.dist.isClient()) {
            return null;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ServerLevel overworldLevel = serverPlayer.getServer().overworld();
            return KarmaData.get(overworldLevel);
        }
        return null;
    }

    @Deprecated
    public static int getKarma(Player player) {
        return api.getKarma(player);
    }

    @Deprecated
    public static double getTotalKarma(Player player) {
        return api.getTotalKarma(player);
    }

    @Deprecated
    public static int getKarma(UUID playerUUID, MinecraftServer server) {
        return api.getKarma(playerUUID, server);
    }

    @Deprecated
    public static void setKarma(Player player, int amount) {
        api.setKarma(player, amount, "KarmaSystem.setKarma");
    }

    @Deprecated
    public static void addKarma(Player player, int amount) {
        api.addKarma(player, amount, "KarmaSystem.addKarma");
    }

    @Deprecated
    public static void removeKarma(Player player, int amount) {
        api.removeKarma(player, amount, "KarmaSystem.removeKarma");
    }

    @Deprecated
    public static String getDonorLevel(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return api.getDonorLevel(serverPlayer);
        }
        return "";
    }

    @Deprecated
    public static double getDonorBonus(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return api.getDonorBonus(serverPlayer);
        }
        return 0.0;
    }

    @Deprecated
    public static int calculateGroupBonus(ServerPlayer player, int radius) {
        return api.calculateGroupBonus(player, radius);
    }

    public static boolean isPlayerVisible(ServerPlayer player) {
        if (FMLEnvironment.dist.isClient()) {
            return false;
        }
        if (!initialized) {
            return true;
        }
        return BlueMapIntegration.isPlayerVisible(player);
    }

    public static double calculateTotalBonus(ServerPlayer player) {
        if (FMLEnvironment.dist.isClient()) {
            return 1.0;
        }
        int nearbyPlayers = KarmaSystem.calculateGroupBonus(player, 50);
        double donorBonus = KarmaSystem.getDonorBonus((Player)player);
        double groupBonus = nearbyPlayers;
        return 1.0 + groupBonus + donorBonus;
    }

    public static void processKarmaIncrement(ServerPlayer player) {
        if (FMLEnvironment.dist.isClient()) {
            return;
        }
        double totalBonus = KarmaSystem.calculateTotalBonus(player);
        api.addFractionalKarma(player.getUUID(), totalBonus, player.getServer(), "passive-generation");
    }

    private static boolean isPlayerAFK(ServerPlayer player) {
        PlayerPosition lastPos;
        UUID playerId = player.getUUID();
        long currentTime = System.currentTimeMillis();
        PlayerPosition currentPos = new PlayerPosition(player.getX(), player.getY(), player.getZ(), player.getYRot(), player.getXRot());
        if (currentPos.hasMovedFrom(lastPos = lastPlayerPositions.get(playerId), 0.1)) {
            lastPlayerPositions.put(playerId, currentPos);
            lastMovementTimes.put(playerId, currentTime);
            return false;
        }
        Long lastMovement = lastMovementTimes.get(playerId);
        if (lastMovement == null) {
            lastMovementTimes.put(playerId, currentTime);
            lastPlayerPositions.put(playerId, currentPos);
            return false;
        }
        return currentTime - lastMovement > 300000L;
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Pre event) {
        if (FMLEnvironment.dist.isClient() || !initialized) {
            return;
        }
        MinecraftServer server = event.getServer();
        List players = server.getPlayerList().getPlayers();
        for (ServerPlayer player : players) {
            UUID playerId = player.getUUID();
            boolean shouldBeAfk = KarmaSystem.isPlayerAFK(player);
            if (shouldBeAfk) {
                player.displayClientMessage((Component)Component.literal((String)"\u00a7cYou are currently AFK."), true);
                isCurrentlyShowingAfkMessage.put(playerId, true);
                continue;
            }
            if (!isCurrentlyShowingAfkMessage.getOrDefault(playerId, false).booleanValue()) continue;
            player.displayClientMessage((Component)Component.empty(), true);
            isCurrentlyShowingAfkMessage.put(playerId, false);
        }
        if (server.getTickCount() % 1200 == 0) {
            for (ServerPlayer player : players) {
                if (KarmaSystem.isPlayerAFK(player)) continue;
                KarmaSystem.processKarmaIncrement(player);
            }
        }
    }

    @Deprecated
    public static boolean hasEnoughKarma(Player player, int cost) {
        return api.hasKarma(player, cost);
    }

    @Deprecated
    public static boolean spendKarma(Player player, int cost) {
        return api.spendKarma(player, cost, "KarmaSystem.spendKarma");
    }

    public static String getBlueMapStatus() {
        if (FMLEnvironment.dist.isClient()) {
            return "Client side";
        }
        if (!initialized) {
            return "Not initialized";
        }
        return BlueMapIntegration.getStatus();
    }

    public static String getLuckPermsStatus() {
        if (FMLEnvironment.dist.isClient()) {
            return "Client side";
        }
        if (!initialized) {
            return "Not initialized";
        }
        return LuckPermsIntegration.getStatus();
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        int currentKarma;
        if (FMLEnvironment.dist.isClient() || !initialized) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        UUID playerUUID = player.getUUID();
        int playerKarma = KarmaSystem.getKarma((Player)player);
        boolean inventoryProtected = false;
        if (Config.keepInventoryKarmaThreshold > 0 && playerKarma >= Config.keepInventoryKarmaThreshold) {
            LOGGER.info("Player {} has {} karma, above threshold of {}. Creating snapshot.", new Object[]{player.getName().getString(), playerKarma, Config.keepInventoryKarmaThreshold});
            KarmaSystem.extractAndDropConduits(player);
            PlayerSnapshot snapshot = new PlayerSnapshot(player);
            protectedPlayerSnapshots.put(playerUUID, snapshot);
            ServerLevel overworldLevel = player.getServer().overworld();
            PlayerSnapshotData snapshotData = PlayerSnapshotData.get(overworldLevel);
            snapshotData.setSnapshot(playerUUID, snapshot.toPersistent((HolderLookup.Provider)overworldLevel.registryAccess()));
            api.removeKarma((Player)player, Config.keepInventoryKarmaThreshold, "inventory-protection");
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7aYour karma protected your inventory! \u00a77(-" + Config.keepInventoryKarmaThreshold + " karma)")));
            player.getInventory().clearContent();
            if (ModList.get().isLoaded("curios")) {
                KarmaSystem.clearCuriosInventory(player);
            }
            LOGGER.info("Cleared inventory (and Curios if present) for player {} after snapshotting for karma protection.", (Object)player.getName().getString());
            inventoryProtected = true;
        } else if (Config.keepInventoryKarmaThreshold > 0) {
            LOGGER.debug("Player {} has {} karma, below threshold of {}. No snapshot created.", new Object[]{player.getName().getString(), playerKarma, Config.keepInventoryKarmaThreshold});
            protectedPlayerSnapshots.remove(playerUUID);
            ServerLevel overworldLevel = player.getServer().overworld();
            PlayerSnapshotData snapshotData = PlayerSnapshotData.get(overworldLevel);
            snapshotData.removeSnapshot(playerUUID);
            if (playerKarma > 0) {
                player.sendSystemMessage((Component)Component.literal((String)("\u00a7cYou need " + Config.keepInventoryKarmaThreshold + " karma to keep your inventory. You only have " + playerKarma + ".")));
            }
        }
        if (Config.deathKarmaLossPercentage > 0.0 && (currentKarma = KarmaSystem.getKarma((Player)player)) > 0) {
            int karmaLoss = (int)Math.ceil((double)currentKarma * Config.deathKarmaLossPercentage);
            api.removeKarma((Player)player, karmaLoss, "death-penalty");
            String message = inventoryProtected ? "\u00a77You also lost \u00a7c" + karmaLoss + " karma \u00a77from death (" + (int)(Config.deathKarmaLossPercentage * 100.0) + "% penalty)" : "\u00a7cYou lost " + karmaLoss + " karma from death (" + (int)(Config.deathKarmaLossPercentage * 100.0) + "% penalty)";
            player.sendSystemMessage((Component)Component.literal((String)message));
            LOGGER.debug("Player {} lost {} karma from death penalty ({}%)", new Object[]{player.getName().getString(), karmaLoss, (int)(Config.deathKarmaLossPercentage * 100.0)});
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        if (FMLEnvironment.dist.isClient() || !initialized) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        if (Config.keepInventoryKarmaThreshold <= 0) {
            return;
        }
        UUID playerUUID = player.getUUID();
        if (protectedPlayerSnapshots.containsKey(playerUUID)) {
            LOGGER.debug("Preventing drops for player {} due to karma protection snapshot.", (Object)player.getName().getString());
            event.setCanceled(true);
        }
    }

    private static void extractAndDropConduits(ServerPlayer player) {
        ArrayList<ItemStack> conduitsToRemove = new ArrayList<ItemStack>();
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty() || !(stack.getItem() instanceof ConduitItem)) continue;
            conduitsToRemove.add(stack.copy());
            player.getInventory().setItem(i, ItemStack.EMPTY);
            LOGGER.debug("Extracted conduit {} from player {} inventory for forced drop.", (Object)stack.getDisplayName().getString(), (Object)player.getName().getString());
        }
        if (ModList.get().isLoaded("curios")) {
            KarmaSystem.extractConduitsFromCurios(player, conduitsToRemove);
        }
        for (ItemStack conduitStack : conduitsToRemove) {
            ConduitItemEntity itemEntity = new ConduitItemEntity(player.level(), player.getX(), player.getY(), player.getZ(), conduitStack);
            itemEntity.setDefaultPickUpDelay();
            player.level().addFreshEntity((Entity)itemEntity);
            LOGGER.debug("Dropped conduit {} at player {} death location.", (Object)conduitStack.getDisplayName().getString(), (Object)player.getName().getString());
        }
        if (!conduitsToRemove.isEmpty()) {
            player.sendSystemMessage((Component)Component.literal((String)"\u00a76Your conduits have been dropped and cannot be protected by karma."));
        }
    }

    private static void extractConduitsFromCurios(ServerPlayer player, List<ItemStack> conduitsToRemove) {
        try {
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(curiosInventory -> curiosInventory.getCurios().forEach((slotId, stacksHandler) -> {
                for (int i = 0; i < stacksHandler.getStacks().getSlots(); ++i) {
                    ItemStack stack = stacksHandler.getStacks().getStackInSlot(i);
                    if (stack.isEmpty() || !(stack.getItem() instanceof ConduitItem)) continue;
                    conduitsToRemove.add(stack.copy());
                    stacksHandler.getStacks().setStackInSlot(i, ItemStack.EMPTY);
                    LOGGER.debug("Extracted conduit {} from player {} Curios slot '{}' for forced drop.", new Object[]{stack.getDisplayName().getString(), player.getName().getString(), slotId});
                }
            }));
        }
        catch (Exception e) {
            LOGGER.error("Failed to extract conduits from Curios slots for player {}: {}", (Object)player.getName().getString(), (Object)e.getMessage());
        }
    }

    private static void clearCuriosInventory(ServerPlayer player) {
        try {
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(curiosInventory -> curiosInventory.getCurios().forEach((slotId, stacksHandler) -> {
                for (int i = 0; i < stacksHandler.getStacks().getSlots(); ++i) {
                    stacksHandler.getStacks().setStackInSlot(i, ItemStack.EMPTY);
                }
                LOGGER.debug("Cleared {} slots in Curios slot type '{}' for player {}", new Object[]{stacksHandler.getStacks().getSlots(), slotId, player.getName().getString()});
            }));
        }
        catch (Exception e) {
            LOGGER.error("Failed to clear Curios inventory for player {}: {}", (Object)player.getName().getString(), (Object)e.getMessage());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (FMLEnvironment.dist.isClient() || !initialized || Config.keepInventoryKarmaThreshold <= 0) {
            return;
        }
        if (!event.isWasDeath()) {
            return;
        }
        ServerPlayer newPlayer = (ServerPlayer)event.getEntity();
        UUID playerUUID = newPlayer.getUUID();
        PlayerSnapshot snapshot = protectedPlayerSnapshots.remove(playerUUID);
        if (snapshot == null) {
            ServerLevel overworldLevel = newPlayer.getServer().overworld();
            PlayerSnapshotData snapshotData = PlayerSnapshotData.get(overworldLevel);
            PlayerSnapshotData.SnapshotEntry entry = snapshotData.getSnapshot(playerUUID);
            if (entry != null) {
                LOGGER.info("Restoring snapshot for player {} from persistent storage (logged out before respawn)", (Object)newPlayer.getName().getString());
                snapshot = PlayerSnapshot.fromPersistent(entry, (HolderLookup.Provider)overworldLevel.registryAccess());
                snapshotData.removeSnapshot(playerUUID);
            }
        } else {
            ServerLevel overworldLevel = newPlayer.getServer().overworld();
            PlayerSnapshotData snapshotData = PlayerSnapshotData.get(overworldLevel);
            snapshotData.removeSnapshot(playerUUID);
        }
        if (snapshot != null) {
            LOGGER.info("Restoring snapshot for player {}", (Object)newPlayer.getName().getString());
            snapshot.restore(newPlayer);
        } else {
            LOGGER.debug("No snapshot found to restore for player {}. Vanilla death behavior applies.", (Object)newPlayer.getName().getString());
        }
    }

    public static void cleanupPlayerData(UUID playerUUID) {
        if (playerUUID == null) {
            return;
        }
        lastPlayerPositions.remove(playerUUID);
        lastMovementTimes.remove(playerUUID);
        isCurrentlyShowingAfkMessage.remove(playerUUID);
        protectedPlayerSnapshots.remove(playerUUID);
        if (api instanceof KarmaAPI) {
            ((KarmaAPI)api).cleanupPlayer(playerUUID);
        }
        LOGGER.debug("Cleaned up karma system data for player UUID: {}", (Object)playerUUID);
    }

    private static class PlayerPosition {
        final double x;
        final double y;
        final double z;
        final float yaw;
        final float pitch;

        PlayerPosition(double x, double y, double z, float yaw, float pitch) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.yaw = yaw;
            this.pitch = pitch;
        }

        boolean hasMovedFrom(PlayerPosition other, double threshold) {
            if (other == null) {
                return true;
            }
            double deltaX = Math.abs(this.x - other.x);
            double deltaY = Math.abs(this.y - other.y);
            double deltaZ = Math.abs(this.z - other.z);
            double deltaYaw = Math.abs(this.yaw - other.yaw);
            double deltaPitch = Math.abs(this.pitch - other.pitch);
            return deltaX > threshold || deltaY > threshold || deltaZ > threshold || deltaYaw > 1.0 || deltaPitch > 1.0;
        }
    }

    private static class PlayerSnapshot {
        final List<ItemStack> allItems = new ArrayList<ItemStack>();
        final Map<String, List<ItemStack>> curiosItems = new HashMap<String, List<ItemStack>>();
        int experienceLevel;
        float experienceProgress;
        int totalExperience;
        int foodLevel;
        float saturationLevel;

        PlayerSnapshot(ServerPlayer player) {
            int invSize = player.getInventory().getContainerSize();
            for (int i = 0; i < invSize; ++i) {
                this.allItems.add(player.getInventory().getItem(i).copy());
            }
            if (ModList.get().isLoaded("curios")) {
                this.saveCuriosItems(player);
            }
            this.experienceLevel = player.experienceLevel;
            this.experienceProgress = player.experienceProgress;
            this.totalExperience = player.totalExperience;
            this.foodLevel = player.getFoodData().getFoodLevel();
            this.saturationLevel = player.getFoodData().getSaturationLevel();
            LOGGER.info("Created snapshot for player {} with {} inventory items and {} curio slot types.", new Object[]{player.getName().getString(), this.allItems.size(), this.curiosItems.size()});
        }

        PlayerSnapshotData.SnapshotEntry toPersistent(HolderLookup.Provider registries) {
            ListTag inventoryList = new ListTag();
            for (int i = 0; i < this.allItems.size(); ++i) {
                ItemStack item = this.allItems.get(i);
                if (item.isEmpty()) continue;
                CompoundTag slotTag = new CompoundTag();
                slotTag.putInt("Slot", i);
                slotTag.put("Item", item.save(registries));
                inventoryList.add((Object)slotTag);
            }
            CompoundTag curiosTag = new CompoundTag();
            for (Map.Entry<String, List<ItemStack>> entry : this.curiosItems.entrySet()) {
                ListTag slotList = new ListTag();
                for (int i = 0; i < entry.getValue().size(); ++i) {
                    ItemStack item = entry.getValue().get(i);
                    if (item.isEmpty()) continue;
                    CompoundTag slotTag = new CompoundTag();
                    slotTag.putInt("Slot", i);
                    slotTag.put("Item", item.save(registries));
                    slotList.add((Object)slotTag);
                }
                curiosTag.put(entry.getKey(), (Tag)slotList);
            }
            return new PlayerSnapshotData.SnapshotEntry(inventoryList, curiosTag, this.experienceLevel, this.experienceProgress, this.totalExperience, this.foodLevel, this.saturationLevel);
        }

        static PlayerSnapshot fromPersistent(PlayerSnapshotData.SnapshotEntry entry, HolderLookup.Provider registries) {
            int i;
            PlayerSnapshot snapshot = new PlayerSnapshot();
            for (i = 0; i < 41; ++i) {
                snapshot.allItems.add(ItemStack.EMPTY);
            }
            for (i = 0; i < entry.inventoryItems.size(); ++i) {
                CompoundTag slotTag = entry.inventoryItems.getCompound(i);
                int slot = slotTag.getInt("Slot");
                CompoundTag itemTag = slotTag.getCompound("Item");
                ItemStack item = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)itemTag);
                while (snapshot.allItems.size() <= slot) {
                    snapshot.allItems.add(ItemStack.EMPTY);
                }
                snapshot.allItems.set(slot, item);
            }
            for (String slotId : entry.curiosItems.getAllKeys()) {
                int slot;
                CompoundTag slotTag;
                int i2;
                ListTag slotList = entry.curiosItems.getList(slotId, 10);
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                int maxSlot = 0;
                for (i2 = 0; i2 < slotList.size(); ++i2) {
                    slotTag = slotList.getCompound(i2);
                    slot = slotTag.getInt("Slot");
                    if (slot <= maxSlot) continue;
                    maxSlot = slot;
                }
                for (i2 = 0; i2 <= maxSlot; ++i2) {
                    items.add(ItemStack.EMPTY);
                }
                for (i2 = 0; i2 < slotList.size(); ++i2) {
                    slotTag = slotList.getCompound(i2);
                    slot = slotTag.getInt("Slot");
                    CompoundTag itemTag = slotTag.getCompound("Item");
                    ItemStack item = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)itemTag);
                    items.set(slot, item);
                }
                snapshot.curiosItems.put(slotId, items);
            }
            snapshot.experienceLevel = entry.experienceLevel;
            snapshot.experienceProgress = entry.experienceProgress;
            snapshot.totalExperience = entry.totalExperience;
            snapshot.foodLevel = entry.foodLevel;
            snapshot.saturationLevel = entry.saturationLevel;
            return snapshot;
        }

        private PlayerSnapshot() {
        }

        private void saveCuriosItems(ServerPlayer player) {
            try {
                Optional curiosInvOptional = CuriosApi.getCuriosInventory((LivingEntity)player);
                LOGGER.info("Curios inventory present for player {}: {}", (Object)player.getName().getString(), (Object)curiosInvOptional.isPresent());
                curiosInvOptional.ifPresent(curiosInventory -> {
                    LOGGER.info("Processing Curios inventory for player {}, slot count: {}", (Object)player.getName().getString(), (Object)curiosInventory.getCurios().size());
                    curiosInventory.getCurios().forEach((slotId, stacksHandler) -> {
                        ArrayList<ItemStack> slotItems = new ArrayList<ItemStack>();
                        for (int i = 0; i < stacksHandler.getStacks().getSlots(); ++i) {
                            ItemStack stack = stacksHandler.getStacks().getStackInSlot(i);
                            slotItems.add(stack.copy());
                            if (stack.isEmpty()) continue;
                            LOGGER.info("Saving Curios item in slot '{}' index {}: {}", new Object[]{slotId, i, stack.getDisplayName().getString()});
                        }
                        this.curiosItems.put((String)slotId, (List<ItemStack>)slotItems);
                    });
                    LOGGER.info("Saved Curios items from {} slot types for player {}", (Object)this.curiosItems.size(), (Object)player.getName().getString());
                });
            }
            catch (Exception e) {
                LOGGER.error("Failed to save Curios items for player {}: {}", new Object[]{player.getName().getString(), e.getMessage(), e});
            }
        }

        void restore(ServerPlayer player) {
            player.getInventory().clearContent();
            int invSize = player.getInventory().getContainerSize();
            if (this.allItems.size() == invSize) {
                for (int i = 0; i < invSize; ++i) {
                    player.getInventory().setItem(i, this.allItems.get(i).copy());
                }
            } else {
                LOGGER.error("Snapshot item count mismatch for player {}! Snapshot: {}, Inventory: {}. Cannot restore inventory.", new Object[]{player.getName().getString(), this.allItems.size(), invSize});
            }
            if (ModList.get().isLoaded("curios") && !this.curiosItems.isEmpty()) {
                this.restoreCuriosItems(player);
            }
            player.experienceLevel = this.experienceLevel;
            player.experienceProgress = this.experienceProgress;
            player.totalExperience = this.totalExperience;
            player.getFoodData().setFoodLevel(this.foodLevel);
            player.getFoodData().setSaturation(this.saturationLevel);
            player.getInventory().setChanged();
            LOGGER.debug("Restored snapshot for player {}.", (Object)player.getName().getString());
        }

        private void restoreCuriosItems(ServerPlayer player) {
            try {
                LOGGER.info("Attempting to restore {} Curios slot types for player {}", (Object)this.curiosItems.size(), (Object)player.getName().getString());
                Optional curiosInvOptional = CuriosApi.getCuriosInventory((LivingEntity)player);
                if (curiosInvOptional.isEmpty()) {
                    LOGGER.error("Failed to restore Curios items for player {}: getCuriosInventory returned empty! Curios inventory may not be initialized yet.", (Object)player.getName().getString());
                    return;
                }
                curiosInvOptional.ifPresent(curiosInventory -> this.curiosItems.forEach((slotId, items) -> {
                    ICurioStacksHandler stacksHandler = (ICurioStacksHandler)curiosInventory.getCurios().get(slotId);
                    if (stacksHandler != null) {
                        for (int i = 0; i < items.size() && i < stacksHandler.getStacks().getSlots(); ++i) {
                            ItemStack item = (ItemStack)items.get(i);
                            stacksHandler.getStacks().setStackInSlot(i, item.copy());
                            if (item.isEmpty()) continue;
                            LOGGER.info("Restored Curios item to slot '{}' index {}: {}", new Object[]{slotId, i, item.getDisplayName().getString()});
                        }
                        LOGGER.info("Restored {} items to Curios slot '{}' for player {}", new Object[]{items.size(), slotId, player.getName().getString()});
                    } else {
                        LOGGER.warn("Could not find Curios slot '{}' for player {} during restore", slotId, (Object)player.getName().getString());
                    }
                }));
            }
            catch (Exception e) {
                LOGGER.error("Failed to restore Curios items for player {}: {}", new Object[]{player.getName().getString(), e.getMessage(), e});
            }
        }
    }
}

