/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.moderation;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import world.landfall.landfallessentials.moderation.ModerationClientHandler;

public record ModListRequestPacket(RequestType requestType) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ModListRequestPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"landfallessentials", (String)"mod_list_request"));
    public static final StreamCodec<FriendlyByteBuf, ModListRequestPacket> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, ModListRequestPacket>(){

        public ModListRequestPacket decode(FriendlyByteBuf buffer) {
            return new ModListRequestPacket(RequestType.values()[buffer.readVarInt()]);
        }

        public void encode(FriendlyByteBuf buffer, ModListRequestPacket packet) {
            buffer.writeVarInt(packet.requestType().ordinal());
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ModListRequestPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (context.player() != null) {
                ModerationClientHandler.handleModListRequest(packet.requestType());
            }
        });
    }

    public static enum RequestType {
        MODS_ONLY,
        RESOURCE_PACKS_ONLY,
        BOTH;

    }
}

