/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.moderation;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import world.landfall.landfallessentials.moderation.ModListPacket;
import world.landfall.landfallessentials.moderation.ModerationManager;

@EventBusSubscriber
public class ModerationCommands {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MMM d, yyyy h:mm:ss a");
    private static final Set<String> HIDDEN_RESOURCE_PACKS = Set.of("mod_resources", "vanilla", "programmer_art", "high_contrast");

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"listmods").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ModerationCommands::listPlayerMods)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"listresourcepacks").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ModerationCommands::listPlayerResourcePacks)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"listclient").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ModerationCommands::listPlayerClient)));
    }

    private static int listPlayerMods(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer targetPlayer = EntityArgument.getPlayer(context, (String)"player");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ModerationManager.PlayerModData data = ModerationManager.getPlayerModData(targetPlayer.getUUID());
        if (data == null || data.getMods().isEmpty()) {
            ModerationManager.requestModDataFromPlayer(targetPlayer);
            source.sendSuccess(() -> Component.literal((String)("\u00a7eRequesting mod data from " + targetPlayer.getName().getString() + "... Please try again in a moment.")), false);
            return 1;
        }
        List<ModListPacket.ModInfo> mods = data.getMods();
        String timestamp = DATE_FORMAT.format(new Date(data.getTimestamp()));
        source.sendSuccess(() -> Component.literal((String)("\u00a76--- Mods for " + targetPlayer.getName().getString() + " ---")), false);
        source.sendSuccess(() -> Component.literal((String)("\u00a77Data collected: " + timestamp)), false);
        source.sendSuccess(() -> Component.literal((String)("\u00a77Total mods: " + mods.size())), false);
        source.sendSuccess(() -> Component.literal((String)" "), false);
        HashMap serverMods = new HashMap();
        ModList.get().forEachModContainer((modId, container) -> {
            if (container != null && container.getModInfo() != null) {
                serverMods.put(modId, container.getModInfo().getVersion().toString());
            }
        });
        ArrayList<ModListPacket.ModInfo> greenMods = new ArrayList<ModListPacket.ModInfo>();
        ArrayList<ModListPacket.ModInfo> yellowMods = new ArrayList<ModListPacket.ModInfo>();
        ArrayList<ModListPacket.ModInfo> redMods = new ArrayList<ModListPacket.ModInfo>();
        for (ModListPacket.ModInfo mod : mods) {
            String serverVersion = (String)serverMods.get(mod.modId());
            if (serverVersion == null) {
                redMods.add(mod);
                continue;
            }
            if (serverVersion.equals(mod.version())) {
                greenMods.add(mod);
                continue;
            }
            yellowMods.add(mod);
        }
        ModerationCommands.displayModList(source, greenMods, "\u00a7a");
        if (!yellowMods.isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)" "), false);
            source.sendSuccess(() -> Component.literal((String)"\u00a7eVersion Mismatched:"), false);
            ModerationCommands.displayModList(source, yellowMods, "\u00a7e");
        }
        if (!redMods.isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)" "), false);
            source.sendSuccess(() -> Component.literal((String)"\u00a7cNot on Server:"), false);
            ModerationCommands.displayModList(source, redMods, "\u00a7c");
        }
        return 1;
    }

    private static void displayModList(CommandSourceStack source, List<ModListPacket.ModInfo> mods, String color) {
        for (ModListPacket.ModInfo mod : mods) {
            MutableComponent modComponent = Component.literal((String)(color + mod.displayName() + " \u00a77(" + mod.modId() + ") \u00a78v" + mod.version())).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, mod.modId())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)("\u00a77Mod ID: \u00a7f" + mod.modId() + "\n\u00a77Version: \u00a7f" + mod.version() + "\n\u00a77Description: \u00a7f" + mod.description() + "\n\n\u00a7eClick to copy mod ID")))));
            source.sendSuccess(() -> ModerationCommands.lambda$displayModList$14((Component)modComponent), false);
        }
    }

    private static int listPlayerResourcePacks(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer targetPlayer = EntityArgument.getPlayer(context, (String)"player");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ModerationManager.requestResourcePackDataFromPlayer(targetPlayer);
        ModerationManager.PlayerModData data = ModerationManager.getPlayerModData(targetPlayer.getUUID());
        if (data == null || data.getResourcePacks().isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)("\u00a7eRequesting resource pack data from " + targetPlayer.getName().getString() + "... Please try again in a moment.")), false);
            return 1;
        }
        List<ModListPacket.ResourcePackInfo> resourcePacks = data.getResourcePacks().stream().filter(pack -> !HIDDEN_RESOURCE_PACKS.contains(pack.id())).toList();
        String timestamp = DATE_FORMAT.format(new Date(data.getTimestamp()));
        source.sendSuccess(() -> Component.literal((String)("\u00a76--- Resource Packs for " + targetPlayer.getName().getString() + " ---")), false);
        source.sendSuccess(() -> Component.literal((String)("\u00a77Data collected: " + timestamp + " \u00a7e(Refreshing...)")), false);
        source.sendSuccess(() -> Component.literal((String)("\u00a77Total resource packs: " + resourcePacks.size())), false);
        source.sendSuccess(() -> Component.literal((String)" "), false);
        for (ModListPacket.ResourcePackInfo pack2 : resourcePacks) {
            MutableComponent packComponent = Component.literal((String)("\u00a7b" + pack2.title() + " \u00a77(" + pack2.source() + ")")).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, pack2.id())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)("\u00a77Pack ID: \u00a7f" + pack2.id() + "\n\u00a77Source: \u00a7f" + pack2.source() + "\n\u00a77Description: \u00a7f" + pack2.description() + "\n\n\u00a7eClick to copy pack ID")))));
            source.sendSuccess(() -> ModerationCommands.lambda$listPlayerResourcePacks$22((Component)packComponent), false);
        }
        return 1;
    }

    private static int listPlayerClient(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer targetPlayer = EntityArgument.getPlayer(context, (String)"player");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ModerationManager.PlayerModData data = ModerationManager.getPlayerModData(targetPlayer.getUUID());
        if (data == null) {
            ModerationManager.requestModDataFromPlayer(targetPlayer);
            source.sendSuccess(() -> Component.literal((String)("\u00a7eRequesting client data from " + targetPlayer.getName().getString() + "... Please try again in a moment.")), false);
            return 1;
        }
        ModerationManager.requestResourcePackDataFromPlayer(targetPlayer);
        List<ModListPacket.ModInfo> mods = data.getMods();
        List<ModListPacket.ResourcePackInfo> resourcePacks = data.getResourcePacks().stream().filter(pack -> !HIDDEN_RESOURCE_PACKS.contains(pack.id())).toList();
        String timestamp = DATE_FORMAT.format(new Date(data.getTimestamp()));
        source.sendSuccess(() -> Component.literal((String)("\u00a76--- Client Overview for " + targetPlayer.getName().getString() + " ---")), false);
        source.sendSuccess(() -> Component.literal((String)("\u00a77Data collected: " + timestamp + " \u00a7e(Resource packs refreshing...)")), false);
        source.sendSuccess(() -> Component.literal((String)" "), false);
        source.sendSuccess(() -> Component.literal((String)"\u00a7eSummary:"), false);
        source.sendSuccess(() -> Component.literal((String)("\u00a77- Total Mods: \u00a7a" + mods.size())), false);
        source.sendSuccess(() -> Component.literal((String)("\u00a77- Total Resource Packs: \u00a7b" + resourcePacks.size())), false);
        source.sendSuccess(() -> Component.literal((String)" "), false);
        MutableComponent listModsCmd = Component.literal((String)("\u00a7a/listmods " + targetPlayer.getName().getString())).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/listmods " + targetPlayer.getName().getString())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to view detailed mod list"))));
        MutableComponent listPacksCmd = Component.literal((String)("\u00a7b/listresourcepacks " + targetPlayer.getName().getString())).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/listresourcepacks " + targetPlayer.getName().getString())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to view detailed resource pack list"))));
        source.sendSuccess(() -> Component.literal((String)"\u00a7eDetailed Views:"), false);
        source.sendSuccess(() -> ModerationCommands.lambda$listPlayerClient$35((Component)listModsCmd), false);
        source.sendSuccess(() -> ModerationCommands.lambda$listPlayerClient$36((Component)listPacksCmd), false);
        return 1;
    }

    private static /* synthetic */ Component lambda$listPlayerClient$36(Component listPacksCmd) {
        return Component.literal((String)"\u00a77- ").append(listPacksCmd);
    }

    private static /* synthetic */ Component lambda$listPlayerClient$35(Component listModsCmd) {
        return Component.literal((String)"\u00a77- ").append(listModsCmd);
    }

    private static /* synthetic */ Component lambda$listPlayerResourcePacks$22(Component packComponent) {
        return Component.literal((String)"\u00a77- ").append(packComponent);
    }

    private static /* synthetic */ Component lambda$displayModList$14(Component modComponent) {
        return Component.literal((String)"\u00a77- ").append(modComponent);
    }
}

