/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.regions;

import com.google.gson.annotations.Expose;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;

public class Cuboid {
    @Expose
    private int minX;
    @Expose
    private int minY;
    @Expose
    private int minZ;
    @Expose
    private int maxX;
    @Expose
    private int maxY;
    @Expose
    private int maxZ;

    private Cuboid() {
    }

    public Cuboid(BlockPos corner1, BlockPos corner2) {
        this.minX = Math.min(corner1.getX(), corner2.getX());
        this.minY = Math.min(corner1.getY(), corner2.getY());
        this.minZ = Math.min(corner1.getZ(), corner2.getZ());
        this.maxX = Math.max(corner1.getX(), corner2.getX());
        this.maxY = Math.max(corner1.getY(), corner2.getY());
        this.maxZ = Math.max(corner1.getZ(), corner2.getZ());
    }

    public Cuboid(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = Math.min(minX, maxX);
        this.minY = Math.min(minY, maxY);
        this.minZ = Math.min(minZ, maxZ);
        this.maxX = Math.max(minX, maxX);
        this.maxY = Math.max(minY, maxY);
        this.maxZ = Math.max(minZ, maxZ);
    }

    public boolean contains(Player player) {
        if (player == null) {
            return false;
        }
        BlockPos pos = player.blockPosition();
        return this.contains(pos);
    }

    public boolean contains(BlockPos pos) {
        return pos.getX() >= this.minX && pos.getX() <= this.maxX && pos.getY() >= this.minY && pos.getY() <= this.maxY && pos.getZ() >= this.minZ && pos.getZ() <= this.maxZ;
    }

    public long getVolume() {
        long width = this.maxX - this.minX + 1;
        long height = this.maxY - this.minY + 1;
        long depth = this.maxZ - this.minZ + 1;
        return width * height * depth;
    }

    public boolean overlaps(Cuboid other) {
        if (other == null) {
            return false;
        }
        return this.maxX >= other.minX && this.minX <= other.maxX && this.maxY >= other.minY && this.minY <= other.maxY && this.maxZ >= other.minZ && this.minZ <= other.maxZ;
    }

    public BlockPos getMinCorner() {
        return new BlockPos(this.minX, this.minY, this.minZ);
    }

    public BlockPos getMaxCorner() {
        return new BlockPos(this.maxX, this.maxY, this.maxZ);
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cuboid cuboid = (Cuboid)o;
        return this.minX == cuboid.minX && this.minY == cuboid.minY && this.minZ == cuboid.minZ && this.maxX == cuboid.maxX && this.maxY == cuboid.maxY && this.maxZ == cuboid.maxZ;
    }

    public int hashCode() {
        return Objects.hash(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public String toString() {
        return String.format("Cuboid{[%d,%d,%d] to [%d,%d,%d], volume=%d}", this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ, this.getVolume());
    }

    public String toDisplayString() {
        return String.format("[%d,%d,%d] to [%d,%d,%d]", this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public boolean isFullyContainedWithin(Cuboid other) {
        if (other == null) {
            return false;
        }
        return this.minX >= other.minX && this.maxX <= other.maxX && this.minY >= other.minY && this.maxY <= other.maxY && this.minZ >= other.minZ && this.maxZ <= other.maxZ;
    }
}

