/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.regions;

import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.regions.PermissionUtil;
import world.landfall.landfallessentials.regions.Region;
import world.landfall.landfallessentials.regions.RegionManager;

@EventBusSubscriber(modid="landfallessentials")
public class RegionTeleportHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegionTeleportHandler.class);

    @SubscribeEvent
    public static void onPlayerTeleport(EntityTeleportEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        Level targetLevel = event.getEntity().level();
        BlockPos targetPos = BlockPos.containing((double)event.getTargetX(), (double)event.getTargetY(), (double)event.getTargetZ());
        String targetDimension = targetLevel.dimension().location().toString();
        Set targetRegions = RegionManager.getAllRegions().values().stream().filter(region -> region.getDimension().equals(targetDimension)).filter(region -> RegionTeleportHandler.isPositionInRegion(region, targetPos)).filter(region -> RegionTeleportHandler.hasPermissionTags(region)).collect(Collectors.toSet());
        for (Region region2 : targetRegions) {
            if (RegionTeleportHandler.playerHasAllPermissionTags(player, region2)) continue;
            event.setCanceled(true);
            if (region2.hasAccessDeniedMessage()) {
                player.sendSystemMessage((Component)Component.literal((String)region2.getAccessDeniedMessage().replace("&", "\u00a7")));
            } else {
                player.sendSystemMessage((Component)Component.literal((String)("\u00a7cTeleportation blocked: You don't have permission to enter region '" + region2.getName() + "'")));
            }
            LOGGER.debug("Blocked teleportation for player {} to region {} (missing permission tags: {})", new Object[]{player.getName().getString(), region2.getName(), RegionTeleportHandler.getPermissionTagsFromRegion(region2)});
            return;
        }
    }

    private static boolean isPositionInRegion(Region region, BlockPos pos) {
        return pos.getX() >= region.getMinX() && pos.getX() <= region.getMaxX() && pos.getY() >= region.getMinY() && pos.getY() <= region.getMaxY() && pos.getZ() >= region.getMinZ() && pos.getZ() <= region.getMaxZ();
    }

    private static boolean hasPermissionTags(Region region) {
        return region.getTags().stream().anyMatch(tag -> tag.startsWith("permission:"));
    }

    private static boolean playerHasAllPermissionTags(ServerPlayer player, Region region) {
        for (String tag : region.getTags()) {
            String permissionNode;
            if (!tag.startsWith("permission:") || PermissionUtil.hasPermission(player, permissionNode = tag.substring(11))) continue;
            return false;
        }
        return true;
    }

    private static String getPermissionTagsFromRegion(Region region) {
        return region.getTags().stream().filter(tag -> tag.startsWith("permission:")).map(tag -> tag.substring(11)).reduce((a, b) -> a + ", " + b).orElse("none");
    }
}

