/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.regions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.regions.Cuboid;
import world.landfall.landfallessentials.regions.Region;
import world.landfall.landfallessentials.regions.RegionManager;

@EventBusSubscriber(modid="landfallessentials")
public class RegionVisualizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegionVisualizer.class);
    private static final Set<UUID> playersWithVisualization = ConcurrentHashMap.newKeySet();
    private static final Map<UUID, Map<String, List<Shulker>>> playerRegionDisplays = new ConcurrentHashMap<UUID, Map<String, List<Shulker>>>();
    private static final DyeColor[] CUBOID_COLORS = new DyeColor[]{DyeColor.LIGHT_BLUE, DyeColor.LIME, DyeColor.YELLOW, DyeColor.ORANGE, DyeColor.MAGENTA, DyeColor.PINK, DyeColor.CYAN, DyeColor.PURPLE, DyeColor.RED, DyeColor.GREEN, DyeColor.BLUE, DyeColor.WHITE};
    private static final int MAX_VISUALIZATION_DISTANCE = 128;
    private static final int MAX_SHULKERS_PER_PLAYER = 200;

    public static boolean toggleVisualization(ServerPlayer player) {
        UUID playerUUID = player.getUUID();
        if (playersWithVisualization.contains(playerUUID)) {
            playersWithVisualization.remove(playerUUID);
            RegionVisualizer.clearPlayerVisualizations(player);
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7cRegion visualization disabled."));
            return false;
        }
        playersWithVisualization.add(playerUUID);
        RegionVisualizer.updatePlayerVisualizations(player);
        player.sendSystemMessage((Component)Component.literal((String)"\u00a7aRegion visualization enabled."));
        return true;
    }

    public static boolean hasVisualizationEnabled(ServerPlayer player) {
        return playersWithVisualization.contains(player.getUUID());
    }

    public static void updatePlayerVisualizations(ServerPlayer player) {
        if (!playersWithVisualization.contains(player.getUUID())) {
            return;
        }
        RegionVisualizer.clearPlayerVisualizations(player);
        Map<String, Region> nearbyRegions = RegionVisualizer.getNearbyRegions(player);
        UUID playerUUID = player.getUUID();
        HashMap<String, List<Shulker>> regionDisplays = new HashMap<String, List<Shulker>>();
        for (Map.Entry<String, Region> entry : nearbyRegions.entrySet()) {
            String regionName = entry.getKey();
            Region region = entry.getValue();
            List<Shulker> displays = RegionVisualizer.createRegionVisualization(player, region);
            if (displays.isEmpty()) continue;
            regionDisplays.put(regionName, displays);
        }
        playerRegionDisplays.put(playerUUID, regionDisplays);
    }

    public static void clearPlayerVisualizations(ServerPlayer player) {
        UUID playerUUID = player.getUUID();
        Map<String, List<Shulker>> regionDisplays = playerRegionDisplays.remove(playerUUID);
        if (regionDisplays != null) {
            for (List<Shulker> displays : regionDisplays.values()) {
                for (Shulker display : displays) {
                    if (display == null || !display.isAlive()) continue;
                    display.discard();
                }
            }
        }
    }

    public static void clearAllVisualizations() {
        for (Map<String, List<Shulker>> regionDisplays : playerRegionDisplays.values()) {
            for (List<Shulker> displays : regionDisplays.values()) {
                for (Shulker display : displays) {
                    if (display == null || !display.isAlive()) continue;
                    display.discard();
                }
            }
        }
        playerRegionDisplays.clear();
    }

    public static void onRegionChanged(String regionName) {
        for (UUID uUID : playersWithVisualization) {
        }
    }

    public static void onRegionsChanged() {
    }

    public static void onPlayerDisconnect(ServerPlayer player) {
        UUID playerUUID = player.getUUID();
        playersWithVisualization.remove(playerUUID);
        RegionVisualizer.clearPlayerVisualizations(player);
    }

    private static Map<String, Region> getNearbyRegions(ServerPlayer player) {
        HashMap<String, Region> nearbyRegions = new HashMap<String, Region>();
        BlockPos playerPos = player.blockPosition();
        String playerDimension = player.level().dimension().location().toString();
        block0: for (Map.Entry<String, Region> entry : RegionManager.getAllRegions().entrySet()) {
            Region region = entry.getValue();
            if (!region.getDimension().equals(playerDimension)) continue;
            for (Cuboid cuboid : region.getCuboids()) {
                if (!RegionVisualizer.isWithinVisualizationDistance(playerPos, cuboid)) continue;
                nearbyRegions.put(entry.getKey(), region);
                continue block0;
            }
        }
        return nearbyRegions;
    }

    private static boolean isWithinVisualizationDistance(BlockPos pos, Cuboid cuboid) {
        int closestZ;
        int closestY;
        int closestX = Math.max(cuboid.getMinX(), Math.min(pos.getX(), cuboid.getMaxX()));
        double distanceSquared = pos.distSqr((Vec3i)new BlockPos(closestX, closestY = Math.max(cuboid.getMinY(), Math.min(pos.getY(), cuboid.getMaxY())), closestZ = Math.max(cuboid.getMinZ(), Math.min(pos.getZ(), cuboid.getMaxZ()))));
        return distanceSquared <= 16384.0;
    }

    private static List<Shulker> createRegionVisualization(ServerPlayer player, Region region) {
        ArrayList<Shulker> displays = new ArrayList<Shulker>();
        ServerLevel level = player.serverLevel();
        List<Cuboid> cuboids = region.getCuboids();
        for (int i = 0; i < cuboids.size(); ++i) {
            Cuboid cuboid = cuboids.get(i);
            DyeColor color = RegionVisualizer.getCuboidColor(i);
            List<Shulker> cuboidDisplays = RegionVisualizer.createCuboidBorder(level, cuboid, color, region.getName(), i);
            if (displays.size() + cuboidDisplays.size() > 200) {
                LOGGER.warn("Skipping visualization for player {} - would exceed entity limit", (Object)player.getName().getString());
                break;
            }
            displays.addAll(cuboidDisplays);
        }
        return displays;
    }

    private static DyeColor getCuboidColor(int cuboidIndex) {
        return CUBOID_COLORS[cuboidIndex % CUBOID_COLORS.length];
    }

    private static List<Shulker> createCuboidBorder(ServerLevel level, Cuboid cuboid, DyeColor color, String regionName, int cuboidIndex) {
        ArrayList<Shulker> displays = new ArrayList<Shulker>();
        try {
            int minX = cuboid.getMinX();
            int minY = cuboid.getMinY();
            int minZ = cuboid.getMinZ();
            int maxX = cuboid.getMaxX();
            int maxY = cuboid.getMaxY();
            int maxZ = cuboid.getMaxZ();
            displays.add(RegionVisualizer.createCornerDisplay(level, minX, minY, minZ, color, regionName, cuboidIndex));
            displays.add(RegionVisualizer.createCornerDisplay(level, maxX, minY, minZ, color, regionName, cuboidIndex));
            displays.add(RegionVisualizer.createCornerDisplay(level, minX, minY, maxZ, color, regionName, cuboidIndex));
            displays.add(RegionVisualizer.createCornerDisplay(level, maxX, minY, maxZ, color, regionName, cuboidIndex));
            displays.add(RegionVisualizer.createCornerDisplay(level, minX, maxY, minZ, color, regionName, cuboidIndex));
            displays.add(RegionVisualizer.createCornerDisplay(level, maxX, maxY, minZ, color, regionName, cuboidIndex));
            displays.add(RegionVisualizer.createCornerDisplay(level, minX, maxY, maxZ, color, regionName, cuboidIndex));
            displays.add(RegionVisualizer.createCornerDisplay(level, maxX, maxY, maxZ, color, regionName, cuboidIndex));
            int sizeX = maxX - minX;
            int sizeY = maxY - minY;
            int sizeZ = maxZ - minZ;
            if ((sizeX > 4 || sizeY > 4 || sizeZ > 4) && sizeX > 4 && sizeZ > 4) {
                displays.add(RegionVisualizer.createCornerDisplay(level, minX + sizeX / 2, minY, minZ + sizeZ / 2, color, regionName, cuboidIndex));
                displays.add(RegionVisualizer.createCornerDisplay(level, minX + sizeX / 2, maxY, minZ + sizeZ / 2, color, regionName, cuboidIndex));
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to create cuboid border visualization", (Throwable)e);
        }
        return displays;
    }

    private static Shulker createCornerDisplay(ServerLevel level, int x, int y, int z, DyeColor color, String regionName, int cuboidIndex) {
        try {
            Shulker shulker = new Shulker(EntityType.SHULKER, (Level)level);
            Vec3 pos = new Vec3((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
            shulker.moveTo(pos.x, pos.y, pos.z, 0.0f, 0.0f);
            shulker.setNoGravity(true);
            shulker.setInvulnerable(true);
            shulker.setSilent(true);
            shulker.setNoAi(true);
            shulker.setVariant(Optional.of(color));
            shulker.setGlowingTag(true);
            shulker.setCustomNameVisible(true);
            shulker.setCustomName((Component)Component.literal((String)("\u00a7f" + regionName + " \u00a77[\u00a7" + RegionVisualizer.getColorCode(color) + "CUBOID " + cuboidIndex + "\u00a77]")));
            if (level.addFreshEntity((Entity)shulker)) {
                return shulker;
            }
            LOGGER.error("Failed to spawn region border marker at {}", (Object)pos);
            return null;
        }
        catch (Exception e) {
            LOGGER.error("Failed to create corner display at {}, {}, {}", new Object[]{x, y, z, e});
            return null;
        }
    }

    private static String getColorCode(DyeColor color) {
        return switch (color) {
            default -> throw new MatchException(null, null);
            case DyeColor.BLACK -> "0";
            case DyeColor.BLUE -> "1";
            case DyeColor.BROWN -> "6";
            case DyeColor.CYAN -> "3";
            case DyeColor.GRAY -> "8";
            case DyeColor.GREEN -> "2";
            case DyeColor.LIGHT_BLUE -> "b";
            case DyeColor.LIGHT_GRAY -> "7";
            case DyeColor.LIME -> "a";
            case DyeColor.MAGENTA -> "d";
            case DyeColor.ORANGE -> "6";
            case DyeColor.PINK -> "d";
            case DyeColor.PURPLE -> "5";
            case DyeColor.RED -> "c";
            case DyeColor.WHITE -> "f";
            case DyeColor.YELLOW -> "e";
        };
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (player2.tickCount % 20 != 0) {
            return;
        }
        if (playersWithVisualization.contains(player2.getUUID())) {
            RegionVisualizer.updatePlayerVisualizations(player2);
        }
    }

    @SubscribeEvent
    public static void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            RegionVisualizer.onPlayerDisconnect(player2);
        }
    }
}

