/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.regions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.regions.Cuboid;
import world.landfall.landfallessentials.regions.Region;
import world.landfall.landfallessentials.regions.RegionManager;
import world.landfall.landfallessentials.regions.RegionRental;
import world.landfall.landfallessentials.regions.packets.RegionVisualizationPacket;

public class RentableVisualization {
    private static final Logger LOGGER = LoggerFactory.getLogger(RentableVisualization.class);
    private static final Set<UUID> playersWithRentableVisualization = ConcurrentHashMap.newKeySet();
    private static final Map<UUID, String> lastSentRegion = new ConcurrentHashMap<UUID, String>();

    public static boolean toggleRentableVisualization(ServerPlayer player) {
        UUID playerUUID = player.getUUID();
        if (playersWithRentableVisualization.contains(playerUUID)) {
            playersWithRentableVisualization.remove(playerUUID);
            lastSentRegion.remove(playerUUID);
            RentableVisualization.sendVisualizationPacket(player, false, Collections.emptyList());
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7cRentable region visualization disabled."));
            return false;
        }
        playersWithRentableVisualization.add(playerUUID);
        RentableVisualization.updateRentableVisualization(player);
        player.sendSystemMessage((Component)Component.literal((String)"\u00a7aRentable region visualization enabled."));
        return true;
    }

    public static void updateRentableVisualization(ServerPlayer player) {
        if (!playersWithRentableVisualization.contains(player.getUUID())) {
            return;
        }
        Set<String> playerRegionNames = RegionManager.getPlayerRegions(player.getUUID().toString());
        List rentableRegions = playerRegionNames.stream().map(RegionManager::getRegion).filter(region -> region != null).filter(region -> {
            for (String tag : region.getTags()) {
                if (!tag.startsWith("rentable:")) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        ArrayList<RegionVisualizationPacket.RegionData> regionData = new ArrayList<RegionVisualizationPacket.RegionData>();
        for (Region region2 : rentableRegions) {
            ArrayList<RegionVisualizationPacket.CuboidData> cuboidData = new ArrayList<RegionVisualizationPacket.CuboidData>();
            int color = RegionRental.isRented(region2.getName()) ? 0xFFFF00 : 65280;
            for (Cuboid cuboid : region2.getCuboids()) {
                cuboidData.add(new RegionVisualizationPacket.CuboidData(cuboid.getMinCorner(), cuboid.getMaxCorner(), color));
            }
            regionData.add(new RegionVisualizationPacket.RegionData(region2.getName(), region2.getDimension(), cuboidData));
        }
        String currentRegion = rentableRegions.isEmpty() ? "" : ((Region)rentableRegions.get(0)).getName();
        String lastRegion = lastSentRegion.get(player.getUUID());
        if (lastRegion == null || !lastRegion.equals(currentRegion)) {
            RentableVisualization.sendVisualizationPacket(player, !regionData.isEmpty(), regionData);
            lastSentRegion.put(player.getUUID(), currentRegion);
            if (!rentableRegions.isEmpty()) {
                Region region3 = (Region)rentableRegions.get(0);
                int price = RegionRental.getRentalPrice(region3.getName());
                boolean isRented = RegionRental.isRented(region3.getName());
                Object status = isRented ? "\u00a7e(Currently rented)" : "\u00a7a(Available - " + price + " karma/week)";
                player.displayClientMessage((Component)Component.literal((String)("\u00a7bVisualizing rentable region: \u00a7f" + region3.getName() + " " + (String)status)), true);
            }
        }
    }

    private static void sendVisualizationPacket(ServerPlayer player, boolean enabled, List<RegionVisualizationPacket.RegionData> regions) {
        RegionVisualizationPacket packet = new RegionVisualizationPacket(enabled, regions);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static boolean hasRentableVisualizationEnabled(ServerPlayer player) {
        return playersWithRentableVisualization.contains(player.getUUID());
    }

    public static void onPlayerMove(ServerPlayer player) {
        if (playersWithRentableVisualization.contains(player.getUUID())) {
            RentableVisualization.updateRentableVisualization(player);
        }
    }

    public static void onPlayerDisconnect(ServerPlayer player) {
        UUID playerUUID = player.getUUID();
        playersWithRentableVisualization.remove(playerUUID);
        lastSentRegion.remove(playerUUID);
    }
}

