/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.regions.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import world.landfall.landfallessentials.regions.RegionManager;
import world.landfall.landfallessentials.regions.RegionRental;
import world.landfall.landfallessentials.regions.RentableVisualization;
import world.landfall.landfallessentials.regions.market.MarketConfig;
import world.landfall.landfallessentials.regions.market.MarketManager;
import world.landfall.landfallessentials.regions.util.CommandMessageBuilder;
import world.landfall.landfallessentials.regions.util.RegionCommandHelper;

public class RegionRentalCommands {
    private static final int PLAYER_PERMISSION = 0;
    private static final int ADMIN_PERMISSION = 2;

    public static LiteralArgumentBuilder<CommandSourceStack> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"rent").requires(source -> source.hasPermission(0))).executes(RegionRentalCommands::executeRentCurrent)).then(Commands.argument((String)"weeks", (ArgumentType)IntegerArgumentType.integer((int)1, (int)5)).executes(RegionRentalCommands::executeRentWeeks))).then(Commands.literal((String)"trust").then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).executes(RegionRentalCommands::executeRentTrust)))).then(Commands.literal((String)"untrust").then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).executes(RegionRentalCommands::executeRentUntrust)))).then(Commands.literal((String)"visualize").executes(RegionRentalCommands::executeRentVisualize))).then(((LiteralArgumentBuilder)Commands.literal((String)"admin").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"unrent").then(Commands.argument((String)"region", (ArgumentType)StringArgumentType.string()).suggests(RegionRentalCommands::suggestRentedRegions).executes(RegionRentalCommands::executeAdminUnrent))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"market").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"create").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"floor", (ArgumentType)IntegerArgumentType.integer((int)1)).then(((RequiredArgumentBuilder)Commands.argument((String)"ceiling", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> RegionRentalCommands.executeMarketCreate((CommandContext<CommandSourceStack>)ctx, 1.5))).then(Commands.argument((String)"exponent", (ArgumentType)DoubleArgumentType.doubleArg((double)0.1, (double)5.0)).executes(ctx -> RegionRentalCommands.executeMarketCreate((CommandContext<CommandSourceStack>)ctx, DoubleArgumentType.getDouble((CommandContext)ctx, (String)"exponent"))))))))).then(Commands.literal((String)"delete").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests(RegionRentalCommands::suggestMarketNames).executes(RegionRentalCommands::executeMarketDelete)))).then(Commands.literal((String)"list").executes(RegionRentalCommands::executeMarketList))).then(Commands.literal((String)"info").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests(RegionRentalCommands::suggestMarketNames).executes(RegionRentalCommands::executeMarketInfo)))).then(Commands.literal((String)"setfloor").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests(RegionRentalCommands::suggestMarketNames).then(Commands.argument((String)"price", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(RegionRentalCommands::executeMarketSetFloor))))).then(Commands.literal((String)"setceiling").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests(RegionRentalCommands::suggestMarketNames).then(Commands.argument((String)"price", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(RegionRentalCommands::executeMarketSetCeiling))))).then(Commands.literal((String)"setexponent").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests(RegionRentalCommands::suggestMarketNames).then(Commands.argument((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)0.1, (double)5.0)).executes(RegionRentalCommands::executeMarketSetExponent)))));
    }

    private static CompletableFuture<Suggestions> suggestRentableRegions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        List rentableRegions = RegionManager.getAllRegions().entrySet().stream().filter(entry -> RegionRental.isRentable((String)entry.getKey())).map(Map.Entry::getKey).collect(Collectors.toList());
        return SharedSuggestionProvider.suggest(rentableRegions, (SuggestionsBuilder)builder);
    }

    private static CompletableFuture<Suggestions> suggestRentedRegions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        List<String> rentedRegions = RegionRental.getAllRentedRegions();
        return SharedSuggestionProvider.suggest(rentedRegions, (SuggestionsBuilder)builder);
    }

    private static CompletableFuture<Suggestions> suggestMarketNames(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggest(MarketManager.getMarketNames(), (SuggestionsBuilder)builder);
    }

    private static int executeRentCurrent(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = RegionCommandHelper.getPlayerOrFail(ctx);
        if (player == null) {
            return 0;
        }
        Set<String> currentRegions = RegionManager.getPlayerRegions(player.getUUID().toString());
        if (currentRegions.isEmpty()) {
            RegionCommandHelper.sendFailure(ctx, CommandMessageBuilder.errorMsg("\u2717 You are not in any region."));
            return 0;
        }
        String rentableRegion = null;
        for (String regionName : currentRegions) {
            if (!RegionRental.isRentable(regionName)) continue;
            rentableRegion = regionName;
            break;
        }
        if (rentableRegion == null) {
            RegionCommandHelper.sendFailure(ctx, CommandMessageBuilder.errorMsg("\u2717 No rentable regions found in your current location."));
            return 0;
        }
        return RegionRentalCommands.executeRentRegionInternal(ctx, rentableRegion, 1);
    }

    private static int executeRentWeeks(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = RegionCommandHelper.getPlayerOrFail(ctx);
        if (player == null) {
            return 0;
        }
        int weeks = IntegerArgumentType.getInteger(ctx, (String)"weeks");
        Set<String> currentRegions = RegionManager.getPlayerRegions(player.getUUID().toString());
        if (currentRegions.isEmpty()) {
            RegionCommandHelper.sendFailure(ctx, CommandMessageBuilder.errorMsg("\u2717 You are not in any region."));
            return 0;
        }
        String rentableRegion = null;
        for (String regionName : currentRegions) {
            if (!RegionRental.isRentable(regionName)) continue;
            rentableRegion = regionName;
            break;
        }
        if (rentableRegion == null) {
            RegionCommandHelper.sendFailure(ctx, CommandMessageBuilder.errorMsg("\u2717 No rentable regions found in your current location."));
            return 0;
        }
        return RegionRentalCommands.executeRentRegionInternal(ctx, rentableRegion, weeks);
    }

    private static int executeRentTrust(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = RegionCommandHelper.getPlayerOrFail(ctx);
        if (player == null) {
            return 0;
        }
        String targetPlayerName = StringArgumentType.getString(ctx, (String)"player");
        Set<String> currentRegions = RegionManager.getPlayerRegions(player.getUUID().toString());
        if (currentRegions.isEmpty()) {
            RegionCommandHelper.sendFailure(ctx, CommandMessageBuilder.errorMsg("\u2717 You are not in any region."));
            return 0;
        }
        String ownedRegion = null;
        for (String regionName : currentRegions) {
            if (!RegionRental.isOwner(regionName, player.getUUID())) continue;
            ownedRegion = regionName;
            break;
        }
        if (ownedRegion == null) {
            RegionCommandHelper.sendFailure(ctx, CommandMessageBuilder.errorMsg("\u2717 You don't own any rented regions in your current location."));
            return 0;
        }
        RegionRental.TrustResult result = RegionRental.trustPlayer(ownedRegion, player.getUUID(), targetPlayerName);
        if (result.isSuccess()) {
            RegionCommandHelper.sendSuccess(ctx, CommandMessageBuilder.successMsg(result.getMessage()), true);
            return 1;
        }
        RegionCommandHelper.sendFailure(ctx, CommandMessageBuilder.errorMsg(result.getMessage()));
        return 0;
    }

    private static int executeRentUntrust(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = RegionCommandHelper.getPlayerOrFail(ctx);
        if (player == null) {
            return 0;
        }
        String targetPlayerName = StringArgumentType.getString(ctx, (String)"player");
        Set<String> currentRegions = RegionManager.getPlayerRegions(player.getUUID().toString());
        if (currentRegions.isEmpty()) {
            RegionCommandHelper.sendFailure(ctx, CommandMessageBuilder.errorMsg("\u2717 You are not in any region."));
            return 0;
        }
        String ownedRegion = null;
        for (String regionName : currentRegions) {
            if (!RegionRental.isOwner(regionName, player.getUUID())) continue;
            ownedRegion = regionName;
            break;
        }
        if (ownedRegion == null) {
            RegionCommandHelper.sendFailure(ctx, CommandMessageBuilder.errorMsg("\u2717 You don't own any rented regions in your current location."));
            return 0;
        }
        RegionRental.TrustResult result = RegionRental.untrustPlayer(ownedRegion, player.getUUID(), targetPlayerName);
        if (result.isSuccess()) {
            RegionCommandHelper.sendSuccess(ctx, CommandMessageBuilder.successMsg(result.getMessage()), true);
            return 1;
        }
        RegionCommandHelper.sendFailure(ctx, CommandMessageBuilder.errorMsg(result.getMessage()));
        return 0;
    }

    private static int executeRentVisualize(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = RegionCommandHelper.getPlayerOrFail(ctx);
        if (player == null) {
            return 0;
        }
        boolean enabled = RentableVisualization.toggleRentableVisualization(player);
        return enabled ? 1 : 0;
    }

    private static int executeAdminUnrent(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String regionName = StringArgumentType.getString(ctx, (String)"region");
        RegionRental.AdminResult result = RegionRental.adminUnrentRegion(regionName);
        if (result.isSuccess()) {
            RegionCommandHelper.sendSuccess(ctx, CommandMessageBuilder.successMsg(result.getMessage()), true);
            return 1;
        }
        RegionCommandHelper.sendFailure(ctx, CommandMessageBuilder.errorMsg(result.getMessage()));
        return 0;
    }

    private static int executeMarketCreate(CommandContext<CommandSourceStack> ctx, double exponent) {
        int ceilingPrice;
        String name = StringArgumentType.getString(ctx, (String)"name");
        int floorPrice = IntegerArgumentType.getInteger(ctx, (String)"floor");
        if (floorPrice > (ceilingPrice = IntegerArgumentType.getInteger(ctx, (String)"ceiling"))) {
            RegionCommandHelper.sendFailure(ctx, CommandMessageBuilder.errorMsg("\u2717 Floor price cannot be higher than ceiling price."));
            return 0;
        }
        if (MarketManager.createMarket(name, floorPrice, ceilingPrice, exponent, null)) {
            RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().success("\u2713 Created market '").highlight(name).success("' with floor=").value(String.valueOf(floorPrice)).success(", ceiling=").value(String.valueOf(ceilingPrice)).success(", exponent=").value(String.format("%.2f", exponent)).build(), true);
            return 1;
        }
        RegionCommandHelper.sendFailure(ctx, new CommandMessageBuilder().error("\u2717 Market '").highlight(name).error("' already exists.").build());
        return 0;
    }

    private static int executeMarketDelete(CommandContext<CommandSourceStack> ctx) {
        String name = StringArgumentType.getString(ctx, (String)"name");
        if (MarketManager.deleteMarket(name)) {
            RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().success("\u2713 Deleted market '").highlight(name).success("'.").build(), true);
            return 1;
        }
        RegionCommandHelper.sendFailure(ctx, new CommandMessageBuilder().error("\u2717 Market '").highlight(name).error("' not found.").build());
        return 0;
    }

    private static int executeMarketList(CommandContext<CommandSourceStack> ctx) {
        Collection<MarketConfig> markets = MarketManager.getAllMarkets();
        if (markets.isEmpty()) {
            RegionCommandHelper.sendSuccess(ctx, CommandMessageBuilder.infoMsg("No markets configured."));
            return 0;
        }
        StringBuilder info = new StringBuilder();
        info.append("\u00a7b=== Rental Markets ===\n");
        for (MarketConfig market : markets) {
            int currentPrice = MarketManager.getCurrentPrice(market.getName());
            double occupancy = MarketManager.getOccupancyRate(market.getName()) * 100.0;
            int[] stats = MarketManager.getMarketStats(market.getName());
            info.append("\u00a7e").append(market.getName());
            info.append(" \u00a77(").append(stats[1]).append("/").append(stats[0]).append(" rented, ");
            info.append(String.format("%.0f%%", occupancy)).append(")\n");
            info.append("  \u00a7bCurrent: \u00a7e").append(currentPrice).append(" karma/week");
            info.append(" \u00a77(floor: ").append(market.getFloorPrice());
            info.append(", ceiling: ").append(market.getCeilingPrice()).append(")\n");
        }
        RegionCommandHelper.sendSuccess(ctx, (Component)Component.literal((String)info.toString()));
        return markets.size();
    }

    private static int executeMarketInfo(CommandContext<CommandSourceStack> ctx) {
        String name = StringArgumentType.getString(ctx, (String)"name");
        MarketConfig market = MarketManager.getMarket(name);
        if (market == null) {
            RegionCommandHelper.sendFailure(ctx, new CommandMessageBuilder().error("\u2717 Market '").highlight(name).error("' not found.").build());
            return 0;
        }
        int currentPrice = MarketManager.getCurrentPrice(name);
        double occupancy = MarketManager.getOccupancyRate(name) * 100.0;
        int[] stats = MarketManager.getMarketStats(name);
        Set<String> regions = MarketManager.getRegionsInMarket(name);
        StringBuilder info = new StringBuilder();
        info.append("\u00a7b=== Market Info: \u00a7e").append(name).append("\u00a7b ===\n");
        info.append("\u00a7bFloor Price: \u00a7e").append(market.getFloorPrice()).append(" karma/week\n");
        info.append("\u00a7bCeiling Price: \u00a7e").append(market.getCeilingPrice()).append(" karma/week\n");
        info.append("\u00a7bPrice Exponent: \u00a7e").append(String.format("%.2f", market.getPriceExponent())).append("\n\n");
        info.append("\u00a7bCurrent Price: \u00a7e").append(currentPrice).append(" karma/week\n");
        info.append("\u00a7bOccupancy: \u00a7e").append(String.format("%.1f%%", occupancy));
        info.append(" \u00a77(").append(stats[1]).append(" / ").append(stats[0]).append(" rented)\n\n");
        if (!regions.isEmpty()) {
            info.append("\u00a7bRegions (").append(regions.size()).append("):\n");
            for (String regionName : regions) {
                boolean isRented = RegionRental.isRented(regionName);
                info.append("  \u00a77\u2022 \u00a7e").append(regionName);
                if (isRented) {
                    info.append(" \u00a7a(rented)");
                } else {
                    info.append(" \u00a77(available)");
                }
                info.append("\n");
            }
        } else {
            info.append("\u00a77No regions in this market yet.\n");
            info.append("\u00a77Use \u00a7b/region edit <name> tag add rentable:").append(name).append("\u00a77 to add regions.");
        }
        RegionCommandHelper.sendSuccess(ctx, (Component)Component.literal((String)info.toString()));
        return 1;
    }

    private static int executeMarketSetFloor(CommandContext<CommandSourceStack> ctx) {
        int price;
        String name = StringArgumentType.getString(ctx, (String)"name");
        if (MarketManager.updateMarketConfig(name, price = IntegerArgumentType.getInteger(ctx, (String)"price"), -1, -1.0)) {
            RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().success("\u2713 Set floor price for market '").highlight(name).success("' to ").value(String.valueOf(price)).success(" karma/week.").build(), true);
            return 1;
        }
        RegionCommandHelper.sendFailure(ctx, new CommandMessageBuilder().error("\u2717 Failed to update market '").highlight(name).error("'. Market may not exist or price may be invalid.").build());
        return 0;
    }

    private static int executeMarketSetCeiling(CommandContext<CommandSourceStack> ctx) {
        int price;
        String name = StringArgumentType.getString(ctx, (String)"name");
        if (MarketManager.updateMarketConfig(name, -1, price = IntegerArgumentType.getInteger(ctx, (String)"price"), -1.0)) {
            RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().success("\u2713 Set ceiling price for market '").highlight(name).success("' to ").value(String.valueOf(price)).success(" karma/week.").build(), true);
            return 1;
        }
        RegionCommandHelper.sendFailure(ctx, new CommandMessageBuilder().error("\u2717 Failed to update market '").highlight(name).error("'. Market may not exist or price may be invalid.").build());
        return 0;
    }

    private static int executeMarketSetExponent(CommandContext<CommandSourceStack> ctx) {
        double exponent;
        String name = StringArgumentType.getString(ctx, (String)"name");
        if (MarketManager.updateMarketConfig(name, -1, -1, exponent = DoubleArgumentType.getDouble(ctx, (String)"value"))) {
            RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().success("\u2713 Set price exponent for market '").highlight(name).success("' to ").value(String.format("%.2f", exponent)).success(".").build(), true);
            return 1;
        }
        RegionCommandHelper.sendFailure(ctx, new CommandMessageBuilder().error("\u2717 Failed to update market '").highlight(name).error("'.").build());
        return 0;
    }

    private static int executeRentRegionInternal(CommandContext<CommandSourceStack> ctx, String regionName, int weeks) throws CommandSyntaxException {
        ServerPlayer player = RegionCommandHelper.getPlayerOrFail(ctx);
        if (player == null) {
            return 0;
        }
        RegionRental.RentResult result = RegionRental.rentRegion(regionName, player, weeks);
        if (result.isSuccess()) {
            RegionCommandHelper.sendSuccess(ctx, CommandMessageBuilder.successMsg(result.getMessage()), true);
            return 1;
        }
        RegionCommandHelper.sendFailure(ctx, CommandMessageBuilder.errorMsg(result.getMessage()));
        return 0;
    }
}

