/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.regions.market;

public class MarketConfig {
    private final String name;
    private int floorPrice;
    private int ceilingPrice;
    private double priceExponent;
    private String description;

    public MarketConfig(String name, int floorPrice, int ceilingPrice, double priceExponent, String description) {
        this.name = name;
        this.floorPrice = floorPrice;
        this.ceilingPrice = ceilingPrice;
        this.priceExponent = priceExponent;
        this.description = description;
    }

    public int calculateCurrentPrice(int totalRegions, int rentedRegions) {
        if (totalRegions == 0) {
            return this.floorPrice;
        }
        double occupancyRate = (double)rentedRegions / (double)totalRegions;
        double priceRange = this.ceilingPrice - this.floorPrice;
        int dynamicPrice = this.floorPrice + (int)(priceRange * Math.pow(occupancyRate, this.priceExponent));
        return Math.max(this.floorPrice, Math.min(this.ceilingPrice, dynamicPrice));
    }

    public String getName() {
        return this.name;
    }

    public int getFloorPrice() {
        return this.floorPrice;
    }

    public int getCeilingPrice() {
        return this.ceilingPrice;
    }

    public double getPriceExponent() {
        return this.priceExponent;
    }

    public String getDescription() {
        return this.description;
    }

    public void setFloorPrice(int floorPrice) {
        if (floorPrice < 0) {
            throw new IllegalArgumentException("Floor price cannot be negative");
        }
        if (floorPrice > this.ceilingPrice) {
            throw new IllegalArgumentException("Floor price cannot exceed ceiling price");
        }
        this.floorPrice = floorPrice;
    }

    public void setCeilingPrice(int ceilingPrice) {
        if (ceilingPrice < this.floorPrice) {
            throw new IllegalArgumentException("Ceiling price cannot be less than floor price");
        }
        this.ceilingPrice = ceilingPrice;
    }

    public void setPriceExponent(double priceExponent) {
        if (priceExponent <= 0.0) {
            throw new IllegalArgumentException("Price exponent must be positive");
        }
        this.priceExponent = priceExponent;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return String.format("Market{name='%s', floor=%d, ceiling=%d, exponent=%.2f}", this.name, this.floorPrice, this.ceilingPrice, this.priceExponent);
    }
}

