/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.regions.util;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import world.landfall.landfallessentials.regions.Region;
import world.landfall.landfallessentials.regions.RegionManager;
import world.landfall.landfallessentials.regions.util.CommandMessageBuilder;

public class RegionCommandHelper {
    public static Region getRegionOrFail(CommandContext<CommandSourceStack> ctx, String paramName) {
        String name = StringArgumentType.getString(ctx, (String)paramName);
        Region region = RegionManager.getRegion(name);
        if (region == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure(new CommandMessageBuilder().error("\u2717 Region '").highlight(name).error("' does not exist.").build());
        }
        return region;
    }

    public static ServerPlayer getPlayerOrFail(CommandContext<CommandSourceStack> ctx) {
        try {
            return ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        }
        catch (CommandSyntaxException e) {
            ((CommandSourceStack)ctx.getSource()).sendFailure(CommandMessageBuilder.errorMsg("\u2717 This command can only be used by players."));
            return null;
        }
    }

    public static boolean isValidRegionName(String name) {
        if (name == null || name.trim().isEmpty()) {
            return false;
        }
        return name.matches("^[a-zA-Z0-9_-]+$");
    }

    public static boolean validateRegionName(CommandContext<CommandSourceStack> ctx, String name) {
        if (!RegionCommandHelper.isValidRegionName(name)) {
            ((CommandSourceStack)ctx.getSource()).sendFailure(new CommandMessageBuilder().error("\u2717 Invalid region name '").highlight(name).error("'. Use only letters, numbers, underscores, and hyphens.").build());
            return false;
        }
        return true;
    }

    public static boolean ensureRegionDoesNotExist(CommandContext<CommandSourceStack> ctx, String name) {
        if (RegionManager.getRegion(name) != null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure(new CommandMessageBuilder().error("\u2717 Region '").highlight(name).error("' already exists.").build());
            return false;
        }
        return true;
    }

    public static String formatPos(BlockPos pos) {
        return String.format("(%d, %d, %d)", pos.getX(), pos.getY(), pos.getZ());
    }

    public static String formatDimension(ResourceLocation dimension) {
        if ("minecraft".equals(dimension.getNamespace())) {
            return dimension.getPath();
        }
        return dimension.toString();
    }

    public static void sendSuccess(CommandContext<CommandSourceStack> ctx, Component message, boolean broadcast) {
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> message, broadcast);
    }

    public static void sendSuccess(CommandContext<CommandSourceStack> ctx, Component message) {
        RegionCommandHelper.sendSuccess(ctx, message, false);
    }

    public static void sendFailure(CommandContext<CommandSourceStack> ctx, Component message) {
        ((CommandSourceStack)ctx.getSource()).sendFailure(message);
    }

    public static Component createClickableRegionName(String regionName, String suggestedCommand) {
        return Component.literal((String)regionName).withStyle(ChatFormatting.YELLOW).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, suggestedCommand)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to suggest command"))));
    }
}

