/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.registry;

import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import world.landfall.landfallessentials.registry.ModItems;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"landfallessentials");

    public static DeferredBlock<Block> registerSimpleBlock(String name, MapColor mapColor) {
        return BLOCKS.registerSimpleBlock(name, BlockBehaviour.Properties.of().mapColor(mapColor));
    }

    public static DeferredBlock<Block> registerBlock(String name, BlockBehaviour.Properties properties) {
        return BLOCKS.registerSimpleBlock(name, properties);
    }

    public static <T extends Block> DeferredBlock<T> registerCustomBlock(String name, Supplier<T> blockSupplier) {
        return BLOCKS.register(name, blockSupplier);
    }

    public static DeferredBlock<Block> registerStoneBlock(String name, MapColor mapColor) {
        return BLOCKS.registerSimpleBlock(name, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).mapColor(mapColor));
    }

    public static <T extends Block> DeferredBlock<T> registerCustomStoneBlock(String name, Supplier<T> blockSupplier) {
        return BLOCKS.register(name, blockSupplier);
    }

    public static DeferredBlock<Block> registerWoodBlock(String name, MapColor mapColor) {
        return BLOCKS.registerSimpleBlock(name, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).mapColor(mapColor));
    }

    public static DeferredBlock<Block> registerMetalBlock(String name, MapColor mapColor) {
        return BLOCKS.registerSimpleBlock(name, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).mapColor(mapColor));
    }

    public static DeferredBlock<Block> registerGlassBlock(String name, MapColor mapColor) {
        return BLOCKS.registerSimpleBlock(name, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).mapColor(mapColor));
    }

    public static DeferredItem<BlockItem> registerBlockItem(String name, DeferredBlock<? extends Block> block) {
        return ModItems.ITEMS.registerSimpleBlockItem(name, block);
    }

    public static DeferredItem<BlockItem> registerBlockItem(String name, DeferredBlock<? extends Block> block, Item.Properties properties) {
        return ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), properties));
    }
}

