/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.util;

import java.util.UUID;
import net.neoforged.fml.loading.FMLEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuckPermsUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(LuckPermsUtil.class);
    private static boolean luckPermsAvailable = false;
    private static boolean checkedAvailability = false;
    private static Object luckPermsAPI = null;

    public static synchronized void initialize() {
        if (checkedAvailability) {
            return;
        }
        if (FMLEnvironment.dist.isClient()) {
            LOGGER.debug("Skipping LuckPerms initialization on client side");
            checkedAvailability = true;
            return;
        }
        try {
            Class<?> luckPermsProviderClass = Class.forName("net.luckperms.api.LuckPermsProvider");
            luckPermsAPI = luckPermsProviderClass.getMethod("get", new Class[0]).invoke(null, new Object[0]);
            if (luckPermsAPI != null) {
                luckPermsAvailable = true;
                LOGGER.info("LuckPerms API integration enabled.");
            } else {
                LOGGER.info("LuckPerms API provider returned null.");
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.info("LuckPerms not found. Permission-based features requiring LuckPerms will be disabled.");
        }
        catch (IllegalStateException e) {
            LOGGER.info("LuckPerms API not loaded yet. Permission-based features requiring LuckPerms will be disabled.");
        }
        catch (Exception e) {
            LOGGER.warn("Failed to initialize LuckPerms integration. Permission-based features will be disabled.", (Throwable)e);
        }
        checkedAvailability = true;
    }

    public static boolean isAvailable() {
        if (FMLEnvironment.dist.isClient()) {
            return false;
        }
        if (!checkedAvailability) {
            LuckPermsUtil.initialize();
        }
        return luckPermsAvailable;
    }

    public static Object getLuckPermsAPI() {
        if (!LuckPermsUtil.isAvailable()) {
            return null;
        }
        return luckPermsAPI;
    }

    public static Object getUser(UUID playerUUID) {
        if (!LuckPermsUtil.isAvailable() || playerUUID == null) {
            return null;
        }
        try {
            Object userManager = luckPermsAPI.getClass().getMethod("getUserManager", new Class[0]).invoke(luckPermsAPI, new Object[0]);
            Object userFuture = userManager.getClass().getMethod("loadUser", UUID.class).invoke(userManager, playerUUID);
            return userFuture.getClass().getMethod("join", new Class[0]).invoke(userFuture, new Object[0]);
        }
        catch (Exception e) {
            LOGGER.warn("Error getting LuckPerms user for UUID: " + String.valueOf(playerUUID), (Throwable)e);
            return null;
        }
    }

    public static Object getPermissionData(Object user) {
        if (user == null) {
            return null;
        }
        try {
            Object cachedData = user.getClass().getMethod("getCachedData", new Class[0]).invoke(user, new Object[0]);
            return cachedData.getClass().getMethod("getPermissionData", new Class[0]).invoke(cachedData, new Object[0]);
        }
        catch (Exception e) {
            LOGGER.warn("Error getting LuckPerms permission data.", (Throwable)e);
            return null;
        }
    }

    public static Object getMetaData(Object user) {
        if (user == null) {
            return null;
        }
        try {
            Object cachedData = user.getClass().getMethod("getCachedData", new Class[0]).invoke(user, new Object[0]);
            return cachedData.getClass().getMethod("getMetaData", new Class[0]).invoke(cachedData, new Object[0]);
        }
        catch (Exception e) {
            LOGGER.warn("Error getting LuckPerms meta data.", (Throwable)e);
            return null;
        }
    }

    public static String getMetaValue(Object metaDataObject, String key) {
        if (metaDataObject == null || key == null) {
            return null;
        }
        try {
            return (String)metaDataObject.getClass().getMethod("getMetaValue", String.class).invoke(metaDataObject, key);
        }
        catch (Exception e) {
            LOGGER.warn("Error getting LuckPerms meta value for key: " + key, (Throwable)e);
            return null;
        }
    }

    public static boolean checkPermission(Object permissionDataObject, String permissionNode) {
        if (permissionDataObject == null || permissionNode == null) {
            return false;
        }
        try {
            Object tristate = permissionDataObject.getClass().getMethod("checkPermission", String.class).invoke(permissionDataObject, permissionNode);
            return tristate != null && tristate.toString().equals("TRUE");
        }
        catch (Exception e) {
            LOGGER.warn("Error checking LuckPerms permission: " + permissionNode, (Throwable)e);
            return false;
        }
    }

    public static boolean hasPermission(UUID playerUUID, String permissionNode) {
        if (!LuckPermsUtil.isAvailable() || playerUUID == null || permissionNode == null) {
            return false;
        }
        Object user = LuckPermsUtil.getUser(playerUUID);
        if (user == null) {
            return false;
        }
        Object permissionData = LuckPermsUtil.getPermissionData(user);
        if (permissionData == null) {
            return false;
        }
        return LuckPermsUtil.checkPermission(permissionData, permissionNode);
    }
}

