/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.util;

import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidationUtil.class);
    public static final int MAX_REGION_NAME_LENGTH = 32;
    public static final int MAX_TAG_LENGTH = 64;
    public static final int MAX_MESSAGE_LENGTH = 256;
    public static final int MAX_SOUND_ID_LENGTH = 128;
    public static final int MAX_PERMISSION_LENGTH = 128;
    private static final Pattern REGION_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_-]+$");
    private static final Pattern TAG_PATTERN = Pattern.compile("^[a-zA-Z0-9_:-]+$");
    private static final Pattern PERMISSION_PATTERN = Pattern.compile("^[a-zA-Z0-9._-]+$");
    private static final Pattern UUID_PATTERN = Pattern.compile("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$");

    public static boolean isValidRegionName(String name) {
        if (name == null || name.isEmpty()) {
            LOGGER.debug("Region name validation failed: null or empty");
            return false;
        }
        if (name.length() > 32) {
            LOGGER.debug("Region name validation failed: too long ({})", (Object)name.length());
            return false;
        }
        if (!REGION_NAME_PATTERN.matcher(name).matches()) {
            LOGGER.debug("Region name validation failed: invalid characters in '{}'", (Object)name);
            return false;
        }
        if (ValidationUtil.isReservedName(name)) {
            LOGGER.debug("Region name validation failed: reserved name '{}'", (Object)name);
            return false;
        }
        return true;
    }

    public static boolean isValidTag(String tag) {
        if (tag == null || tag.isEmpty()) {
            return false;
        }
        if (tag.length() > 64) {
            LOGGER.debug("Tag validation failed: too long ({})", (Object)tag.length());
            return false;
        }
        return TAG_PATTERN.matcher(tag).matches();
    }

    public static boolean isValidPermission(String permission) {
        if (permission == null || permission.isEmpty()) {
            return false;
        }
        if (permission.length() > 128) {
            LOGGER.debug("Permission validation failed: too long ({})", (Object)permission.length());
            return false;
        }
        return PERMISSION_PATTERN.matcher(permission).matches();
    }

    public static boolean isValidUUID(String uuid) {
        if (uuid == null || uuid.length() != 36) {
            return false;
        }
        return UUID_PATTERN.matcher(uuid).matches();
    }

    public static boolean isValidMessage(String message) {
        if (message == null) {
            return false;
        }
        if (message.length() > 256) {
            LOGGER.debug("Message validation failed: too long ({})", (Object)message.length());
            return false;
        }
        if (ValidationUtil.containsControlCharacters(message)) {
            LOGGER.debug("Message validation failed: contains control characters");
            return false;
        }
        return true;
    }

    public static boolean isValidSoundId(String soundId) {
        if (soundId == null || soundId.isEmpty()) {
            return false;
        }
        if (soundId.length() > 128) {
            LOGGER.debug("Sound ID validation failed: too long ({})", (Object)soundId.length());
            return false;
        }
        return soundId.matches("^[a-z0-9_.-]+:[a-z0-9_./.-]+$");
    }

    public static String sanitizeForDisplay(String input) {
        if (input == null) {
            return "";
        }
        Object sanitized = input.replaceAll("[\\x00-\\x08\\x0B-\\x0C\\x0E-\\x1F\\x7F]", "");
        if (((String)sanitized).length() > 256) {
            sanitized = ((String)sanitized).substring(0, 256) + "...";
        }
        return sanitized;
    }

    private static boolean isReservedName(String name) {
        String lowerName = name.toLowerCase();
        return lowerName.equals("all") || lowerName.equals("global") || lowerName.equals("world") || lowerName.equals("spawn") || lowerName.equals("default");
    }

    private static boolean containsControlCharacters(String str) {
        for (char c : str.toCharArray()) {
            if (c == '\u00a7' || !Character.isISOControl(c) || c == '\n' || c == '\r') continue;
            return true;
        }
        return false;
    }

    public static boolean areValidCoordinates(int x, int y, int z) {
        int MAX_COORD = 30000000;
        int MIN_Y = -64;
        int MAX_Y = 320;
        if (Math.abs(x) > 30000000 || Math.abs(z) > 30000000) {
            LOGGER.debug("Coordinates validation failed: x or z out of bounds");
            return false;
        }
        if (y < -64 || y > 320) {
            LOGGER.debug("Coordinates validation failed: y out of bounds");
            return false;
        }
        return true;
    }
}

