/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials;

import com.mojang.logging.LogUtils;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import java.util.UUID;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;
import world.landfall.landfallessentials.Config;
import world.landfall.landfallessentials.api.karma.IKarmaAPI;
import world.landfall.landfallessentials.api.karma.KarmaAPI;
import world.landfall.landfallessentials.client.ClientStartupHandler;
import world.landfall.landfallessentials.content.RegisteredItems;
import world.landfall.landfallessentials.death.DeathEventHandler;
import world.landfall.landfallessentials.event.MobSpawnHandler;
import world.landfall.landfallessentials.fluid.AllFluids;
import world.landfall.landfallessentials.home.HomeSystem;
import world.landfall.landfallessentials.karma.KarmaSystem;
import world.landfall.landfallessentials.moderation.ModerationManager;
import world.landfall.landfallessentials.regions.RegionManager;
import world.landfall.landfallessentials.regions.RegionRental;
import world.landfall.landfallessentials.registry.ModBlockEntities;
import world.landfall.landfallessentials.registry.ModBlocks;
import world.landfall.landfallessentials.registry.ModCreativeTabs;
import world.landfall.landfallessentials.registry.ModEntityTypes;
import world.landfall.landfallessentials.registry.ModItems;
import world.landfall.landfallessentials.seen.SeenManager;
import world.landfall.landfallessentials.tpa.TPAManager;

@Mod(value="landfallessentials")
public class Landfallessentials {
    public static final String MODID = "landfallessentials";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static IKarmaAPI karmaAPI;
    public static final CreateRegistrate REGISTRATE;

    public static IKarmaAPI getKarmaAPI() {
        return karmaAPI;
    }

    public static LangBuilder lang() {
        return new LangBuilder(MODID);
    }

    public Landfallessentials(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        REGISTRATE.registerEventListeners(modEventBus);
        AllFluids.register();
        ModItems.ITEMS.register(modEventBus);
        ModBlocks.BLOCKS.register(modEventBus);
        ModBlockEntities.BLOCK_ENTITIES.register(modEventBus);
        ModEntityTypes.ENTITY_TYPES.register(modEventBus);
        ModCreativeTabs.CREATIVE_MODE_TABS.register(modEventBus);
        RegisteredItems.init();
        NeoForge.EVENT_BUS.register((Object)this);
        NeoForge.EVENT_BUS.register(KarmaSystem.class);
        NeoForge.EVENT_BUS.register(HomeSystem.class);
        NeoForge.EVENT_BUS.register(SeenManager.class);
        NeoForge.EVENT_BUS.register(DeathEventHandler.class);
        NeoForge.EVENT_BUS.register(RegionRental.class);
        SeenManager.initialize();
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        karmaAPI = KarmaAPI.getInstance();
        LOGGER.info("Landfall Essentials mod loaded successfully!");
        LOGGER.info("Karma API initialized and ready for use by other mods");
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Landfall Essentials server starting");
        RegionManager.initialize();
        RegionRental.initialize();
        MobSpawnHandler.updateSpawnControlFlags();
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player;
        if (FMLEnvironment.dist.isClient()) {
            return;
        }
        if (event.getEntity() != null && (player = event.getEntity()) instanceof Player) {
            Player player2 = player;
            UUID playerUUID = player2.getUUID();
            String playerUUIDString = playerUUID.toString();
            ModerationManager.removePlayerModData(playerUUID);
            RegionManager.cleanupPlayerData(playerUUIDString);
            KarmaSystem.cleanupPlayerData(playerUUID);
            TPAManager.getInstance().cleanupPlayerData(playerUUID);
            if (karmaAPI instanceof KarmaAPI) {
                ((KarmaAPI)karmaAPI).cleanupPlayer(playerUUID);
            }
            LOGGER.debug("Cleaned up all data for disconnected player: {}", (Object)player2.getName().getString());
        }
    }

    static {
        REGISTRATE = CreateRegistrate.create((String)MODID).setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
    }

    @EventBusSubscriber(modid="landfallessentials", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("Landfall Essentials client setup complete");
            event.enqueueWork(() -> NeoForge.EVENT_BUS.register((Object)new ClientStartupHandler()));
        }
    }
}

