/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.api.karma;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;

public class KarmaTransaction {
    private final UUID playerUUID;
    private final long transactionId;
    private final long startTime;
    private final List<Operation> operations;
    private int initialKarma;
    private boolean committed;
    private boolean rolledBack;

    public KarmaTransaction(UUID playerUUID, int initialKarma) {
        this.playerUUID = playerUUID;
        this.transactionId = System.nanoTime();
        this.startTime = System.currentTimeMillis();
        this.operations = new ArrayList<Operation>();
        this.initialKarma = initialKarma;
        this.committed = false;
        this.rolledBack = false;
    }

    public KarmaTransaction add(int amount, @Nullable String description) {
        this.validateState();
        if (amount <= 0) {
            throw new IllegalArgumentException("Amount to add must be positive");
        }
        this.operations.add(new Operation(Operation.Type.ADD, amount, description));
        return this;
    }

    public KarmaTransaction remove(int amount, @Nullable String description) {
        this.validateState();
        if (amount <= 0) {
            throw new IllegalArgumentException("Amount to remove must be positive");
        }
        this.operations.add(new Operation(Operation.Type.REMOVE, amount, description));
        return this;
    }

    public KarmaTransaction set(int amount, @Nullable String description) {
        this.validateState();
        if (amount < 0) {
            throw new IllegalArgumentException("Karma cannot be set to negative value");
        }
        this.operations.add(new Operation(Operation.Type.SET, amount, description));
        return this;
    }

    public int calculateFinalKarma() {
        int karma = this.initialKarma;
        for (Operation op : this.operations) {
            switch (op.getType().ordinal()) {
                case 0: {
                    karma += op.getAmount();
                    break;
                }
                case 1: {
                    karma = Math.max(0, karma - op.getAmount());
                    break;
                }
                case 2: {
                    karma = op.getAmount();
                }
            }
        }
        return karma;
    }

    public boolean wouldResultInNegativeKarma() {
        return this.calculateFinalKarma() < 0;
    }

    public int getNetChange() {
        return this.calculateFinalKarma() - this.initialKarma;
    }

    private void validateState() {
        if (this.committed) {
            throw new IllegalStateException("Transaction has already been committed");
        }
        if (this.rolledBack) {
            throw new IllegalStateException("Transaction has already been rolled back");
        }
    }

    public void markCommitted() {
        this.committed = true;
    }

    public void markRolledBack() {
        this.rolledBack = true;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public List<Operation> getOperations() {
        return new ArrayList<Operation>(this.operations);
    }

    public int getInitialKarma() {
        return this.initialKarma;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public boolean isRolledBack() {
        return this.rolledBack;
    }

    public boolean isEmpty() {
        return this.operations.isEmpty();
    }

    public int getOperationCount() {
        return this.operations.size();
    }

    public String toString() {
        return String.format("KarmaTransaction[id=%d, player=%s, operations=%d, netChange=%+d, status=%s]", this.transactionId, this.playerUUID, this.operations.size(), this.getNetChange(), this.committed ? "COMMITTED" : (this.rolledBack ? "ROLLED_BACK" : "PENDING"));
    }

    public static class Operation {
        private final Type type;
        private final int amount;
        private final String description;
        private final long timestamp;

        public Operation(Type type, int amount, @Nullable String description) {
            this.type = type;
            this.amount = amount;
            this.description = description != null ? description : "";
            this.timestamp = System.currentTimeMillis();
        }

        public Type getType() {
            return this.type;
        }

        public int getAmount() {
            return this.amount;
        }

        public String getDescription() {
            return this.description;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public static enum Type {
            ADD,
            REMOVE,
            SET;

        }
    }
}

