/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import world.landfall.landfallessentials.block.custom.ShonkBlock;

public abstract class ShonkBlockEntity
extends BlockEntity {
    private static final int EFFECT_INTERVAL = 20;
    private int tickCounter = 0;

    public ShonkBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public void tick() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter >= 20) {
            this.tickCounter = 0;
            this.applyEffects();
        }
    }

    private void applyEffects() {
        Block block = this.getBlockState().getBlock();
        if (block instanceof ShonkBlock) {
            ShonkBlock shonkBlock = (ShonkBlock)block;
            shonkBlock.applyAreaEffects(this.level, this.getBlockPos());
        }
    }

    protected void onTick() {
    }
}

