/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import world.landfall.landfallessentials.Config;
import world.landfall.landfallessentials.death.DeathData;
import world.landfall.landfallessentials.death.DeathLocation;
import world.landfall.landfallessentials.karma.KarmaSystem;
import world.landfall.landfallessentials.util.LuckPermsUtil;

public class BackCommand {
    private static final String PERMISSION_NODE = "landfallessentials.command.back";

    private static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"back").requires(source -> {
            if (source.getPlayer() != null) {
                return LuckPermsUtil.hasPermission(source.getPlayer().getUUID(), PERMISSION_NODE);
            }
            return false;
        })).executes(BackCommand::executeBack));
    }

    private static int executeBack(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ServerLevel serverLevel = player.serverLevel();
        DeathData deathData = DeathData.get(serverLevel);
        DeathLocation lastDeathLocation = deathData.getDeathLocation(player.getUUID());
        if (lastDeathLocation == null) {
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7cYou have no previous death location recorded."));
            return 0;
        }
        int karmaCost = Config.backCommandKarmaCost;
        if (karmaCost > 0 && !KarmaSystem.hasEnoughKarma((Player)player, karmaCost)) {
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7cYou do not have enough karma to use /back. Cost: " + karmaCost + " karma.")));
            return 0;
        }
        ServerLevel targetLevel = player.getServer().getLevel(lastDeathLocation.dimension());
        if (targetLevel == null) {
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7cError: Could not find the dimension of your last death. It may no longer exist."));
            return 0;
        }
        player.teleportTo(targetLevel, lastDeathLocation.x(), lastDeathLocation.y(), lastDeathLocation.z(), player.getYRot(), player.getXRot());
        if (karmaCost > 0) {
            KarmaSystem.removeKarma((Player)player, karmaCost);
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7aTeleported back to your last death location. " + karmaCost + " karma deducted.")));
        } else {
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7aTeleported back to your last death location."));
        }
        deathData.clearDeathLocation(player.getUUID());
        return 1;
    }
}

